<?php
/**
 * Plugin Name:       Custom Drill-Down Category Filter
 * Description:       Provides an advanced, Elementor-integrated drill-down category filter that can target a specific JetEngine grid.
 * Version:           7.0.4
 * Author:            Your Name
 * Author URI:        https://yourwebsite.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       custom-drilldown-filter
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// CRITICAL FIX: Updated version number to force cache busting.
define( 'CUSTOM_FILTER_PLUGIN_VERSION', '7.0.4' );
define( 'CUSTOM_FILTER_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'CUSTOM_FILTER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * The main plugin class.
 */
final class Custom_Drilldown_Filter_Plugin {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        $this->includes();
        $this->register_hooks();
    }

    private function includes() {
        require_once CUSTOM_FILTER_PLUGIN_PATH . 'includes/settings-page.php';
    }

    private function register_hooks() {
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
        add_action( 'elementor/widgets/register', [ $this, 'register_elementor_widget' ] );
        add_action( 'elementor/elements/categories_registered', [ $this, 'add_elementor_widget_category' ] );
    }

    public function enqueue_scripts() {
        wp_register_style(
            'custom-category-filter-css',
            CUSTOM_FILTER_PLUGIN_URL . 'assets/css/custom-filter.css',
            [],
            CUSTOM_FILTER_PLUGIN_VERSION // Uses the updated version number
        );

        wp_register_script(
            'custom-category-filter-js',
            CUSTOM_FILTER_PLUGIN_URL . 'assets/js/custom-filter.js',
            ['jquery'],
            CUSTOM_FILTER_PLUGIN_VERSION, // Uses the updated version number
            true
        );

        wp_localize_script( 'custom-category-filter-js', 'customFilterAjax', [
            'ajaxUrl' => admin_url( 'admin-ajax.php' ),
            'nonce'   => wp_create_nonce('custom-filter-nonce')
        ]);
    }

    public function register_elementor_widget( $widgets_manager ) {
        require_once CUSTOM_FILTER_PLUGIN_PATH . 'includes/elementor-widget.php';
        $widgets_manager->register( new \Elementor_Custom_Drilldown_Filter_Widget() );
    }

    public function add_elementor_widget_category( $elements_manager ) {
        $elements_manager->add_category(
            'custom-filters',
            [
                'title' => __( 'Custom Filters', 'custom-drilldown-filter' ),
                'icon'  => 'fa fa-filter',
            ]
        );
    }
}

Custom_Drilldown_Filter_Plugin::instance();
