
// Custom Checkout – Admin JS (tabs + field builder)
// v1.4.0 – uses external SVG files, default tab, robust panel toggling
jQuery(function ($) {
  'use strict';

  // --------- Config: image base URL (localized in PHP); fallback is a no-op
  var IMG = (window.CCAdmin && CCAdmin.imgUrl) ? CCAdmin.imgUrl.replace(/\/$/, '') : '';
  function iconImg(name){
    if (!IMG) return $('<span/>'); // graceful if not localized yet
    return $('<img/>', { src: IMG + '/' + name, width: 16, height: 16, alt: '', 'aria-hidden': 'true' });
  }

  // --------- Tabs
  function activateTab(tab) {
    // highlight tab
    $('.cc-tab').removeClass('is-active');
    $('.cc-tab[data-tab="' + tab + '"]').addClass('is-active');
    // show only matching panel
    $('.cc-panel').removeClass('is-active').hide();
    var $panel = $('.cc-panel[data-panel="' + tab + '"]').addClass('is-active').show();
    try { localStorage.setItem('cc_active_tab', tab); } catch (e) {}
  }

  // default tab = general
  var last = null;
  try { last = localStorage.getItem('cc_active_tab'); } catch (e) {}
  var firstTab = $('.cc-tab').first().data('tab') || 'general';
  var initialTab = last || firstTab || 'general';
  activateTab(initialTab);

  $(document).on('click', '.cc-tab', function (e) {
    e.preventDefault();
    var tab = $(this).data('tab');
    activateTab(tab);
  });

  // --------- Field Builder controls
  function iconBtn(cls, iconFile, label) {
    var $b = $('<button/>', { type: 'button', 'class': cls, 'aria-label': label });
    $b.append(iconImg(iconFile)).append($('<span/>', { 'class': 'screen-reader-text', text: label }));
    return $b;
  }

  function addRow(section) {
    var $tbody = $('.cc-table[data-section="' + section + '"]').find('tbody');
    var idx = $tbody.find('tr').length;

    var $tr = $('<tr/>');

    var $order = $('<td/>', { 'class': 'cc-order cc-col-order' })
      .append(iconBtn('cc-up', 'chevron-up.svg', 'Move up'))
      .append(iconBtn('cc-down', 'chevron-down.svg', 'Move down'));

    var $label = $('<td/>', { 'class': 'cc-col-label' })
      .append($('<input/>', { type: 'text', name: 'fields[' + section + '][' + idx + '][label]' }));

    var $key   = $('<td/>', { 'class': 'cc-col-key' })
      .append($('<input/>', { type: 'text', name: 'fields[' + section + '][' + idx + '][key]' }));

    var $typeSel = $('<select/>', { name: 'fields[' + section + '][' + idx + '][type]' });
    ['text','email','tel','textarea','select','checkbox','date','country'].forEach(function (t) {
      $typeSel.append($('<option/>', { value: t, text: t }));
    });
    var $type = $('<td/>', { 'class': 'cc-col-type' }).append($typeSel);

    var $req = $('<td/>', { 'class': 'cc-center cc-col-req' })
      .append($('<input/>', { type: 'checkbox', value: '1', name: 'fields[' + section + '][' + idx + '][required]' }));

    var $en  = $('<td/>', { 'class': 'cc-center cc-col-en' })
      .append($('<input/>', { type: 'checkbox', value: '1', checked: true, name: 'fields[' + section + '][' + idx + '][enabled]' }));

    var $widthSel = $('<select/>', { name: 'fields[' + section + '][' + idx + '][width]' })
      .append($('<option/>', { value: 'full', text: 'full' }))
      .append($('<option/>', { value: '1/2', text: '1/2' }))
      .append($('<option/>', { value: '1/3', text: '1/3' }));
    var $width = $('<td/>', { 'class': 'cc-col-width' }).append($widthSel);

    var $remove = $('<td/>', { 'class': 'cc-col-actions' })
      .append(iconBtn('cc-remove', 'x.svg', 'Remove'));

    $tr.append($order, $label, $key, $type, $req, $en, $width, $remove);
    $tbody.append($tr);
  }

  // Add row buttons
  $(document).on('click', '.cc-add', function (e) {
    e.preventDefault();
    addRow($(this).data('section'));
  });

  // Remove row
  $(document).on('click', '.cc-remove', function () {
    $(this).closest('tr').remove();
  });

  // Reorder
  $(document).on('click', '.cc-up', function () {
    var $tr = $(this).closest('tr');
    $tr.prev().before($tr);
  });
  $(document).on('click', '.cc-down', function () {
    var $tr = $(this).closest('tr');
    $tr.next().after($tr);
  });
});