jQuery(function ($) {
  'use strict';

  const API = (path) => `${CustomCheckout.restUrl}${path}`;

  // --- VISUAL: turn stepper into text tabs
  $('.cc-steps').addClass('cc-steps--text');

  // --- Gate navigation
  let allowStep2 = false;
  let allowStep3 = false;

  function setTabState(){
    $('#stepper-2').prop('disabled', !allowStep2);
    $('#stepper-3').prop('disabled', !allowStep3);
  }

  function setStep(step) {
    if (step === 2 && !allowStep2) return;
    if (step === 3 && !allowStep3) return;

    $('#step-1,#step-2,#step-3').addClass('is-hidden');
    $('#step-' + step).removeClass('is-hidden');

    $('#stepper-1,#stepper-2,#stepper-3')
      .removeClass('step-active').addClass('step-inactive')
      .attr('aria-selected','false');
    $('#stepper-' + step)
      .addClass('step-active').removeClass('step-inactive')
      .attr('aria-selected','true');

    if (step === 3) {
      $(document.body).trigger('update_checkout');
      setTimeout(function() {
        $('#place_order').appendTo('#step-3 .cc-actions');
      }, 100);
    }
  }

  async function save(section, data) {
    return $.ajax({
      url: API('/save'),
      method: 'POST',
      data: JSON.stringify({ section, data }),
      contentType: 'application/json',
      headers: { 'X-WP-Nonce': CustomCheckout.nonce },
      xhrFields: { withCredentials: true }
    });
  }

  function showError(step, message) {
    const $wrap = $('#step-' + step + ' .cc-inline-error');
    if ($wrap.length) { $wrap.text(message).show(); }
    else { $('<div class="cc-inline-error" role="alert" aria-live="polite"></div>').text(message).prependTo('#step-' + step); }
  }
  function clearError(step) { $('#step-' + step + ' .cc-inline-error').text('').hide(); }

  function collectSection(section) {
    const data = {};
    const $dataEls = $('[data-section="' + section + '"][data-key]');
    if ($dataEls.length) {
      $dataEls.each(function(){
        const $el = $(this); const key = $el.data('key');
        let val = '';
        if ($el.is('select')) val = $el.val();
        else if ($el.is(':checkbox')) val = $el.is(':checked') ? '1' : '';
        else val = $el.val();
        data[key] = (val || '').toString().trim();
      });
    } else {
      const prefix = section === 'extra' ? 'extra' : section;
      ['first_name','last_name','email','phone','company','address_1','address_2','city','state','postcode','country','county']
        .forEach(k => { const $el = $('#cc_' + prefix + '_' + k); if ($el.length) data[k] = ($el.val()||'').trim(); });
      if (section === 'shipping') data['order_comments'] = ($('#cc_order_comments').val()||'').trim();
    }
    return data;
  }

  function toggleShippingUI(mode) {
    if (mode === 'delivery') { $('#cc-shipping-fields, #cc-delivery-note').removeClass('is-hidden'); }
    else { $('#cc-shipping-fields, #cc-delivery-note').addClass('is-hidden'); }
  }

  async function chooseMode(mode) {
    $('#cc_fulfillment_mode').val(mode);
    $('.cc-mode-card').attr('aria-pressed', 'false').removeClass('selected');
    $('.cc-mode-card[data-mode="'+mode+'"]').attr('aria-pressed', 'true').addClass('selected');
    toggleShippingUI(mode);
    try {
      await save('mode', { fulfillment_mode: mode });
      // **FIX**: Removed $(document.body).trigger('update_checkout');
    }
    catch (e) { showError(2, (e?.responseJSON?.message) || 'Failed to save selection.'); }
  }

  async function prefillFromState() {
    try {
      const res = await $.ajax({ url: API('/state'), method: 'GET', xhrFields: { withCredentials: true } });
      if (!res || !res.ok || !res.saved) return;
      const s = res.saved; if (s.cc_fulfillment_mode) { chooseMode(s.cc_fulfillment_mode); }
      function apply(prefix) {
        Object.keys(s).forEach(function(k){
          if (k.indexOf(prefix + '_') !== 0) return;
          const short = k.substring((prefix + '_').length);
          const $el = $('#cc_' + prefix + '_' + short);
          if ($el.length && (s[k] !== '' && s[k] !== null && typeof s[k] !== 'undefined')) {
            if ($el.is('select')) $el.val(s[k]);
            else if ($el.is(':checkbox')) $el.prop('checked', s[k] === '1' || s[k] === 1 || s[k] === true);
            else if (!$el.val()) $el.val(s[k]);
          }
        });
      }
      apply('billing'); apply('shipping');
      if (s.order_comments && !$('#cc_order_comments').val()) $('#cc_order_comments').val(s.order_comments);
    } catch (e) { /* silent */ }
  }

  // --- Event Listeners ---
  allowStep2 = false; allowStep3 = false; setTabState();
  setStep(1);
  chooseMode('pickup');
  prefillFromState();

  $('#stepper-1').on('click', () => setStep(1));
  $('#stepper-2').on('click', () => setStep(2));
  $('#stepper-3').on('click', () => setStep(3));

  $('#to-step-2').on('click', async () => {
    clearError(1);
    const b = collectSection('billing');
    const required = ['first_name','last_name','email','address_1','city','postcode','country'];
    const missing = required.filter(k => !b[k]);
    if (missing.length) { showError(1, CustomCheckout.i18n?.billing_required || 'Please complete required billing fields.'); return; }
    try {
      await save('billing', b);
      // **FIX**: Removed $(document.body).trigger('update_checkout');
      allowStep2 = true;
      setTabState();
      setStep(2);
    }
    catch (e) { showError(1, (e?.responseJSON?.message) || 'Failed to save billing.'); }
  });

  $('#back-to-1').on('click', () => setStep(1));
  $(document).on('click', '#back-to-2', () => setStep(2));

  $('#to-step-3').on('click', async () => {
    clearError(2);
    const mode = $('#cc_fulfillment_mode').val();
    const shipData = collectSection('shipping');
    if (mode === 'delivery') {
      const rq = ['first_name','last_name','address_1','city','postcode','country'];
      if (rq.some(k => !shipData[k])) { showError(2, CustomCheckout.i18n?.shipping_required || 'Please complete required shipping address.'); return; }
    }
    const extraData = collectSection('extra');
    try {
      await save('shipping', Object.assign({ order_comments: $('#cc_order_comments').val() }, shipData));
      if (Object.keys(extraData).length) await save('extra', extraData);
      // **FIX**: Removed $(document.body).trigger('update_checkout');
      allowStep3 = true;
      setTabState();
      setStep(3);
    } catch (e) { showError(2, (e?.responseJSON?.message) || 'Failed to save shipping.'); }
  });

  $(document).on('click', '.cc-mode-card', function(){ chooseMode($(this).data('mode')); });

  $(document).on('click', '.cc-coupon-form button[name="apply_coupon"]', function() {
    const $button = $(this);
    const $formWrapper = $button.closest('.cc-coupon-form');
    const couponCode = $formWrapper.find('input[name="coupon_code"]').val();

    if (!couponCode) return;

    $button.prop('disabled', true).addClass('loading');
    $('.woocommerce-error, .woocommerce-message').remove();

    $.ajax({
      type: 'POST',
      url: CustomCheckout.ajax_url,
      data: {
        action: 'woocommerce_apply_coupon',
        security: wc_checkout_params.apply_coupon_nonce,
        coupon_code: couponCode
      },
      success: function (response) {
        $formWrapper.before(response);
        $formWrapper.find('input[name="coupon_code"]').val('');
        $(document.body).trigger('update_checkout');
      },
      complete: function () {
        $button.prop('disabled', false).removeClass('loading');
      }
    });
  });
});