<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class CC_Fields {
    public static function allowed_types() {
        return ['text','email','tel','textarea','select','checkbox','date','country'];
    }

    public static function defaults( $section ) {
        $opts = class_exists('CC_Options') ? CC_Options::get() : [];
        $set  = $opts['fields'][ $section ] ?? [];
        if ( empty( $set ) ) {
            if ( $section === 'billing' ) return CC_Options::default_billing_fields();
            if ( $section === 'shipping') return CC_Options::default_shipping_fields();
            return [];
        }
        return $set;
    }
}
