(function ($) {
	"use strict";
	
	window.qodefCore = {};
	qodefCore.shortcodes = {};
	
	qodefCore.body = $('body');
	qodefCore.html = $('html');
	qodefCore.windowWidth = $(window).width();
	qodefCore.windowHeight = $(window).height();
	qodefCore.scroll = 0;
	
	$(document).ready(function () {
		qodefCore.scroll = $(window).scrollTop();
		qodefInlinePageStyle.init();
	});
	
	$(window).resize(function () {
		qodefCore.windowWidth = $(window).width();
		qodefCore.windowHeight = $(window).height();
	});
	
	$(window).scroll(function () {
		qodefCore.scroll = $(window).scrollTop();
	});
	
	var qodefScroll = {
		disable: function(){
			if (window.addEventListener) {
				window.addEventListener('wheel', qodefScroll.preventDefaultValue, {passive: false});
			}
			
			// window.onmousewheel = document.onmousewheel = qodefScroll.preventDefaultValue;
			document.onkeydown = qodefScroll.keyDown;
		},
		enable: function(){
			if (window.removeEventListener) {
				window.removeEventListener('wheel', qodefScroll.preventDefaultValue, {passive: false});
			}
			window.onmousewheel = document.onmousewheel = document.onkeydown = null;
		},
		preventDefaultValue: function(e){
			e = e || window.event;
			if (e.preventDefault) {
				e.preventDefault();
			}
			e.returnValue = false;
		},
		keyDown: function(e) {
			var keys = [37, 38, 39, 40];
			for (var i = keys.length; i--;) {
				if (e.keyCode === keys[i]) {
					qodefScroll.preventDefaultValue(e);
					return;
				}
			}
		}
	};
	
	qodefCore.qodefScroll = qodefScroll;
	
	var qodefPerfectScrollbar = {
		init: function ($holder) {
			if ($holder.length) {
				qodefPerfectScrollbar.qodefInitScroll($holder);
			}
		},
		qodefInitScroll: function ($holder) {
			var $defaultParams = {
				wheelSpeed: 0.6,
				suppressScrollX: true
			};
			
			var $ps = new PerfectScrollbar($holder[0], $defaultParams);
			$(window).resize(function () {
				$ps.update();
			});
		}
	};
	
	qodefCore.qodefPerfectScrollbar = qodefPerfectScrollbar;
	
	var qodefInlinePageStyle = {
		init: function () {
			this.holder = $('#roisin-core-page-inline-style');
			
			if (this.holder.length) {
				var style = this.holder.data('style');
				
				if (style.length) {
					$('head').append('<style type="text/css">' + style + '</style>');
				}
			}
		}
	};
	
})(jQuery);
(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefBackToTop.init();
		}
	);

	var qodefBackToTop = {
		init: function () {
			this.holder = $( '#qodef-back-to-top' );

			if ( this.holder.length ) {
				// Scroll To Top
				this.holder.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefBackToTop.animateScrollToTop();
					}
				);

				qodefBackToTop.showHideBackToTop();
			}
		},
		animateScrollToTop: function () {
			window.scrollTo( { top: 0, behavior: 'smooth' } );
		},
		showHideBackToTop: function () {
			$( window ).scroll(
				function () {
					var $thisItem = $( this ),
						b         = $thisItem.scrollTop(),
						c         = $thisItem.height(),
						d;

					if ( b > 0 ) {
						d = b + c / 2;
					} else {
						d = 1;
					}

					if ( d < 1e3 ) {
						qodefBackToTop.addClass( 'off' );
					} else {
						qodefBackToTop.addClass( 'on' );
					}
				}
			);
		},
		addClass: function ( a ) {
			this.holder.removeClass( 'qodef--off qodef--on' );

			if ( a === 'on' ) {
				this.holder.addClass( 'qodef--on' );
			} else {
				this.holder.addClass( 'qodef--off' );
			}
		}
	};

})( jQuery );

(function ($) {
	"use strict";
	
	$(document).ready(function(){
		qodefContentSide.init();
	});
	
	var qodefContentSide = {
		init: function() {
			this.holder = $('.qodef-content-side');
			if(this.holder.length) {
				qodefContentSide.ShowHideContentSideHolder();
			}
		},
		ShowHideContentSideHolder : function() {
			$(window).scroll(function () {
				var $thisItem = $(this),
					b = $thisItem.scrollTop(),
					c = $thisItem.height(),
					d;
				
				if (b > 0) {
					d = b + c / 2;
				} else {
					d = 1;
				}
				
				if (d < 1e3) {
					qodefContentSide.addClass('off');
				} else {
					qodefContentSide.addClass('on');
				}
			});
		},
		addClass: function (a) {
			this.holder.removeClass('qodef--off qodef--on');
			
			if (a === 'on') {
				this.holder.addClass('qodef--on');
			} else {
				this.holder.addClass('qodef--off');
			}
		}
	};
})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefFullscreenMenu.init();
	});
	
	var qodefFullscreenMenu = {
		init: function () {
			var $fullscreenMenuOpener = $('a.qodef-fullscreen-menu-opener'),
				$menuItems = $('.qodef-fullscreen-menu-holder nav ul li a'),
				$fsMenuHolderInner = $('.qodef-fullscreen-menu-holder-inner');

			$fsMenuHolderInner.append('<div class="qodef-fullscreen-menu-overlay"></div>');

			var $fsMenuOverlay = $('.qodef-fullscreen-menu-overlay');
			
			// Open popup menu
			$fullscreenMenuOpener.on('click', function (e) {
				e.preventDefault();
				
				if (!qodef.body.hasClass('qodef-fullscreen-menu--opened')) {
					qodefFullscreenMenu.openFullscreen();
					$(document).keyup(function (e) {
						if (e.keyCode === 27) {
							qodefFullscreenMenu.closeFullscreen();
						}
					});
				} else {
					qodefFullscreenMenu.closeFullscreen();
				}
			});

			$fsMenuOverlay.on('click', function() {
				if (qodef.body.hasClass('qodef-fullscreen-menu--opened')) {
					qodefFullscreenMenu.closeFullscreen();
					$('.qodef-svg-close-cursor').css('opacity', 0);
				}
			});
			
			//open dropdowns
			$menuItems.on('tap click', function (e) {
				var $thisItem = $(this);
				if ($thisItem.parent().hasClass('menu-item-has-children')) {
					e.preventDefault();
					qodefFullscreenMenu.clickItemWithChild($thisItem);
				} else if (($(this).attr('href') !== "http://#") && ($(this).attr('href') !== "#")) {
					qodefFullscreenMenu.closeFullscreen();
				}
			});
		},
		openFullscreen: function () {
			qodef.body.removeClass('qodef-fullscreen-menu-animate--out').addClass('qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in');
			qodefCore.qodefScroll.disable();
		},
		closeFullscreen: function () {
			qodef.body.removeClass('qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in').addClass('qodef-fullscreen-menu-animate--out');
			qodefCore.qodefScroll.enable();
			$("nav.qodef-fullscreen-menu ul.sub_menu").slideUp(200);
		},
		clickItemWithChild: function (thisItem) {
			var $thisItemParent = thisItem.parent(),
				$thisItemSubMenu = $thisItemParent.find('.sub-menu').first();
			
			if ($thisItemSubMenu.is(':visible')) {
				$thisItemSubMenu.slideUp(300);
			} else {
				$thisItemSubMenu.slideDown(300);
				$thisItemParent.siblings().find('.sub-menu').slideUp(400);
			}
		}
	};
	
})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		animateProgress.init();
	});
	
	$(document).on('roisin_trigger_get_new_posts', function () {
		animateProgress.init();
	});
	
	var animateProgress = {
		init: function () {
			var $goalProgress = $('.give-goal-progress:not(.qode-initialized)');
			
			if ($goalProgress.length) {
				$goalProgress.each(function () {
					
					// adds qode class
					$(this).addClass('qode-initialized');
					
					// gets percentages
					var $itemForPercentages = $(this).find('.give-progress-bar');
					var percentages = Math.ceil($itemForPercentages.attr('aria-valuenow'));
					
					// in order to animate progress bar, adding !important
					var $itemProgressBar = $(this).find('.give-progress-bar > span');
					var previousStyle = $itemProgressBar.attr('style');
					setTimeout(function () {
						$itemProgressBar.attr('style', 'width:' + percentages + '%' + ' !important; ' + previousStyle + '');
					});
					
					// adds our percentage text
					var $itemQodeProgressText = $(this);
					$itemQodeProgressText.append('<div class="qode-progress-text-holder"><div class="qode-progress-text"><span>' + percentages + '%' + '</span></div></div>');
					setTimeout(function () {
						$itemQodeProgressText.find('.qode-progress-text').attr('style', 'transform: translateX(' + percentages + '% ' + '); opacity: 1;  ');
					});
					
					// uses default text that is printed from Give plugin, since there are multiple type options like donations, donors, raised, funded
					var $raisedAllText = $(this).find('.raised')[0].childNodes;
					var raisedSingleText = $raisedAllText[$raisedAllText.length - 1].textContent;
					$(this).find('.raised .income, .raised .give-percentage').before('<span class="qodef-income-label">' + raisedSingleText + ':' + '</span>');
					$(this).find('.raised .goal-text').before('<span class="qodef-goal-label">' + 'Goal' + ':' + '</span>');
					
					// if type is percentage, add additional divs
					if ( $(this).find('.raised .give-percentage').length) {
						$(this).find('.raised .give-percentage').after('<span class="goal-text">' + '100%' + '</span>');
						$(this).find('.raised .give-percentage').after('<span class="qodef-goal-label">' + 'Goal' + ':' + '</span>');
					}
					
					// removes all text nodes after
					var $removeNodes = $(this).find('.raised').contents().filter(function () {
						return this.nodeType === 3; //Node.TEXT_NODE
					});
					if ($removeNodes.length) {
						$removeNodes.each(function () {
							$(this).remove();
						});
					}
				});
			}
		}
	};
	
})(jQuery);

(function($){
    "use strict";

    $(document).ready(function () {
        qodefHeaderScrollAppearance.init();
    });

    var qodefHeaderScrollAppearance = {
        appearanceType: function(){
            return qodef.body.attr('class').indexOf('qodef-header-appearance--') !== -1 ? qodef.body.attr('class').match(/qodef-header-appearance--([\w]+)/)[1] : '';
        },
        init: function(){
            var appearanceType = this.appearanceType();

            if(appearanceType !== '' && appearanceType !== 'none'){
                window.qodef[appearanceType+"HeaderAppearance"]();
            }
        }
    };

})(jQuery);

(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefMobileHeaderAppearance.init();
    });

    /*
     **	Init mobile header functionality
     */
    var qodefMobileHeaderAppearance = {
        init: function () {
            if (qodef.body.hasClass('qodef-mobile-header-appearance--sticky')) {

                var docYScroll1 = qodef.scroll,
                    displayAmount = qodefGlobal.vars.mobileHeaderHeight + qodefGlobal.vars.adminBarHeight,
                    $pageOuter = $('#qodef-page-outer');

                qodefMobileHeaderAppearance.showHideMobileHeader(docYScroll1, displayAmount, $pageOuter);
                $(window).scroll(function () {
                    qodefMobileHeaderAppearance.showHideMobileHeader(docYScroll1, displayAmount, $pageOuter);
                    docYScroll1 = qodef.scroll;
                });

                $(window).resize(function () {
                    $pageOuter.css('padding-top', 0);
                    qodefMobileHeaderAppearance.showHideMobileHeader(docYScroll1, displayAmount, $pageOuter);
                });
            }
        },
        showHideMobileHeader: function(docYScroll1, displayAmount,$pageOuter){
            if(qodef.windowWidth <= 1024) {
                if (qodef.scroll > displayAmount * 2) {
                    //set header to be fixed
                    qodef.body.addClass('qodef-mobile-header--sticky');

                    //add transition to it
                    setTimeout(function () {
                        qodef.body.addClass('qodef-mobile-header--sticky-animation');
                    }, 300); //300 is duration of sticky header animation

                    //add padding to content so there is no 'jumping'
                    $pageOuter.css('padding-top', qodefGlobal.vars.mobileHeaderHeight);
                } else {
                    //unset fixed header
                    qodef.body.removeClass('qodef-mobile-header--sticky');

                    //remove transition
                    setTimeout(function () {
                        qodef.body.removeClass('qodef-mobile-header--sticky-animation');
                    }, 300); //300 is duration of sticky header animation

                    //remove padding from content since header is not fixed anymore
                    $pageOuter.css('padding-top', 0);
                }

                if ((qodef.scroll > docYScroll1 && qodef.scroll > displayAmount) || (qodef.scroll < displayAmount * 3)) {
                    //show sticky header
                    qodef.body.removeClass('qodef-mobile-header--sticky-display');
                } else {
                    //hide sticky header
                    qodef.body.addClass('qodef-mobile-header--sticky-display');
                }
            }
        }
    };

})(jQuery);
(function ($) {
	"use strict";

	$(document).ready(function () {
		qodefNavMenu.init();
		qodefNavMenu.wideDropdownPosition();
		qodefNavMenu.dropdownPosition();
	});

	var qodefNavMenu = {
		wideDropdownPosition: function () {
			var $menuItems = $(".qodef-header-navigation > ul > li.qodef-menu-item--wide");

			if ($menuItems.length) {
				$menuItems.each(function () {
					var $menuItem = $(this);
					var $menuItemSubMenu = $menuItem.find('.qodef-drop-down-second');

					if ($menuItemSubMenu.length) {
						$menuItemSubMenu.css('left', 0);

						var leftPosition = $menuItemSubMenu.offset().left;

						if (qodef.body.hasClass('qodef--boxed')) {
							//boxed layout case
							var boxedWidth = $('.qodef--boxed .qodef-wrapper .qodef-wrapper-inner').outerWidth();
							leftPosition = leftPosition - (qodef.windowWidth - boxedWidth) / 2;
							$menuItemSubMenu.css({'left': -leftPosition, 'width': boxedWidth});

						} else if (qodef.body.hasClass('qodef-drop-down-second--full-width')) {
							//wide dropdown full width case
							$menuItemSubMenu.css({'left': -leftPosition});
						}
						else {
							//wide dropdown in grid case
							$menuItemSubMenu.css({'left': -leftPosition + (qodef.windowWidth - $menuItemSubMenu.width()) / 2});
						}
					}
				});
			}
		},
		dropdownPosition: function () {
			var $menuItems = $('.qodef-header-navigation > ul > li.qodef-menu-item--narrow.menu-item-has-children');

			if ($menuItems.length) {
				$menuItems.each(function () {
					var $thisItem = $(this),
						menuItemPosition = $thisItem.offset().left,
						$dropdownHolder = $thisItem.find('.qodef-drop-down-second'),
						$dropdownMenuItem = $dropdownHolder.find('.qodef-drop-down-second-inner ul'),
						dropdownMenuWidth = $dropdownMenuItem.outerWidth(),
						menuItemFromLeft = $(window).width() - menuItemPosition;

					var dropDownMenuFromLeft;

					if ($thisItem.find('li.menu-item-has-children').length > 0) {
						dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
					}

					$dropdownHolder.removeClass('qodef-drop-down--right');
					$dropdownMenuItem.removeClass('qodef-drop-down--right');
					if (menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth) {
						$dropdownHolder.addClass('qodef-drop-down--right');
						$dropdownMenuItem.addClass('qodef-drop-down--right');
					}
				});
			}
		},
		init: function () {
			var $menuItems = $('.qodef-header-navigation > ul > li');

			$menuItems.each(function () {
				var $thisItem = $(this);

				if ($thisItem.find('.qodef-drop-down-second').length) {
					$thisItem.waitForImages(function () {
						var $dropDownHolder = $thisItem.find('.qodef-drop-down-second'),
							dropDownHolderHeight = !qodef.menuDropdownHeightSet ? $dropDownHolder.outerHeight() : 0;

						if (!qodef.menuDropdownHeightSet) {
							$dropDownHolder.height(0);
						}

						if (navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {
							$thisItem.on("touchstart mouseenter", function () {
								$dropDownHolder.css({
									'height': dropDownHolderHeight,
									'overflow': 'visible',
									'visibility': 'visible',
									'opacity': '1'
								});
							}).on("mouseleave", function () {
								$dropDownHolder.css({
									'height': '0px',
									'overflow': 'hidden',
									'visibility': 'hidden',
									'opacity': '0'
								});
							});
						} else {
							if ($('body').hasClass('qodef-drop-down-second--animate-height')) {
								var animateConfig = {
									interval: 0,
									over: function () {
										setTimeout(function () {
											$dropDownHolder.addClass('qodef-drop-down--start').css({
												'visibility': 'visible',
												'height': '0',
												'opacity': '1'
											});
											$dropDownHolder.stop().animate({
												'height': dropDownHolderHeight
											}, 400, 'easeInOutQuint', function () {
												$dropDownHolder.css('overflow', 'visible');
											});
										}, 100);
									},
									timeout: 100,
									out: function () {
										$dropDownHolder.stop().animate({
											'height': '0',
											'opacity': 0
										}, 100, function () {
											$dropDownHolder.css({
												'overflow': 'hidden',
												'visibility': 'hidden'
											});
										});

										$dropDownHolder.removeClass('qodef-drop-down--start');
									}
								};

								$thisItem.hoverIntent(animateConfig);
							} else {
								$dropDownHolder.css({'height': dropDownHolderHeight});

								var config = {
									interval: 0,
									over: function () {
										setTimeout(function () {
											$dropDownHolder.addClass('qodef-drop-down--start').stop();
										}, 50);
									},
									timeout: 50,
									out: function () {
										$dropDownHolder.removeClass('qodef-drop-down--start').stop();
									}
								};
								$thisItem.hoverIntent(config);
							}
						}
					});
				}
			});
		}
	};

})(jQuery);

(function ($) {
	"use strict";
	
	$(window).on('load', function () {
		qodefParallaxBackground.init();
	});
	
	/**
	 * Init global parallax background functionality
	 */
	var qodefParallaxBackground = {
		init: function (settings) {
			this.$sections = $('.qodef-parallax');
			
			// Allow overriding the default config
			$.extend(this.$sections, settings);
			
			var isSupported = !qodefCore.html.hasClass('touchevents') && !qodefCore.body.hasClass('qodef-browser--edge') && !qodefCore.body.hasClass('qodef-browser--ms-explorer');
			
			if (this.$sections.length && isSupported) {
				this.$sections.each(function () {
					qodefParallaxBackground.ready($(this));
				});
			}
		},
		ready: function ($section) {
			$section.$imgHolder = $section.find('.qodef-parallax-img-holder');
			$section.$imgWrapper = $section.find('.qodef-parallax-img-wrapper');
			$section.$img = $section.find('img');
			
			var h = $section.height(),
				imgWrapperH = $section.$imgWrapper.height();
			
			$section.movement = 100 * (imgWrapperH - h) / h / 2; //percentage (divided by 2 due to absolute img centering in CSS)
			
			$section.buffer = window.pageYOffset;
			$section.scrollBuffer = null;
			
			
			//calc and init loop
			requestAnimationFrame(function () {
				$section.$imgHolder.animate({opacity: 1}, 100);
				qodefParallaxBackground.calc($section);
				qodefParallaxBackground.loop($section);
			});
			
			//recalc
			$(window).on('resize', function () {
				qodefParallaxBackground.calc($section);
			});
		},
		calc: function ($section) {
			var wH = $section.$imgWrapper.height(),
				wW = $section.$imgWrapper.width();
			
			if ($section.$img.width() < wW) {
				$section.$img.css({
					'width': '100%',
					'height': 'auto'
				});
			}
			
			if ($section.$img.height() < wH) {
				$section.$img.css({
					'height': '100%',
					'width': 'auto',
					'max-width': 'unset'
				});
			}
		},
		loop: function ($section) {
			if ($section.scrollBuffer === Math.round(window.pageYOffset)) {
				requestAnimationFrame(function () {
					qodefParallaxBackground.loop($section);
				}); //repeat loop
				return false; //same scroll value, do nothing
			} else {
				$section.scrollBuffer = Math.round(window.pageYOffset);
			}
			
			var wH = window.outerHeight,
				sTop = $section.offset().top,
				sH = $section.height();
			
			if ($section.scrollBuffer + wH * 1.2 > sTop && $section.scrollBuffer < sTop + sH) {
				var delta = (Math.abs($section.scrollBuffer + wH - sTop) / (wH + sH)).toFixed(4), //coeff between 0 and 1 based on scroll amount
					yVal = (delta * $section.movement).toFixed(4);
				
				if ($section.buffer !== delta) {
					$section.$imgWrapper.css('transform', 'translate3d(0,' + yVal + '%, 0)');
				}
				
				$section.buffer = delta;
			}
			
			requestAnimationFrame(function () {
				qodefParallaxBackground.loop($section);
			}); //repeat loop
		}
	};
	
	qodefCore.qodefParallaxBackground = qodefParallaxBackground;
	
})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefSideArea.init();
	});
	
	var qodefSideArea = {
		init: function () {
			var $sideAreaOpener = $('a.qodef-side-area-opener'),
				$sideAreaClose = $('#qodef-side-area-close'),
				$sideArea = $('#qodef-side-area');
				qodefSideArea.openerHoverColor($sideAreaOpener);
			// Open Side Area
			$sideAreaOpener.on('click', function (e) {
				e.preventDefault();
				
				if (!qodef.body.hasClass('qodef-side-area--opened')) {
					qodefSideArea.openSideArea();
					
					$(document).keyup(function (e) {
						if (e.keyCode === 27) {
							qodefSideArea.closeSideArea();
						}
					});
				} else {
					qodefSideArea.closeSideArea();
				}
			});
			
			$sideAreaClose.on('click', function (e) {
				e.preventDefault();
				qodefSideArea.closeSideArea();
			});
			
			if ($sideArea.length && typeof window.qodefCore.qodefPerfectScrollbar === 'object') {
				window.qodefCore.qodefPerfectScrollbar.init($sideArea);
			}
		},
		openSideArea: function () {
			var $wrapper = $('#qodef-page-wrapper');
			var currentScroll = $(window).scrollTop();

			$('.qodef-side-area-cover').remove();
			$wrapper.prepend('<div class="qodef-side-area-cover"/>');
			qodef.body.removeClass('qodef-side-area-animate--out').addClass('qodef-side-area--opened qodef-side-area-animate--in');

			$('.qodef-side-area-cover').on('click', function (e) {
				e.preventDefault();
				qodefSideArea.closeSideArea();
			});

			$(window).scroll(function () {
				if (Math.abs(qodef.scroll - currentScroll) > 400) {
					qodefSideArea.closeSideArea();
				}
			});

		},
		closeSideArea: function () {
			qodef.body.removeClass('qodef-side-area--opened qodef-side-area-animate--in').addClass('qodef-side-area-animate--out');
		},
		openerHoverColor: function ($opener) {
			if (typeof $opener.data('hover-color') !== 'undefined') {
				var hoverColor = $opener.data('hover-color');
				var originalColor = $opener.css('color');
				
				$opener.on('mouseenter', function () {
					$opener.css('color', hoverColor);
				}).on('mouseleave', function () {
					$opener.css('color', originalColor);
				});
			}
		}
	};
	
})(jQuery);

(function ($) {
	"use strict";
	
	$(document).ready(function () {
		spinners.init();
	});
	
	var spinners = {
		init: function () {
			var roisinSpinner = $('.qodef-roisin-spinner-holder');
			spinners.windowLoaded = false;

			if (roisinSpinner.length) {
				spinners.animateRoisinSpinner();
			}

			$(window).on('load', function() {
				// Default fade out animation if not Roisin Spinner
				if (!roisinSpinner.length) {
					spinners.fadeOutLoader();
				}
			});

			// Elementor handling
			if (window.elementorFrontend) {
				spinners.windowLoaded = true;
				if (!roisinSpinner.length) {
					spinners.fadeOutLoader();
				}
			}
		},
		animateRoisinSpinner: function() {
			var roisinSpinner = $('.qodef-roisin-spinner-holder'),
				roisinSpinnerItems = roisinSpinner.find('svg > *'),
				roisinSpinnerItemsLength = roisinSpinnerItems.length - 1;

			// Loop Animation and Fade Out
			var spinnerAnimationLoop = function(animationProps) {
					roisinSpinnerItems.each(function(i) {
						var thisItem = $(this);
						setTimeout(function() {
							thisItem.fadeTo(animationProps.fadeDuration, animationProps.fadeToVal, function() {
								if (i === roisinSpinnerItemsLength) {
									if (animationProps.fadeToVal === 1) {
										spinnerAnimationLoop({
											fadeToVal: 0,
											fadeDuration: 1000,
											fadeStagger: 100,
										});
									} else {
										if (!spinners.windowLoaded) {
											spinnerAnimationLoop({
												fadeToVal: 1,
												fadeDuration: 3000,
												fadeStagger: 0,
											});
										} else {
											spinners.fadeOutLoader(1000, 0, 'swing');
										}
									}
								}
							});
						}, i * animationProps.fadeStagger);
					});	

			}

			// Start Spinner Animation Loop
			setTimeout(function() {
				spinnerAnimationLoop({
					fadeToVal: 1,
					fadeDuration: 3000,
					fadeStagger: 0,
				});
			}, 300);

			// End Spinner Animation on Window Load
			$(window).on('load', function() {
				setTimeout(function() {
					spinners.windowLoaded = true;
				}, 1000)
			})
		},
		fadeOutLoader: function(speed, delay, easing) {
			speed = speed ? speed : 600;
			delay = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			var loader = $('.qodef-smooth-transition-loader');

			if (loader.length) {
				loader.delay(delay).fadeOut(speed, easing);
				$(window).on('bind', 'pageshow', function (event) {
					if (event.originalEvent.persisted) {
						loader.fadeOut(speed, easing);
					}
				});
			}
		}
	};
	
})(jQuery);

(function ($) {
    "use strict";

    $(window).on('load', function () {
        qodefSubscribeModal.init();
    });

    var qodefSubscribeModal = {
        init: function () {
            this.holder = $('#qodef-subscribe-popup-modal');

            if (this.holder.length) {
                var $preventHolder = this.holder.find('.qodef-sp-prevent'),
                    $modalClose = $('.qodef-sp-close'),
                    disabledPopup = 'no';

                if ($preventHolder.length) {
                    var isLocalStorage = this.holder.hasClass('qodef-sp-prevent-cookies'),
                        $preventInput = $preventHolder.find('.qodef-sp-prevent-input'),
                        preventValue = $preventInput.data('value');

                    if (isLocalStorage) {
                        disabledPopup = localStorage.getItem('disabledPopup');
                        sessionStorage.removeItem('disabledPopup');
                    } else {
                        disabledPopup = sessionStorage.getItem('disabledPopup');
                        localStorage.removeItem('disabledPopup');
                    }

                    $preventHolder.children().on('click', function (e) {
                        if (preventValue !== 'yes') {
                            preventValue = 'yes';
                            $preventInput.addClass('qodef-sp-prevent-clicked').data('value', 'yes');
                        } else {
                            preventValue = 'no';
                            $preventInput.removeClass('qodef-sp-prevent-clicked').data('value', 'no');
                        }

                        if (preventValue === 'yes') {
                            if (isLocalStorage) {
                                localStorage.setItem('disabledPopup', 'yes');
                            } else {
                                sessionStorage.setItem('disabledPopup', 'yes');
                            }
                        } else {
                            if (isLocalStorage) {
                                localStorage.setItem('disabledPopup', 'no');
                            } else {
                                sessionStorage.setItem('disabledPopup', 'no');
                            }
                        }
                    });
                }

                if (disabledPopup !== 'yes') {
                    if (qodef.body.hasClass('qodef-sp-opened')) {
                        qodefSubscribeModal.handleClassAndScroll('remove');
                    } else {
                        qodefSubscribeModal.handleClassAndScroll('add');
                    }

                    $modalClose.on('click', function (e) {
                        e.preventDefault();

                        qodefSubscribeModal.handleClassAndScroll('remove');
                    });

                    // Close on escape
                    $(document).keyup(function (e) {
                        if (e.keyCode === 27) { // KeyCode for ESC button is 27
                            qodefSubscribeModal.handleClassAndScroll('remove');
                        }
                    });
                }
            }
        },

        handleClassAndScroll: function (option) {
            if (option === 'remove') {
                qodef.body.removeClass('qodef-sp-opened');
                qodefCore.qodefScroll.enable();
            }
            if (option === 'add') {
                qodef.body.addClass('qodef-sp-opened');
                qodefCore.qodefScroll.disable();
            }
        },
    };

})(jQuery);
(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefPortfolio.init();
    });


    var qodefPortfolio = {
        init: function () {
            this.holder = $('.qodef-portfolio-info-sticky-holder');
            if (this.holder.length && qodef.windowWidth > 1024) {

                var params = {
                    self: this.holder,
                    infoHolder: this.holder.parent(),
                    infoHolderOffset: this.holder.parent().offset().top,
                    infoHolderHeight: this.holder.parent().height(),
                    mediaHolder: $('.qodef-media'),
                    mediaHolderHeight: $('.qodef-media').height(),
                    header: $('#qodef-page-header'),
                    headerHeight: $('#qodef-page-header').length ? $('#qodef-page-header').height() : 0,
                    constant: 0, //30 to prevent mispositioned
                    marginTop: 0
                };

                qodefPortfolio.infoHolderPosition(params);

                $(window).scroll(function () {
                    qodefPortfolio.recalculateInfoHolderPosition(params);
                });
            }

        },
        infoHolderPosition: function (params) {
            if (params.mediaHolderHeight >= params.infoHolderHeight) {
                if (qodef.scroll >= params.infoHolderOffset - params.headerHeight) {

                    params.marginTop = qodef.scroll - params.infoHolderOffset + params.headerHeight + params.constant;

                    // if scroll is initially positioned below mediaHolderHeight
                    if (params.marginTop + params.infoHolderHeight > params.mediaHolderHeight) {
                        params.marginTop = params.mediaHolderHeight - params.infoHolderHeight + params.constant;
                    }

                    params.self.stop().animate({
                        marginTop: params.marginTop
                    });
                }
            }
        },

        recalculateInfoHolderPosition: function (params) {
            // this is updated after scroll - for ie issue on starting height
            params.mediaHolderHeight = params.mediaHolder ? params.mediaHolder.height() : 0;
            if (params.mediaHolderHeight >= params.infoHolderHeight) {

                //Calculate header height if header appears
                if (qodef.scroll > 0) {
                    params.headerHeight = params.header.height();
                }

                var headerMixin = params.headerHeight + params.constant;

                if (qodef.scroll >= params.infoHolderOffset - headerMixin) {
                    if (qodef.scroll + params.infoHolderHeight + headerMixin + 2 * params.constant < params.infoHolderOffset + params.mediaHolderHeight) {
                        params.self.stop().animate({
                            marginTop: (qodef.scroll - params.infoHolderOffset + headerMixin + 2 * params.constant)
                        });

                        //Reset header height
                        params.headerHeight = 0;

                    } else {
                        params.self.stop().animate({
                            marginTop: params.mediaHolderHeight - params.infoHolderHeight
                        });
                    }
                } else {
                    params.self.stop().animate({
                        marginTop: 0
                    });
                }
            }
        },
    };
})(jQuery);



(function ($) {
	"use strict";
	qodefCore.shortcodes.roisin_core_accordion = {};
	
	$(document).ready(function () {
		qodefAccordion.init();
	});
	
	var qodefAccordion = {
		init: function () {
			this.holder = $('.qodef-accordion');
			
			if (this.holder.length) {
				this.holder.each(function () {
					var $thisHolder = $(this);
					
					if ($thisHolder.hasClass('qodef-behavior--accordion')) {
						qodefAccordion.initAccordion($thisHolder);
					}
					
					if ($thisHolder.hasClass('qodef-behavior--toggle')) {
						qodefAccordion.initToggle($thisHolder);
					}
					
					$thisHolder.addClass('qodef--init');
				});
			}
		},
		initAccordion: function ($accordion) {
			$accordion.accordion({
				animate: "swing",
				collapsible: true,
				active: 0,
				icons: "",
				heightStyle: "content"
			});
		},
		initToggle: function ($toggle) {
			var $toggleAccordionTitle = $toggle.find('.qodef-accordion-title'),
				$toggleAccordionContent = $toggleAccordionTitle.next();
			
			$toggle.addClass("accordion ui-accordion ui-accordion-icons ui-widget ui-helper-reset");
			$toggleAccordionTitle.addClass("ui-accordion-header ui-state-default ui-corner-top ui-corner-bottom");
			$toggleAccordionContent.addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom").hide();
			
			$toggleAccordionTitle.each(function () {
				var $thisTitle = $(this);
				
				$thisTitle.hover(function () {
					$thisTitle.toggleClass("ui-state-hover");
				});
				
				$thisTitle.on('click', function () {
					$thisTitle.toggleClass('ui-accordion-header-active ui-state-active ui-state-default ui-corner-bottom');
					$thisTitle.next().toggleClass('ui-accordion-content-active').slideToggle(400);
				});
			});
		}
	};
	
	qodefCore.shortcodes.roisin_core_accordion.qodefAccordion = qodefAccordion;
	
})(jQuery);
(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefBannerAnimation.init();
    });
    
    /**
     * Banner Animation
     */
    var qodefBannerAnimation = {
        init: function () {
            var $holder = $('.qodef-banner');

            if ($holder.length) {
                $holder.each(function(i) {
                    var $thisHolder = $(this);

                    if (i % 2 === 0) {
                        $thisHolder.addClass('qodef--even');
                    }

                    if ($thisHolder.hasClass('qodef-layout--type-2')) {
                        $thisHolder.appear(function() {
                            $thisHolder.addClass('qodef--appear');
                        }, {accX: 0, accY: 0});
                    }
                });
            }
        }
    }

})(jQuery);
(function ($) {
	"use strict";
	qodefCore.shortcodes.roisin_core_button = {};
	$(document).ready(function () {
		qodefButton.init();
	});
	
	var qodefButton = {
		init: function () {
			this.buttons = $('.qodef-button');
			
			if (this.buttons.length) {
				this.buttons.each(function () {
					var $thisButton = $(this);
					
					qodefButton.buttonHoverColor($thisButton);
					qodefButton.buttonHoverBgColor($thisButton);
					qodefButton.buttonHoverBorderColor($thisButton);
				});
			}
		},
		buttonHoverColor: function ($button) {
			if (typeof $button.data('hover-color') !== 'undefined') {
				var hoverColor = $button.data('hover-color');
				var originalColor = $button.css('color');
				
				$button.on('mouseenter', function () {
					qodefButton.changeColor($button, 'color', hoverColor);
				});
				$button.on('mouseleave', function () {
					qodefButton.changeColor($button, 'color', originalColor);
				});
			}
		},
		buttonHoverBgColor: function ($button) {
			if (typeof $button.data('hover-background-color') !== 'undefined') {
				var hoverBackgroundColor = $button.data('hover-background-color');
				var originalBackgroundColor = $button.css('background-color');
				
				$button.on('mouseenter', function () {
					qodefButton.changeColor($button, 'background-color', hoverBackgroundColor);
				});
				$button.on('mouseleave', function () {
					qodefButton.changeColor($button, 'background-color', originalBackgroundColor);
				});
			}
		},
		buttonHoverBorderColor: function ($button) {
			if (typeof $button.data('hover-border-color') !== 'undefined') {
				var hoverBorderColor = $button.data('hover-border-color');
				var originalBorderColor = $button.css('borderTopColor');
				
				$button.on('mouseenter', function () {
					qodefButton.changeColor($button, 'border-color', hoverBorderColor);
				});
				$button.on('mouseleave', function () {
					qodefButton.changeColor($button, 'border-color', originalBorderColor);
				});
			}
		},
		changeColor: function ($button, cssProperty, color) {
			$button.css(cssProperty, color);
		}
	};
	qodefCore.shortcodes.roisin_core_button.qodefButton = qodefButton;
	
})(jQuery);
(function ($) {
	"use strict";
	qodefCore.shortcodes.roisin_core_cards_gallery = {};
	$(document).ready(function () {
		qodefCardsGallery.init();
	});
	
	var qodefCardsGallery = {
		init: function () {
			this.holder = $('.qodef-cards-gallery');
			
			if (this.holder.length) {
				this.holder.each(function () {
					var $thisHolder = $(this);
					qodefCardsGallery.initCards( $thisHolder );
					qodefCardsGallery.initBundle( $thisHolder );
				});
			}
		},
		initCards: function ($holder) {
			var $cards = $holder.find('.qodef-m-card');
			$cards.each(function () {
				var $card = $(this);
				
				$card.on('click', function () {
					if (!$cards.last().is($card)) {
						$card.addClass('qodef-out qodef-animating').siblings().addClass('qodef-animating-siblings');
						$card.detach();
						$card.insertAfter($cards.last());
						
						setTimeout(function () {
							$card.removeClass('qodef-out');
						}, 200);
						
						setTimeout(function () {
							$card.removeClass('qodef-animating').siblings().removeClass('qodef-animating-siblings');
						}, 1200);
						
						$cards = $holder.find('.qodef-m-card');
						
						return false;
					}
				});
				
				
			});
		},
		initBundle: function($holder) {
			if ($holder.hasClass('qodef-animation--bundle') && !qodef.html.hasClass('touchevents')) {
				$holder.appear(function () {
					$holder.addClass('qodef-appeared');
					$holder.find('img').one('animationend webkitAnimationEnd MSAnimationEnd oAnimationEnd', function () {
						$(this).addClass('qodef-animation-done');
					});
				}, {accX: 0, accY: -100});
			}
		}
	};
	
	qodefCore.shortcodes.roisin_core_cards_gallery.qodefCardsGallery  = qodefCardsGallery;
	
})(jQuery);
(function ($) {
	"use strict";
	
	qodefCore.shortcodes.roisin_core_countdown = {};
	
	$(document).ready(function () {
		qodefCountdown.init();
	});
	
	var qodefCountdown = {
		init: function () {
			this.countdowns = $('.qodef-countdown');
			
			if (this.countdowns.length) {
				this.countdowns.each(function () {
					var $thisCountdown = $(this),
						$countdownElement = $thisCountdown.find('.qodef-m-date'),
						options = qodefCountdown.generateOptions($thisCountdown);
					
					qodefCountdown.initCountdown($countdownElement, options);
				});
			}
		},
		generateOptions: function($countdown) {
			var options = {};
			options.date = typeof $countdown.data('date') !== 'undefined' ? $countdown.data('date') : null;
			
			options.weekLabel = typeof $countdown.data('week-label') !== 'undefined' ? $countdown.data('week-label') : '';
			options.weekLabelPlural = typeof $countdown.data('week-label-plural') !== 'undefined' ? $countdown.data('week-label-plural') : '';
			
			options.dayLabel = typeof $countdown.data('day-label') !== 'undefined' ? $countdown.data('day-label') : '';
			options.dayLabelPlural = typeof $countdown.data('day-label-plural') !== 'undefined' ? $countdown.data('day-label-plural') : '';
			
			options.hourLabel = typeof $countdown.data('hour-label') !== 'undefined' ? $countdown.data('hour-label') : '';
			options.hourLabelPlural = typeof $countdown.data('hour-label-plural') !== 'undefined' ? $countdown.data('hour-label-plural') : '';
			
			options.minuteLabel = typeof $countdown.data('minute-label') !== 'undefined' ? $countdown.data('minute-label') : '';
			options.minuteLabelPlural = typeof $countdown.data('minute-label-plural') !== 'undefined' ? $countdown.data('minute-label-plural') : '';
			
			options.secondLabel = typeof $countdown.data('second-label') !== 'undefined' ? $countdown.data('second-label') : '';
			options.secondLabelPlural = typeof $countdown.data('second-label-plural') !== 'undefined' ? $countdown.data('second-label-plural') : '';
			
			return options;
		},
		initCountdown: function ($countdownElement, options) {
			var $weekHTML = '<span class="qodef-digit-wrapper"><span class="qodef-digit">%w</span><span class="qodef-label">' + '%!w:' + options.weekLabel + ',' + options.weekLabelPlural + ';</span></span>';
			var $dayHTML = '<span class="qodef-digit-wrapper"><span class="qodef-digit">%d</span><span class="qodef-label">' + '%!d:' + options.dayLabel + ',' + options.dayLabelPlural + ';</span></span>';
			var $hourHTML = '<span class="qodef-digit-wrapper"><span class="qodef-digit">%H</span><span class="qodef-label">' + '%!H:' + options.hourLabel + ',' + options.hourLabelPlural + ';</span></span>';
			var $minuteHTML = '<span class="qodef-digit-wrapper"><span class="qodef-digit">%M</span><span class="qodef-label">' + '%!M:' + options.minuteLabel + ',' + options.minuteLabelPlural + ';</span></span>';
			var $secondHTML = '<span class="qodef-digit-wrapper"><span class="qodef-digit">%S</span><span class="qodef-label">' + '%!S:' + options.secondLabel + ',' + options.secondLabelPlural + ';</span></span>';
			
			$countdownElement.countdown(options.date, function(event) {
				$(this).html(event.strftime($weekHTML + $dayHTML + $hourHTML + $minuteHTML + $secondHTML));
			});
		}
	};
	
	qodefCore.shortcodes.roisin_core_countdown.qodefCountdown  = qodefCountdown;
	
})(jQuery);
(function ($) {
	"use strict";
	
	qodefCore.shortcodes.roisin_core_counter = {};
	
	$(document).ready(function () {
		qodefCounter.init();
	});
	
	var qodefCounter = {
		init: function () {
			this.counters = $('.qodef-counter');
			
			if (this.counters.length) {
				this.counters.each(function () {
					var $thisCounter = $(this),
						$counterElement = $thisCounter.find('.qodef-m-digit'),
						options = qodefCounter.generateOptions($thisCounter);
					
					qodefCounter.counterScript($counterElement, options);
				});
			}
		},
		generateOptions: function($counter) {
			var options = {};
			options.start = typeof $counter.data('start-digit') !== 'undefined' && $counter.data('start-digit') !== '' ? $counter.data('start-digit') : 0;
			options.end = typeof $counter.data('end-digit') !== 'undefined' && $counter.data('end-digit') !== '' ? $counter.data('end-digit') : null;
			options.step = typeof $counter.data('step-digit') !== 'undefined' && $counter.data('step-digit') !== '' ? $counter.data('step-digit') : 1;
			options.delay = typeof $counter.data('step-delay') !== 'undefined' && $counter.data('step-delay') !== '' ? parseInt( $counter.data('step-delay'), 10 ) : 100;
			options.txt = typeof $counter.data('digit-label') !== 'undefined' && $counter.data('digit-label') !== '' ? $counter.data('digit-label') : '';
			
			return options;
		},
		counterScript: function ($counterElement, options) {
			var defaults = {
				start: 0,
				end: null,
				step: 1,
				delay: 100,
				txt: ""
			};
			
			var settings = $.extend(defaults, options || {});
			var nb_start = settings.start;
			var nb_end = settings.end;
			
			$counterElement.text(nb_start + settings.txt);
			
			var counter = function() {
				// Definition of conditions of arrest
				if (nb_end !== null && nb_start >= nb_end) {
					return;
				}
				// incrementation
				nb_start = nb_start + settings.step;
				
				if( nb_start >= nb_end ) {
					nb_start = nb_end;
				}
				// display
				$counterElement.text(nb_start + settings.txt);
			};
			
			// Timer
			// Launches every "settings.delay"
			setInterval(counter, settings.delay);
		}
	};
	
	qodefCore.shortcodes.roisin_core_counter.qodefCounter  = qodefCounter;
	
})(jQuery);
(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.roisin_core_google_map = {};

	$( document ).on(
		'qodefGoogleMapsCallbackEvent',
		function () {
			qodefGoogleMap.init();
		}
	);

	var qodefGoogleMap = {
		init: function () {
			this.holder = $( '.qodef-google-map' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefGoogleMap.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			if ( typeof window.qodefGoogleMap !== 'undefined' ) {
				window.qodefGoogleMap.init( $currentItem.find( '.qodef-m-map' ) );
			}
		},
	};

	qodefCore.shortcodes.roisin_core_google_map.qodefGoogleMap = qodefGoogleMap;

})( jQuery );

(function ($) {
    "use strict";
	
	qodefCore.shortcodes.roisin_core_icon = {};
    $(document).ready(function () {
        qodefIcon.init();
    });

    var qodefIcon = {
        init: function () {
            this.icons = $('.qodef-icon-holder');

            if (this.icons.length) {
                this.icons.each(function () {
                    var $thisIcon = $(this);

                    qodefIcon.iconHoverColor($thisIcon);
                    qodefIcon.iconHoverBgColor($thisIcon);
                    qodefIcon.iconHoverBorderColor($thisIcon);
                });
            }
        },
        iconHoverColor: function ($iconHolder) {
            if (typeof $iconHolder.data('hover-color') !== 'undefined') {
                var spanHolder = $iconHolder.find('span');
                var originalColor = spanHolder.css('color');
                var hoverColor = $iconHolder.data('hover-color');

                $iconHolder.on('mouseenter', function () {
                    qodefIcon.changeColor(spanHolder, 'color', hoverColor);
                });
                $iconHolder.on('mouseleave', function () {
                    qodefIcon.changeColor(spanHolder, 'color', originalColor);
                });
            }
        },
        iconHoverBgColor: function ($iconHolder) {
            if (typeof $iconHolder.data('hover-background-color') !== 'undefined') {
                var hoverBackgroundColor = $iconHolder.data('hover-background-color');
                var originalBackgroundColor = $iconHolder.css('background-color');

                $iconHolder.on('mouseenter', function () {
                    qodefIcon.changeColor($iconHolder, 'background-color', hoverBackgroundColor);
                });
                $iconHolder.on('mouseleave', function () {
                    qodefIcon.changeColor($iconHolder, 'background-color', originalBackgroundColor);
                });
            }
        },
        iconHoverBorderColor: function ($iconHolder) {
            if (typeof $iconHolder.data('hover-border-color') !== 'undefined') {
                var hoverBorderColor = $iconHolder.data('hover-border-color');
                var originalBorderColor = $iconHolder.css('borderTopColor');

                $iconHolder.on('mouseenter', function () {
                    qodefIcon.changeColor($iconHolder, 'border-color', hoverBorderColor);
                });
                $iconHolder.on('mouseleave', function () {
                    qodefIcon.changeColor($iconHolder, 'border-color', originalBorderColor);
                });
            }
        },
        changeColor: function (iconElement, cssProperty, color) {
            iconElement.css(cssProperty, color);
        }
    };
	
	qodefCore.shortcodes.roisin_core_icon.qodefIcon = qodefIcon;

})(jQuery);
(function ($) {
    "use strict";
	qodefCore.shortcodes.roisin_core_image_gallery = {};
	qodefCore.shortcodes.roisin_core_image_gallery.qodefSwiper = qodef.qodefSwiper;
	qodefCore.shortcodes.roisin_core_image_gallery.qodefMasonryLayout = qodef.qodefMasonryLayout;

})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		imageWithText.init();
	});
	
	var imageWithText = {
		init: function () {
			var $imageWithText = $('.qodef-image-with-text'),
				$imageWithTextVertText = $imageWithText.find('.qodef-m-content svg'),
				$imageWithTextImageOver = $imageWithText.find('.qodef-m-image-over'),
				$imageWithTextImageOverImg = $imageWithTextImageOver.find('img');
            
            $imageWithTextVertText.each(function() {
                var thisIwtVertText = $(this);
                thisIwtVertText.appear(function() {
                    thisIwtVertText.addClass('qodef--appear');
                }, { accX: 0, accY: 0});
			});
			
			$imageWithTextImageOver.each(function() {
				var thisItem = $(this);

				thisItem.appear(function() {
                    thisItem.addClass('qodef--appear');
                }, { accX: 0, accY: 0});
			});
			
			if ($imageWithTextImageOverImg.length) {
				imageWithText.imageOverInitParallax($imageWithTextImageOverImg);
			}
		},
		imageOverInitParallax: function($items) {

			if ($items.length) {
                $items.each(function() {
					var $thisItem = $(this),
						randomNum =  Math.floor(Math.random() * 26) + 10;

                    // Set Parallax values
                    $thisItem.attr('data-parallax', '{"y": -'+ randomNum +', "smoothness": 100}');

                    imageWithText.parallax();
                });
            }
		},
		parallax: function() {
            var parallaxIntances = $("[data-parallax]");
		
            if (parallaxIntances.length && !qodef.html.hasClass('touch')) {
                ParallaxScroll.init(); //initialzation removed from plugin js file to have it run only on non-touch devices
            }
        }
	};
	
})(jQuery);

(function ($) {
	'use strict';
	
	qodefCore.shortcodes.roisin_core_progress_bar = {};
	
	$(document).ready(function () {
		qodefProgressBar.init();
	});

	/**
	 * Init progress bar shortcode functionality
	 */
	var qodefProgressBar = {
		init: function () {
			this.holder = $('.qodef-progress-bar');

			if (this.holder.length) {
				this.holder.each(function () {
					var $thisHolder = $(this),
						layout = $thisHolder.data('layout'),
						data = qodefProgressBar.generateBarData($thisHolder, layout),
						container = '#qodef-m-canvas-' + $thisHolder.data('rand-number'),
						number = $thisHolder.data('number') / 100;
						
					switch (layout) {
						case 'circle':
							qodefProgressBar.initCircleBar(container, data, number);
							break;
						case 'semi-circle':
							qodefProgressBar.initSemiCircleBar(container, data, number);
							break;
						case 'line':
							number = $thisHolder.data('number');
							container = $thisHolder.find('.qodef-m-canvas');
							data = qodefProgressBar.generateLineData($thisHolder, layout, number);
							qodefProgressBar.initLineBar(container, data);
							break;
						case 'custom':
							container = "#" + $thisHolder.data('custom-shape-id');
							qodefProgressBar.initCustomBar(container, data, number);
							break;
					}
				});
			}
		},
		generateBarData: function (thisBar, layout) {
			var activeWidth = thisBar.data('active-line-width');
			var activeColor = thisBar.data('active-line-color');
			var inactiveWidth = thisBar.data('inactive-line-width');
			var inactiveColor = thisBar.data('inactive-line-color');
			var easing = 'linear';
			var duration = 1400;
			var textColor = thisBar.data('text-color');

			return {
				strokeWidth: activeWidth,
				color: activeColor,
				trailWidth: inactiveWidth,
				trailColor: inactiveColor,
				easing: easing,
				duration: duration,
				svgStyle: {
					width: '100%',
					height: '100%'
				},
				text: {
					style: {
						color: textColor
					},
					autoStyleContainer: false
				},
				from: {
					color: inactiveColor
				},
				to: {
					color: activeColor
				},
				step: function (state, bar) {
					if (layout !== 'custom') {
						bar.setText(Math.round(bar.value() * 100) + '%');
					}
				}
			};
		},
		generateLineData: function (thisBar, layout, number) {
			var height = thisBar.data('active-line-width');
			var activeColor = thisBar.data('active-line-color');
			var inactiveHeight = thisBar.data('inactive-line-width');
			var inactiveColor = thisBar.data('inactive-line-color');
			var duration = 800;
			var textColor = thisBar.data('text-color');

			return {
				percentage: number,
				duration: duration,
				fillBackgroundColor: activeColor,
				backgroundColor: inactiveColor,
				height: height,
				inactiveHeight: inactiveHeight,
				followText: true,
				textColor: textColor
			};
		},
		initCircleBar: function (container, data, number) {
			var bar = new ProgressBar.Circle(container, data);

			$(container).appear(function () {
				bar.animate(number);
			});
		},
		initSemiCircleBar: function (container, data, number) {
			var bar = new ProgressBar.SemiCircle(container, data);

			$(container).appear(function () {
				bar.animate(number);
			});
		},
		initCustomBar: function (container, data, number) {
			var bar = new ProgressBar.Path(container, data);
			bar.set(0);

			$(container).appear(function () {
				bar.animate(number);
			});
		},
		initLineBar: function (container, data) {
			$(container).appear(function () {
				container.LineProgressbar(data);
			});
		}
	};
	
	qodefCore.shortcodes.roisin_core_progress_bar.qodefProgressBar = qodefProgressBar;
})(jQuery);
(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefSectionTitleAnimation.init();
    });
    
    /**
     * Section Title Animation
     */
    var qodefSectionTitleAnimation = {
        init: function () {
            var $holder = $('.qodef-section-title');

            if ($holder.length) {
                $holder.each(function() {
                    var $thisHolder = $(this),
                        $thisSubtitle = $thisHolder.find('.qodef-m-subtitle span'),
                        thisSubtitleText = $thisSubtitle.text(),
                        thisSubtitleTextArray = thisSubtitleText.split(''),
                        thisSubtitleTextArrayLength = thisSubtitleTextArray.length - 1;
                    
                    $thisSubtitle.empty();

                    thisSubtitleTextArray.forEach(function(item) {
                        $thisSubtitle.append('<span>' + item + '</span>')
                    });

                    $thisSubtitle.css('opacity', 1);

                    $thisSubtitle.appear(function() {
                        $thisSubtitle.find('span').each(function(i) {
                            var $thisSpan = $(this);
                            setTimeout(function() {
                                $thisSpan.addClass('qodef--show');
                                if (i === thisSubtitleTextArrayLength) {
                                    $thisSubtitle.addClass('qodef--animate-line');
                                }
                            }, i * 30);
                        })
                    }, {accX: 0, accY: 0});
                });
            }
        },
    }

})(jQuery);
(function ($) {
	"use strict";
	
	qodefCore.shortcodes.roisin_core_tabs = {};
	
	$(document).ready(function () {
		qodefTabs.init();
	});
	
	var qodefTabs = {
		init: function () {
			this.holder = $('.qodef-tabs');
			
			if (this.holder.length) {
				this.holder.each(function () {
					qodefTabs.initTabs($(this));
				});
			}
		},
		initTabs: function ($tabs) {
			$tabs.children('.qodef-tabs-content').each(function (index) {
				index = index + 1;
				
				var $that = $(this),
					link = $that.attr('id'),
					$navItem = $that.parent().find('.qodef-tabs-navigation li:nth-child(' + index + ') a'),
					navLink = $navItem.attr('href');
				
				link = '#' + link;
				
				if (link.indexOf(navLink) > -1) {
					$navItem.attr('href', link);
				}
			});
			
			$tabs.addClass('qodef--init').tabs();
		}
	};
	
	qodefCore.shortcodes.roisin_core_tabs.qodefTabs = qodefTabs;
	
})(jQuery);
(function ($) {
    "use strict";
	
	qodefCore.shortcodes.roisin_core_vertical_split_slider = {};

    $(document).ready(function () {
        qodefVerticalSplitSlider.init();
    });

    var qodefVerticalSplitSlider = {
        init: function () {
            var $holder = $('.qodef-vertical-split-slider'),
                breakpoint = qodefVerticalSplitSlider.getBreakpoint($holder),
                initialHeaderStyle = '';

            if (qodef.body.hasClass('qodef-header--light')) {
                initialHeaderStyle = 'light';
            } else if (qodef.body.hasClass('qodef-header--dark')) {
                initialHeaderStyle = 'dark';
            }

            if ($holder.length) {
                $holder.multiscroll({
                    navigation: true,
                    scrollingSpeed: 0,
                    navigationPosition: 'right',
                    afterRender: function () {
                        qodef.body.addClass('qodef-vertical-split-slider--initialized');
                        qodefVerticalSplitSlider.bodyClassHandler($('.ms-left .ms-section:first-child').data('header-skin'), initialHeaderStyle);
                    },
                    onLeave: function (index, nextIndex) {
                        qodefVerticalSplitSlider.bodyClassHandler($($('.ms-left .ms-section')[nextIndex - 1]).data('header-skin'), initialHeaderStyle);
                    }
                });

                $holder.height(qodef.windowHeight);
                qodefVerticalSplitSlider.buildAndDestroy(breakpoint);

                $(window).resize(function () {
                    qodefVerticalSplitSlider.buildAndDestroy(breakpoint);
                });
            }
        },
        getBreakpoint: function ($holder) {
            if ($holder.hasClass('qodef-disable-below--768')) {
                return 768;
            } else {
                return 1024;
            }
        },
        buildAndDestroy: function (breakpoint) {
            if (qodef.windowWidth <= breakpoint) {
                $.fn.multiscroll.destroy();
                $('html, body').css('overflow', 'initial');
                qodef.body.removeClass('qodef-vertical-split-slider--initialized');
            } else {
                $.fn.multiscroll.build();
                qodef.body.addClass('qodef-vertical-split-slider--initialized');
            }
        },
        bodyClassHandler: function (slideHeaderStyle, initialHeaderStyle) {
            if (slideHeaderStyle !== undefined && slideHeaderStyle !== '') {
                qodef.body.removeClass('qodef-header--light qodef-header--dark').addClass('qodef-header--' + slideHeaderStyle);
            } else if (initialHeaderStyle !== '') {
                qodef.body.removeClass('qodef-header--light qodef-header--dark').addClass('qodef-header--' + slideHeaderStyle);
            } else {
                qodef.body.removeClass('qodef-header--light qodef-header--dark');
            }
        }
    };
	
	qodefCore.shortcodes.roisin_core_vertical_split_slider.qodefVerticalSplitSlider = qodefVerticalSplitSlider;

})(jQuery);
(function ($) {
	
    "use strict";
	qodefCore.shortcodes.roisin_core_blog_list = {};
	qodefCore.shortcodes.roisin_core_blog_list.qodefPagination = qodef.qodefPagination;
	qodefCore.shortcodes.roisin_core_blog_list.qodefFilter = qodef.qodefFilter;
	qodefCore.shortcodes.roisin_core_blog_list.qodefJustifiedGallery = qodef.qodefJustifiedGallery;
	qodefCore.shortcodes.roisin_core_blog_list.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.roisin_core_blog_list.qodefSwiper = qodef.qodefSwiper;

})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefVerticalNavMenu.init();
	});
	
	/**
	 * Function object that represents vertical menu area.
	 * @returns {{init: Function}}
	 */
	var qodefVerticalNavMenu = {
		initNavigation: function ($verticalMenuObject) {
			var $verticalNavObject = $verticalMenuObject.find('.qodef-header-vertical-navigation');
			
			if ($verticalNavObject.hasClass('qodef-vertical-drop-down--below')) {
				qodefVerticalNavMenu.dropdownClickToggle($verticalNavObject);
			} else if ($verticalNavObject.hasClass('qodef-vertical-drop-down--side')) {
				qodefVerticalNavMenu.dropdownFloat($verticalNavObject);
			}
		},
		dropdownClickToggle: function ($verticalNavObject) {
			var $menuItems = $verticalNavObject.find('ul li.menu-item-has-children');
			
			$menuItems.each(function () {
				var $elementToExpand = $(this).find(' > .qodef-drop-down-second, > ul');
				var menuItem = this;
				var $dropdownOpener = $(this).find('> a');
				var slideUpSpeed = 'fast';
				var slideDownSpeed = 'slow';
				
				$dropdownOpener.on('click tap', function (e) {
					e.preventDefault();
					e.stopPropagation();
					
					if ($elementToExpand.is(':visible')) {
						$(menuItem).removeClass('qodef-menu-item--open');
						$elementToExpand.slideUp(slideUpSpeed);
					} else if ($dropdownOpener.parent().parent().children().hasClass('qodef-menu-item--open') && $dropdownOpener.parent().parent().parent().hasClass('qodef-vertical-menu')) {
						$(this).parent().parent().children().removeClass('qodef-menu-item--open');
						$(this).parent().parent().children().find(' > .qodef-drop-down-second').slideUp(slideUpSpeed);
						
						$(menuItem).addClass('qodef-menu-item--open');
						$elementToExpand.slideDown(slideDownSpeed);
					} else {
						
						if (!$(this).parents('li').hasClass('qodef-menu-item--open')) {
							$menuItems.removeClass('qodef-menu-item--open');
							$menuItems.find(' > .qodef-drop-down-second, > ul').slideUp(slideUpSpeed);
						}
						
						if ($(this).parent().parent().children().hasClass('qodef-menu-item--open')) {
							$(this).parent().parent().children().removeClass('qodef-menu-item--open');
							$(this).parent().parent().children().find(' > .qodef-drop-down-second, > ul').slideUp(slideUpSpeed);
						}
						
						$(menuItem).addClass('qodef-menu-item--open');
						$elementToExpand.slideDown(slideDownSpeed);
					}
				});
			});
		},
		dropdownFloat: function ($verticalNavObject) {
			var $menuItems = $verticalNavObject.find('ul li.menu-item-has-children');
			var $allDropdowns = $menuItems.find(' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul');
			
			$menuItems.each(function () {
				var $elementToExpand = $(this).find(' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul');
				var menuItem = this;
				
				if (Modernizr.touch) {
					var $dropdownOpener = $(this).find('> a');
					
					$dropdownOpener.on('click tap', function (e) {
						e.preventDefault();
						e.stopPropagation();
						
						if ($elementToExpand.hasClass('qodef-float--open')) {
							$elementToExpand.removeClass('qodef-float--open');
							$(menuItem).removeClass('qodef-menu-item--open');
						} else {
							if (!$(this).parents('li').hasClass('qodef-menu-item--open')) {
								$menuItems.removeClass('qodef-menu-item--open');
								$allDropdowns.removeClass('qodef-float--open');
							}
							
							$elementToExpand.addClass('qodef-float--open');
							$(menuItem).addClass('qodef-menu-item--open');
						}
					});
				} else {
					//must use hoverIntent because basic hover effect doesn't catch dropdown
					//it doesn't start from menu item's edge
					$(this).hoverIntent({
						over: function () {
							$elementToExpand.addClass('qodef-float--open');
							$(menuItem).addClass('qodef-menu-item--open');
						},
						out: function () {
							$elementToExpand.removeClass('qodef-float--open');
							$(menuItem).removeClass('qodef-menu-item--open');
						},
						timeout: 300
					});
				}
			});
		},
		verticalAreaScrollable: function ($verticalMenuObject) {
			return $verticalMenuObject.hasClass('qodef-with-scroll');
		},
		initVerticalAreaScroll: function ($verticalMenuObject) {
			if (qodefVerticalNavMenu.verticalAreaScrollable($verticalMenuObject)) {
				window.qodefCore.qodefPerfectScrollbar.init($verticalMenuObject);
			}
		},
		init: function () {
			var $verticalMenuObject = $('.qodef-header--vertical #qodef-page-header');
			
			if ($verticalMenuObject.length) {
				qodefVerticalNavMenu.initNavigation($verticalMenuObject);
				qodefVerticalNavMenu.initVerticalAreaScroll($verticalMenuObject);
			}
		}
	};
	
})(jQuery);
(function($){
    "use strict";

    var fixedHeaderAppearance = {
        showHideHeader: function($pageOuter, $header){
            if(qodef.windowWidth > 1024) {
                if (qodef.scroll <= 0) {
                    qodef.body.removeClass('qodef-header--fixed-display');
                    $pageOuter.css('padding-top', '0');
                    $header.css('margin-top', '0');
                } else {
                    qodef.body.addClass('qodef-header--fixed-display');
                    $pageOuter.css('padding-top', parseInt(qodefGlobal.vars.headerHeight + qodefGlobal.vars.topAreaHeight) + 'px');
                    $header.css('margin-top', parseInt(qodefGlobal.vars.topAreaHeight) + 'px');
                }
            }
        },
        init: function(){
            var $pageOuter = $('#qodef-page-outer'),
                $header = $('#qodef-page-header');
            fixedHeaderAppearance.showHideHeader($pageOuter, $header);
            $(window).scroll(function() {
                fixedHeaderAppearance.showHideHeader($pageOuter, $header);
            });
            $(window).resize(function() {
                $pageOuter.css('padding-top', '0');
                fixedHeaderAppearance.showHideHeader($pageOuter, $header);
            });
        }
    };
    
    qodef.fixedHeaderAppearance = fixedHeaderAppearance.init;

})(jQuery);
(function ($) {
	"use strict";
	
	var stickyHeaderAppearance = {
		displayAmount: function () {
			if (qodefGlobal.vars.qodefStickyHeaderScrollAmount !== 0) {
				return parseInt(qodefGlobal.vars.qodefStickyHeaderScrollAmount);
			} else {
				return parseInt(qodefGlobal.vars.headerHeight + qodefGlobal.vars.adminBarHeight);
			}
		},
		showHideHeader: function (displayAmount) {
			
			if (qodef.scroll < displayAmount) {
				qodef.body.removeClass('qodef-header--sticky-display');
			} else {
				qodef.body.addClass('qodef-header--sticky-display');
			}
		},
		init: function () {
			var displayAmount = stickyHeaderAppearance.displayAmount();
			
			stickyHeaderAppearance.showHideHeader(displayAmount);
			$(window).scroll(function () {
				stickyHeaderAppearance.showHideHeader(displayAmount);
			});
		}
	};
	
	qodef.stickyHeaderAppearance = stickyHeaderAppearance.init;
	
})(jQuery);
(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.roisin_core_instagram_list = {};

	$( document ).ready(
		function () {
			qodefInstagram.init();
		}
	);

	var qodefInstagram = {
		init: function () {
			this.holder = $( '.qodef-instagram-list #sb_instagram' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {

						if ( $( this ).parent().hasClass( 'qodef-instagram-columns' ) ) {
							var $imagesHolder  = $( this ).find( '#sbi_images' ),
								$images        = $imagesHolder.find( '.sbi_item.sbi_type_image, .sbi_item.sbi_type_carousel' ),
								initialPadding = $imagesHolder.css( 'padding' );

							// remove some unnecessary paddings
							$imagesHolder.css('padding', '0');
							$imagesHolder.css('margin', '-' + initialPadding);
							$imagesHolder.css('width', 'calc(100% + ' + ( initialPadding) + ' + ' + ( initialPadding) + ')');

							$images.attr('style', 'padding: ' + initialPadding + '!important');
						} else if ( $( this ).parent().hasClass( 'qodef-instagram-slider' ) ) {
							qodefInstagram.initSlider( $( this ) );
						}
					}
				);
			}
		},
		initSlider: function ( $currentItem, $initAllItems ) {

			var $imagesHolder  = $currentItem.find( '#sbi_images' ),
				$images        = $currentItem.find( '.sbi_item.sbi_type_image' ),
				initialPadding = $imagesHolder.css( 'padding' );

			// remove some unnecessary paddings
			$imagesHolder.css('padding', '0');
			$images.css('padding', '0');

			// items will inherit this margin
			$imagesHolder.attr('style', 'margin-right: ' + (parseInt( initialPadding ) * 2) + 'px !important');

			var sliderOptions = {};

			sliderOptions.spaceBetween      = parseInt( initialPadding ) * 2;
			sliderOptions.customStages      = true;
			sliderOptions.slidesPerView     = $currentItem.data( 'cols' ) !== undefined && $currentItem.data( 'cols' ) !== '' ? $currentItem.data( 'cols' ) : 3;
			sliderOptions.slidesPerView1200 = $currentItem.data( 'cols' ) !== undefined && $currentItem.data( 'cols' ) !== '' ? $currentItem.data( 'cols' ) : 3;
			sliderOptions.slidesPerView880  = $currentItem.data( 'colstablet' ) !== undefined && $currentItem.data( 'colstablet' ) !== '' ? $currentItem.data( 'colstablet' ) : 2;
			sliderOptions.slidesPerView680  = $currentItem.data( 'colsmobile' ) !== undefined && $currentItem.data( 'colsmobile' ) !== '' ? $currentItem.data( 'colsmobile' ) : 1;

			$currentItem.attr( 'data-options', JSON.stringify(sliderOptions) );

			$imagesHolder.parent( '#sb_instagram' ).addClass( 'qodef-swiper-container' );
			$imagesHolder.addClass( 'swiper-wrapper' );

			if ( $images.length ) {
				$images.each(
					function () {
						$( this ).addClass( 'qodef-e qodef-image-wrapper swiper-slide' );
					}
				);
			}

			if ( typeof qodef.qodefSwiper === 'object' ) {

				if ( false === $initAllItems ) {
					qodef.qodefSwiper.initSlider( $currentItem );
				} else {
					qodef.qodefSwiper.init( $currentItem );
				}
			}
		},
	};

	qodefCore.shortcodes.roisin_core_instagram_list.qodefInstagram = qodefInstagram;
	qodefCore.shortcodes.roisin_core_instagram_list.qodefSwiper    = qodef.qodefSwiper;

})( jQuery );

(function ($) {
    "use strict";

    $(document).ready(function(){
        qodefSearchCoversHeader.init();
    });

    var qodefSearchCoversHeader = {
        init: function(){
            var $searchOpener = $('a.qodef-search-opener'),
                $searchForm = $('form.qodef-search-cover'),
                $searchClose = $('.qodef-search-close');

            if ($searchOpener.length && $searchForm.length) {
                $searchOpener.on('click', function (e) {
                    e.preventDefault();
                    qodefSearchCoversHeader.openCoversHeader($searchForm);

                });
                $searchClose.on('click', function (e) {
                    e.preventDefault();
                    qodefSearchCoversHeader.closeCoversHeader($searchForm);
                });
            }
        },
        openCoversHeader: function($searchForm){
            qodef.body.addClass('qodef-covers-search--opened qodef-covers-search--fadein');
            qodef.body.removeClass('qodef-covers-search--fadeout');

            setTimeout(function () {
                $searchForm.find('.qodef-search-field').focus();
            }, 600);
        },
        closeCoversHeader: function($searchForm){
            qodef.body.removeClass('qodef-covers-search--opened qodef-covers-search--fadein');
            qodef.body.addClass('qodef-covers-search--fadeout');

            setTimeout(function () {
                $searchForm.find('.qodef-search-field').val('');
                $searchForm.find('.qodef-search-field').blur();
                qodef.body.removeClass('qodef-covers-search--fadeout');
            }, 300);
        }
    };

})(jQuery);

(function($) {
    "use strict";

    $(document).ready(function(){
        qodefSearchFullscreen.init();
    });

	var qodefSearchFullscreen = {
	    init: function(){
            var $searchOpener = $('a.qodef-search-opener'),
                $searchHolder = $('.qodef-fullscreen-search-holder'),
                $searchClose = $('.qodef-search-close');

            $searchHolder.append('<div class="qodef-fullscreen-search-menu-overlay"></div>');

            var $fsSearchOverlay = $('.qodef-fullscreen-search-menu-overlay');

            if ($searchOpener.length && $searchHolder.length) {
                $searchOpener.on('click', function (e) {
                    e.preventDefault();
                    if(qodef.body.hasClass('qodef-fullscreen-search--opened')){
                        qodefSearchFullscreen.closeFullscreen($searchHolder);
                    }else{
                        qodefSearchFullscreen.openFullscreen($searchHolder);
                    }
                });
                $searchClose.on('click', function (e) {
                    e.preventDefault();
                    qodefSearchFullscreen.closeFullscreen($searchHolder);
                });

                $fsSearchOverlay.on('click', function() {
                    if (qodef.body.hasClass('qodef-fullscreen-search--opened')) {
                        qodefSearchFullscreen.closeFullscreen($searchHolder);
                        $('.qodef-svg-close-cursor').css('opacity', 0);
                    }
                });

                //Close on escape
                $(document).keyup(function (e) {
                    if (e.keyCode === 27) { //KeyCode for ESC button is 27
                        qodefSearchFullscreen.closeFullscreen($searchHolder);
                    }
                });
            }
        },
        openFullscreen: function($searchHolder){
            qodef.body.removeClass('qodef-fullscreen-search--fadeout');
	        qodef.body.addClass('qodef-fullscreen-search--opened qodef-fullscreen-search--fadein');

            setTimeout(function () {
                $searchHolder.find('.qodef-search-field').focus();
            }, 900);

            qodefCore.qodefScroll.disable();
        },
        closeFullscreen: function($searchHolder){
            qodef.body.removeClass('qodef-fullscreen-search--opened qodef-fullscreen-search--fadein');
            qodef.body.addClass('qodef-fullscreen-search--fadeout');

            setTimeout(function () {
                $searchHolder.find('.qodef-search-field').val('');
                $searchHolder.find('.qodef-search-field').blur();
                qodef.body.removeClass('qodef-fullscreen-search--fadeout');
            }, 300);

            qodefCore.qodefScroll.enable();
        }
    };

})(jQuery);

(function ($) {
    "use strict";
	qodefCore.shortcodes.roisin_core_product_categories_list = {};
	qodefCore.shortcodes.roisin_core_product_categories_list.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.roisin_core_product_categories_list.qodefSwiper = qodef.qodefSwiper;

})(jQuery);
(function ($) {
	
    "use strict";
	qodefCore.shortcodes.roisin_core_product_list = {};
	qodefCore.shortcodes.roisin_core_product_list.qodefPagination = qodef.qodefPagination;
	qodefCore.shortcodes.roisin_core_product_list.qodefFilter = qodef.qodefFilter;
	qodefCore.shortcodes.roisin_core_product_list.qodefJustifiedGallery = qodef.qodefJustifiedGallery;
	qodefCore.shortcodes.roisin_core_product_list.qodefMasonryLayout = qodef.qodefMasonryLayout;

})(jQuery);
(function ($) {
	
    "use strict";
	qodefCore.shortcodes.roisin_core_portfolio_list = {};
	
	$(document).ready(function () {
		qodefPortfolioSliderHeight.init();
	});
	var qodefPortfolioSliderHeight = {
		init: function () {
			var $portfolioSliderWithHeight = $('.qodef-portfolio-list.qodef-swiper-container.qodef-portfolio-slider-with-height');
			
			if ($portfolioSliderWithHeight.length) {
				$portfolioSliderWithHeight.each(function () {
					var $thisPortfolioSlider = $(this),
						$items = $thisPortfolioSlider.find('.qodef-e.swiper-slide'),
						$headerHeight = $('#qodef-page-header').outerHeight(),
						$mobileHeaderHeight = $('#qodef-page-mobile-header').outerHeight(),
						$topBar = $('#qodef-top-area'),
						$footer = $('#qodef-page-footer'),
						$title = $('.qodef-page-title'),
						$titleHeight,
						$footerHeight,
						$topBarHeight;
					
					if($topBar.length && qodef.windowWidth > 768) {
						$topBarHeight = $topBar.outerHeight();
					} else {
						$topBarHeight = 0;
					}
					
					if($footer.length) {
						$footerHeight = $footer.outerHeight();
					} else {
						$footerHeight = 0;
					}
					
					if($title.length) {
						$titleHeight = $title.outerHeight();
					} else {
						$titleHeight = 0;
					}
					
					if(qodef.windowWidth <= 1024) {
						$items.height(qodef.windowHeight - $mobileHeaderHeight - $topBarHeight - $titleHeight - $footerHeight);
					} else {
						$items.height(qodef.windowHeight - $headerHeight - $topBarHeight - $titleHeight - $footerHeight - 25);
					}
				});
			}
		}
	};
	
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefPagination = qodef.qodefPagination;
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefFilter = qodef.qodefFilter;
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefJustifiedGallery = qodef.qodefJustifiedGallery;
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefSwiper = qodef.qodefSwiper;

})(jQuery);
(function ($) {
    "use strict";
	qodefCore.shortcodes.roisin_core_testimonials_list = {};
	qodefCore.shortcodes.roisin_core_testimonials_list.qodefSwiper = qodef.qodefSwiper;

})(jQuery);
(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefProductListAsynchronAnimation.init();
    });
    
    /**
     * Product List Asynchron
     */
    var qodefProductListAsynchronAnimation = {
        init: function () {
            var $holder = $('.qodef-shortcode.qodef-woo-product-list.qodef-item-layout--asynchron');

            if ($holder.length && qodef.windowWidth>680) {
                $holder.each(function() {
                    var $thisHolder = $(this),
                        $thisItems = $thisHolder.find('.qodef-woo-product-inner .qodef-has-additional-image'),
                        $thisProductInner = $thisHolder.find('.qodef-woo-product-inner'),
                        $thisItemsImg2 = $thisItems.find('img:nth-child(2)'),
                        $thisItems2 = $thisHolder.find('.qodef-woo-product-inner .qodef-woo-product-image:not(.qodef-has-additional-image)');

                    // Set Parallax values
                    $thisProductInner.css('bottom', '-80px');
                    $thisProductInner.attr('data-parallax', '{"y": -20, "smoothness": 40}');
                    $thisItemsImg2.css('bottom', '-80px');
                    $thisItemsImg2.attr('data-parallax', '{"y": -30, "smoothness": 20}');
                    $thisItems2.parent().attr('data-parallax', '{"y": 40, "smoothness": 20}');

                    qodefProductListAsynchronAnimation.parallax();
                    // Appear animation for items
                    qodefProductListAsynchronAnimation.appear($thisItems);
                });
            }
        },
        appear: function(items) {
            // Appear
            items.each(function(i) {
                var thisItem = $(this);

                if (i % 2 === 0) {
                    thisItem.addClass('qodef--even');
                }

                thisItem.appear(function() {
                    $(this).addClass('qodef--appear');
                }, { accX: 0, accY: 200 } )
            });
        },
        parallax: function() {
            var parallaxIntances = $("[data-parallax]");
		
            if (parallaxIntances.length && !qodef.html.hasClass('touchevents')) {
                ParallaxScroll.init(); //initialzation removed from plugin js file to have it run only on non-touch devices
            }
        }
    }

})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefInfoFollow.init();
	});
	
	$(document).on('roisin_trigger_get_new_posts', function () {
		qodefInfoFollow.init();
	});
	
	var qodefInfoFollow = {
		init: function () {
			var $gallery = $('.qodef-hover-animation--follow');
			
			if ($gallery.length) {
				qodef.body.append('<div class="qodef-follow-info-holder"><div class="qodef-follow-info-inner"><span class="qodef-follow-info-category"></span><br/><span class="qodef-follow-info-title"></span></div></div>');
				
				var $followInfoHolder = $('.qodef-follow-info-holder'),
					$followInfoCategory = $followInfoHolder.find('.qodef-follow-info-category'),
					$followInfoTitle = $followInfoHolder.find('.qodef-follow-info-title');
				
				$gallery.each(function () {
					$gallery.find('.qodef-e-inner').each(function () {
						var $thisItem = $(this);
						
						//info element position
						$thisItem.on('mousemove', function (e) {
                            if(e.clientX + 20 + $followInfoHolder.width() > qodef.windowWidth){
                                $followInfoHolder.addClass('qodef-right');
                            }else{
                                $followInfoHolder.removeClass('qodef-right');
                            }

							$followInfoHolder.css({
								top: e.clientY + 20,
								left: e.clientX + 20
							});
						});
						
						//show/hide info element
						$thisItem.on('mouseenter', function () {
							var $thisItemTitle = $(this).find('.qodef-e-title'),
								$thisItemCategory = $(this).find('.qodef-e-info-category');
							
							if ($thisItemTitle.length) {
								$followInfoTitle.html($thisItemTitle.clone());
							}
							
							if ($thisItemCategory.length) {
								$followInfoCategory.html($thisItemCategory.html());
							}
							
							if (!$followInfoHolder.hasClass('qodef-is-active')) {
								$followInfoHolder.addClass('qodef-is-active');
							}
						}).on('mouseleave', function () {
							if ($followInfoHolder.hasClass('qodef-is-active')) {
								$followInfoHolder.removeClass('qodef-is-active');
							}
						});
					});
				});
			}
		}
	};
	
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefInfoFollow = qodefInfoFollow;
	
})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefHoverDir.init();
	});
	
	$(document).on('roisin_trigger_get_new_posts', function () {
		qodefHoverDir.init();
	});
	
	var qodefHoverDir = {
		init: function () {
			var $gallery = $('.qodef-hover-animation--direction-aware');
			
			if ($gallery.length) {
				$gallery.each(function () {
					var $this = $(this);
					$this.find('article:not(.qodef-simple-portfolio-list-item)').each(function () {
						$(this).hoverdir({
							hoverElem: 'div.qodef-e-content',
							speed: 330,
							hoverDelay: 35,
							easing: 'ease'
						});
					});
				});
			}
		}
	};
	
	qodefCore.shortcodes.roisin_core_portfolio_list.qodefHoverDir = qodefHoverDir;
	
})(jQuery);