<?php

if ( ! function_exists( 'roisin_core_is_back_to_top_enabled' ) ) {
	function roisin_core_is_back_to_top_enabled() {
		return roisin_core_get_post_value_through_levels( 'qodef_back_to_top' ) !== 'no';
	}
}

if ( ! function_exists( 'roisin_core_add_back_to_top_to_body_classes' ) ) {
	function roisin_core_add_back_to_top_to_body_classes( $classes ) {
		$classes[] = roisin_core_is_back_to_top_enabled() ? 'qodef-back-to-top--enabled' : '';
		
		return $classes;
	}
	
	add_filter( 'body_class', 'roisin_core_add_back_to_top_to_body_classes' );
}

if ( ! function_exists( 'roisin_core_load_back_to_top' ) ) {
	/**
	 * Loads Back To Top HTML
	 */
	function roisin_core_load_back_to_top() {
		
		if ( roisin_core_is_back_to_top_enabled() ) {
			$parameters = array();
			
			roisin_core_template_part( 'back-to-top', 'templates/back-to-top', '', $parameters );
		}
	}
	
	add_action( 'roisin_action_before_wrapper_close_tag', 'roisin_core_load_back_to_top' );
}