<?php

if ( ! function_exists( 'roisin_core_add_page_content_side_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_page_content_side_meta_box( $page ) {
		
		if ( $page ) {
			
			$content_side_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-content-side',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Content Side Settings', 'roisin-core' ),
					'description' => esc_html__( 'Content Side layout settings', 'roisin-core' )
				)
			);
			
			$content_side_tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_enable_content_side_left_area',
					'title'         => esc_html__( 'Enable Content Side Left Area', 'roisin-core' ),
					'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'roisin-core' ),
					'options'     => roisin_core_get_select_type_options_pool( 'no_yes' )
				)
			);
		}
	}
	
	add_action( 'roisin_core_action_after_general_meta_box_map', 'roisin_core_add_page_content_side_meta_box' );
}