<?php

if ( ! function_exists( 'roisin_core_get_content_side_area' ) ) {
	/**
	 * Loads content side area HTML with all needed parameters
	 */
	function roisin_core_get_content_side_area() {
		$parameters = array();
		
		//Current page id
		$id = qode_framework_get_page_id();
		
		//is content bottom area enabled for current page?
		$parameters['content_side_left_area'] = roisin_core_get_post_value_through_levels( 'qodef_enable_content_side_left_area', $id );
		
		if ( $parameters['content_side_left_area'] === 'yes' ) {
			
			//Sidebar for content bottom area
			roisin_core_template_part( 'content-side', 'templates/content-side-area', '', $parameters );
		}
	}
	
	add_action( 'roisin_action_before_footer_content', 'roisin_core_get_content_side_area' );
}

if ( ! function_exists( 'roisin_core_get_content_side_config' ) ) {
	/**
	 * Function that return config variables for content side
	 *
	 * @return array
	 */
	function roisin_core_get_content_side_config() {
		
		// Config variables
		$config = apply_filters( 'roisin_core_filter_content_side_config', array(
			'title_tag'   => 'h5',
			'title_class' => 'qodef-widget-title'
		) );
		
		return $config;
	}
}

if ( ! function_exists( 'roisin_core_register_content_side_sidebar' ) ) {
	/**
	 * Register side area sidebar
	 */
	function roisin_core_register_content_side_sidebar() {
		
		// Sidebar config variables
		$config = roisin_core_get_content_side_config();
		
		register_sidebar(
			array(
				'id'            => 'qodef-content-side',
				'name'          => esc_html__( 'Content Side', 'roisin-core' ),
				'description'   => esc_html__( 'Widgets added here will appear in content side area', 'roisin-core' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s" data-area="content-side">',
				'after_widget'  => '</div>',
				'before_title'  => '<'. roisin_core_escape_title_tag( $config['title_tag'] ) .' class="'. esc_attr( $config['title_class'] ) .'">',
				'after_title'   => '</'. roisin_core_escape_title_tag( $config['title_tag'] ) .'>'
			)
		);
	}
	
	add_action( 'widgets_init', 'roisin_core_register_content_side_sidebar' );
}