<?php

if ( ! function_exists( 'roisin_core_get_elementor_instance' ) ) {
    /**
     * Function that return page builder module instance
     */
    function roisin_core_get_elementor_instance() {
        return \Elementor\Plugin::instance();
    }
}

if ( ! function_exists( 'roisin_core_register_new_elementor_widget' ) ) {
    /**
     * Function that register a new widget type.
     *
     * @param \Elementor\Widget_Base $widget_instance Elementor Widget.
     */
    function roisin_core_register_new_elementor_widget( $widget_instance ) {

        if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
            return roisin_core_get_elementor_instance()->widgets_manager->register( $widget_instance );
        } else {
            return roisin_core_get_elementor_instance()->widgets_manager->register_widget_type( $widget_instance );
        }
    }
}

if ( ! function_exists( 'roisin_core_load_elementor_widgets' ) ) {
	function roisin_core_load_elementor_widgets() {
		if ( qode_framework_is_installed( 'elementor' ) ) {
			foreach ( glob( ROISIN_CORE_SHORTCODES_PATH . '/*/*-elementor.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
			
			foreach ( glob( ROISIN_CORE_INC_PATH . '/*/shortcodes/*/*-elementor.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}

			foreach ( glob( ROISIN_CORE_CPT_PATH . '/*/shortcodes/*/*-elementor.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}

    if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
        add_action( 'elementor/widgets/register', 'roisin_core_load_elementor_widgets' );
    } else {
        add_action( 'elementor/widgets/widgets_registered', 'roisin_core_load_elementor_widgets' );
    }
}