<?php

if ( ! function_exists( 'roisin_core_add_general_page_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_general_page_meta_box( $page ) {
		
		$general_tab = $page->add_tab_element(
			array(
				'name'        => 'tab-page',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Page Settings', 'roisin-core' ),
				'description' => esc_html__( 'General page layout settings', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_page_background_color',
				'title'       => esc_html__( 'Page Background Color', 'roisin-core' ),
				'description' => esc_html__( 'Set background color', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_page_background_image',
				'title'       => esc_html__( 'Page Background Image', 'roisin-core' ),
				'description' => esc_html__( 'Set background image', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_repeat',
				'title'       => esc_html__( 'Page Background Image Repeat', 'roisin-core' ),
				'description' => esc_html__( 'Set background image repeat', 'roisin-core' ),
				'options'     => array(
					''          => esc_html__( 'Default', 'roisin-core' ),
					'no-repeat' => esc_html__( 'No Repeat', 'roisin-core' ),
					'repeat'    => esc_html__( 'Repeat', 'roisin-core' ),
					'repeat-x'  => esc_html__( 'Repeat-x', 'roisin-core' ),
					'repeat-y'  => esc_html__( 'Repeat-y', 'roisin-core' )
				)
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_size',
				'title'       => esc_html__( 'Page Background Image Size', 'roisin-core' ),
				'description' => esc_html__( 'Set background image size', 'roisin-core' ),
				'options'     => array(
					''        => esc_html__( 'Default', 'roisin-core' ),
					'contain' => esc_html__( 'Contain', 'roisin-core' ),
					'cover'   => esc_html__( 'Cover', 'roisin-core' )
				)
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_attachment',
				'title'       => esc_html__( 'Page Background Image Attachment', 'roisin-core' ),
				'description' => esc_html__( 'Set background image attachment', 'roisin-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'roisin-core' ),
					'fixed'  => esc_html__( 'Fixed', 'roisin-core' ),
					'scroll' => esc_html__( 'Scroll', 'roisin-core' )
				)
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding',
				'title'       => esc_html__( 'Page Content Padding', 'roisin-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding_mobile',
				'title'       => esc_html__( 'Page Content Padding Mobile', 'roisin-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed',
				'title'         => esc_html__( 'Boxed Layout', 'roisin-core' ),
				'description'   => esc_html__( 'Set boxed layout', 'roisin-core' ),
				'default_value' => '',
				'options'       => roisin_core_get_select_type_options_pool( 'yes_no' )
			)
		);
		
		$boxed_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_boxed_section',
				'title'      => esc_html__( 'Boxed Layout Section', 'roisin-core' ),
				'dependency' => array(
					'hide' => array(
						'qodef_boxed' => array(
							'values'        => 'no',
							'default_value' => ''
						)
					)
				)
			)
		);
		
		$boxed_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_boxed_background_color',
				'title'       => esc_html__( 'Boxed Background Color', 'roisin-core' ),
				'description' => esc_html__( 'Set boxed background color', 'roisin-core' )
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_passepartout',
				'title'         => esc_html__( 'Passepartout', 'roisin-core' ),
				'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'roisin-core' ),
				'default_value' => '',
				'options'       => roisin_core_get_select_type_options_pool( 'yes_no' )
			)
		);
		
		$passepartout_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_passepartout_section',
				'dependency' => array(
					'hide' => array(
						'qodef_passepartout' => array(
							'values'        => 'no',
							'default_value' => ''
						)
					)
				)
			)
		);
		
		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_passepartout_color',
				'title'       => esc_html__( 'Passepartout Color', 'roisin-core' ),
				'description' => esc_html__( 'Choose background color for passepartout', 'roisin-core' )
			)
		);
		
		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_passepartout_image',
				'title'       => esc_html__( 'Passepartout Background Image', 'roisin-core' ),
				'description' => esc_html__( 'Set background image for passepartout', 'roisin-core' )
			)
		);
		
		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size',
				'title'       => esc_html__( 'Passepartout Size', 'roisin-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'roisin-core' )
				)
			)
		);
		
		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size_responsive',
				'title'       => esc_html__( 'Passepartout Responsive Size', 'roisin-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'roisin-core' )
				)
			)
		);
		
		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_content_width',
				'title'       => esc_html__( 'Initial Width of Content', 'roisin-core' ),
				'description' => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'roisin-core' ),
				'options'     => roisin_core_get_select_type_options_pool( 'content_width' )
			)
		);
		
		$general_tab->add_field_element( array(
			'field_type'    => 'yesno',
			'default_value' => 'no',
			'name'          => 'qodef_content_behind_header',
			'title'         => esc_html__( 'Always put content behind header', 'roisin-core' ),
			'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'roisin-core' ),
		) );
		
		// Hook to include additional options after module options
		do_action( 'roisin_core_action_after_general_page_meta_box_map', $general_tab );
	}
	
	add_action( 'roisin_core_action_after_general_meta_box_map', 'roisin_core_add_general_page_meta_box', 9 );
	add_action( 'roisin_core_action_after_portfolio_meta_box_map', 'roisin_core_add_general_page_meta_box' );
}