<?php

if ( ! function_exists( 'roisin_core_add_donation_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_donation_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'give_forms' ),
				'type'  => 'meta',
				'slug'  => 'give-forms',
				'title' => esc_html__( 'Donation List', 'roisin-core' )
			)
		);
		
		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_donation_list_image',
					'title'       => esc_html__( 'Donation List Image', 'roisin-core' ),
					'description' => esc_html__( 'Upload image to be displayed on donation list instead of featured image', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_masonry_image_dimension_give_forms',
					'title'       => esc_html__( 'Image Dimension', 'roisin-core' ),
					'description' => esc_html__( 'Choose dimension of image for donation list. If you are using fixed image proportions on list, choose option different than default.', 'roisin-core' ),
					'options'     => roisin_core_get_select_type_options_pool( 'masonry_image_dimension' )
				)
			);
			
			// Hook to include additional options after module options
			do_action( 'roisin_core_action_after_donation_single_meta_box_map', $page );
		}
	}
	
	add_action( 'roisin_core_action_default_meta_boxes_init', 'roisin_core_add_donation_single_meta_box' );
}