<?php

if ( ! function_exists( 'roisin_core_add_minimal_header_meta' ) ) {
	function roisin_core_add_minimal_header_meta( $page ) {
		
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_minimal_header_section',
				'title'      => esc_html__( 'Minimal Header', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values' => 'minimal',
							'default_value' => ''
						)
					)
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_minimal_header_in_grid',
				'title'       => esc_html__( 'Content in Grid', 'roisin-core' ),
				'description' => esc_html__( 'Set content to be in grid', 'roisin-core' ),
				'default_value' => '',
				'options'       => roisin_core_get_select_type_options_pool( 'no_yes' )
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_height',
				'title'       => esc_html__( 'Header Height', 'roisin-core' ),
				'description' => esc_html__( 'Enter header height', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'roisin-core' )
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'roisin-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'roisin-core' )
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'roisin-core' ),
				'description' => esc_html__( 'Enter header background color', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'roisin-core' )
				)
			)
		);

	}
	
	add_action( 'roisin_core_action_after_page_header_meta_map', 'roisin_core_add_minimal_header_meta' );
}