<?php

if ( ! function_exists( 'roisin_core_add_standard_header_meta' ) ) {
	function roisin_core_add_standard_header_meta( $page ) {
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_standard_header_section',
				'title'      => esc_html__( 'Standard Header', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values' => 'standard',
							'default_value' => ''
						)
					)
				)
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_in_grid',
				'title'       => esc_html__( 'Content in Grid', 'roisin-core' ),
				'description' => esc_html__( 'Set content to be in grid', 'roisin-core' ),
				'default_value' => '',
				'options'       => roisin_core_get_select_type_options_pool( 'no_yes' )
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'roisin-core' ),
				'description' => esc_html__( 'Enter header height', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'roisin-core' )
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'roisin-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'roisin-core' )
				)
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'roisin-core' ),
				'description' => esc_html__( 'Enter header background color', 'roisin-core' )
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'roisin-core' ),
				'default_value' => 'right',
				'options'       => array(
					''       => esc_html__( 'Default', 'roisin-core' ),
					'left'   => esc_html__( 'Left', 'roisin-core' ),
					'center' => esc_html__( 'Center', 'roisin-core' ),
					'right'  => esc_html__( 'Right', 'roisin-core' ),
				)
			)
		);

	}
	
	add_action( 'roisin_core_action_after_page_header_meta_map', 'roisin_core_add_standard_header_meta' );
}