<?php

if ( ! function_exists( 'roisin_core_add_top_area_options' ) ) {
	function roisin_core_add_top_area_options( $page ) {

		$top_area_section = $page->add_section_element(
			array(
				'name'        => 'qodef_top_area_section',
				'title'       => esc_html__( 'Top Area', 'roisin-core' ),
				'description' => esc_html__( 'Options related to top area', 'roisin-core' ),
				'dependency' => array(
					'hide' => array(
						'qodef_header_layout' => array(
							'values' => roisin_core_dependency_for_top_area_options(),
							'default_value' => ''
						)
					)
				)
			)
		);

			$top_area_section->add_field_element(
				array(
					'field_type'  => 'yesno',
					'default_value' => 'no',
					'name'        => 'qodef_top_area_header',
					'title'       => esc_html__( 'Top Area', 'roisin-core' ),
					'description' => esc_html__( 'Enable top area', 'roisin-core' )
				)
			);

			$top_area_options_section = $top_area_section->add_section_element(
				array(
					'name'        => 'qodef_top_area_options_section',
					'title'       => esc_html__( 'Top Area Options', 'roisin-core' ),
					'description' => esc_html__( 'Set desired values for top area', 'roisin-core' ),
					'dependency'  => array(
						'show' => array(
							'qodef_top_area_header' => array(
								'values' => 'yes',
								'default_value' => 'no'
							)
						)
					)
				)
			);

				$top_area_options_section->add_field_element(
					array(
						'field_type'  => 'color',
						'name'        => 'qodef_top_area_header_background_color',
						'title'       => esc_html__( 'Top Area Background Color', 'roisin-core' ),
						'description' => esc_html__( 'Choose top area background color', 'roisin-core' )
					)
				);
		
				$top_area_options_section->add_field_element(
					array(
						'field_type'  => 'image',
						'name'        => 'qodef_top_area_header_background_image',
						'title'       => esc_html__( 'Top Area Background Image', 'roisin-core' ),
						'description' => esc_html__( 'Choose top area background image', 'roisin-core' )
					)
				);

				$top_area_options_section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_top_area_header_height',
						'title'       => esc_html__( 'Top Area Height', 'roisin-core' ),
						'description' => esc_html__( 'Enter top area height (default is 30px)', 'roisin-core' ),
						'args'        => array(
							'suffix'    => esc_html__( 'px', 'roisin-core' )
						)
					)
				);

				$top_area_options_section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_top_area_header_side_padding',
						'title'       => esc_html__( 'Top Area Side Padding', 'roisin-core' ),
						'args'        => array(
							'suffix'    => esc_html__( 'px or %', 'roisin-core' )
						)
					)
				);
	}
	
	add_action( 'roisin_core_action_after_header_options_map', 'roisin_core_add_top_area_options');
}