<?php

if ( ! function_exists( 'roisin_core_add_portfolio_list_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function roisin_core_add_portfolio_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'RoisinCorePortfolioListShortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'roisin_core_filter_register_shortcodes', 'roisin_core_add_portfolio_list_shortcode' );
}

if ( class_exists( 'RoisinCoreListShortcode' ) ) {
	class RoisinCorePortfolioListShortcode extends RoisinCoreListShortcode {
		
		public function __construct() {
			$this->set_post_type( 'portfolio-item' );
			$this->set_post_type_taxonomy( 'portfolio-category' );
			$this->set_post_type_additional_taxonomies( array( 'portfolio-tag' ) );
			$this->set_layouts( apply_filters( 'roisin_core_filter_portfolio_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'roisin_core_filter_portfolio_list_extra_options', array() ) );
			$this->set_hover_animation_options( apply_filters( 'roisin_core_filter_portfolio_list_hover_animation_options', array() ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( ROISIN_CORE_CPT_URL_PATH . '/portfolio/shortcodes/portfolio-list' );
			$this->set_base( 'roisin_core_portfolio_list' );
			$this->set_name( esc_html__( 'Portfolio List', 'roisin-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of portfolios', 'roisin-core' ) );
			$this->set_category( esc_html__( 'Roisin Core', 'roisin-core' ) );
			$this->set_scripts(
				apply_filters('roisin_core_filter_portfolio_list_register_assets', array())
			);
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'roisin-core' )
			) );
			$this->map_list_options();
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options( array(
				'layouts'          => $this->get_layouts(),
				'hover_animations' => $this->get_hover_animation_options()
			) );
			if ( empty( $exclude_option ) || ( ! empty( $exclude_option ) && ! in_array( 'custom_padding', $exclude_option ) ) ) {
				$this->set_option( array(
					'field_type'    => 'select',
					'name'          => 'custom_padding',
					'title'         => esc_html__( 'Use Item Custom Padding', 'roisin-core' ),
					'group'         => esc_html__( 'Layout', 'roisin-core' ),
					'default_value' => 'no',
					'options'       => roisin_core_get_select_type_options_pool( 'no_yes', false ),
				) );
			}
			$this->set_option( array(
				                   'field_type'    => 'select',
				                   'name'          => 'slider_height',
				                   'title'         => esc_html__( 'Full Height Slider (decreased for header, title and footer height)', 'roisin-core' ),
				                   'group'         => esc_html__( 'Layout', 'roisin-core' ),
				                   'default_value' => 'no',
				                   'options'       => roisin_core_get_select_type_options_pool( 'no_yes', false ),
				                   'dependency' => array(
					                   'show' => array(
						                   'behavior' => array(
							                   'values'        => 'slider',
							                   'default_value' => 'columns'
						                   )
					                   )
				                   ),
			                   ) );
			$this->map_additional_options();
			$this->map_extra_options();
		}
		
		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'roisin_core_portfolio_list', $params );
			$html = str_replace( "\n", '', $html );
			
			return $html;
		}
		
		public function load_assets() {
			parent::load_assets();
			
			do_action( 'roisin_core_action_portfolio_list_load_assets', $this->get_atts() );
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			
			$atts = $this->get_atts();
			
			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );
			
			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );
			
			$atts['query_result']   = new \WP_Query( roisin_core_get_query_params( $atts ) );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['data_attr']      = roisin_core_get_pagination_data( ROISIN_CORE_REL_PATH, 'post-types/portfolio/shortcodes', 'portfolio-list', 'portfolio', $atts );
			
			$atts['this_shortcode'] = $this;
			
			return roisin_core_get_template_part( 'post-types/portfolio/shortcodes/portfolio-list', 'templates/content', $atts['behavior'], $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-portfolio-list';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';
			
			$holder_classes[] = ( $atts['slider_height'] === 'yes' ) ? 'qodef-portfolio-slider-with-height' : '';
			if ( isset( $atts['slider_width'] ) && $atts['slider_width'] === 'yes') {
				$holder_classes[] = 'qodef-auto-width-slider';
			}
			$list_classes            = $this->get_list_classes( $atts );
			$hover_animation_classes = $this->get_hover_animation_classes( $atts );
			$holder_classes          = array_merge( $holder_classes, $list_classes, $hover_animation_classes );
			
			return implode( ' ', $holder_classes );
		}
		
		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();
			
			$list_item_classes = $this->get_list_item_classes( $atts );
			
			$item_classes = array_merge( $item_classes, $list_item_classes );
			
			$simple_list_item = get_post_meta( get_the_ID(), "qodef_simple_portfolio_item", true );
			
			if($simple_list_item === 'yes') {
				$item_classes[] = 'qodef-simple-portfolio-list-item';
			}
			
			return implode( ' ', $item_classes );
		}
		
		public function get_title_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}
			
			return $styles;
		}
		
		public function get_list_item_style( $atts ) {
			$styles = array();
			
			if ( isset( $atts['custom_padding'] ) && $atts['custom_padding'] == 'yes' ) {
				$styles[] = 'padding: ' . get_post_meta( get_the_ID(), "qodef_portfolio_item_padding", true );
			}
			
			return $styles;
		}
		
		public function get_item_layout( $atts ) {
			$layout = $atts['layout'];
			$simple_item = get_post_meta( get_the_ID(), 'qodef_simple_portfolio_item', true );
			
			if ( $simple_item === 'yes' &&  ($atts['behavior'] === 'columns' || $atts['behavior'] === 'masonry') && $atts['layout'] === 'info-on-hover') {
				$layout = 'simple-item';
			}
			
			return $layout;
		}
	}
}