<?php

if ( ! function_exists( 'roisin_core_add_simple_item_meta_boxes' ) ) {
	/**
	 * Function that adds portfolio list settings for portfolio single module
	 */
	function roisin_core_add_simple_item_meta_boxes( $page ) {
		
		if ( $page ) {
			
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_simple_portfolio_item',
					'title'         => esc_html__( 'Simple Portfolio Item', 'roisin-core' ),
					'description'   => esc_html__( 'Show this item as simple in portfolio list shortcode. Only for Gallery with Info on Hover type', 'roisin-core' ),
					'default_value' => 'no'
				)
			);
			
			$section = $page->add_section_element(
				array(
					'name'       => 'qodef_simple_portfolio_item_section',
					'dependency' => array(
						'show' => array(
							'qodef_simple_portfolio_item' => array(
								'values'        => 'yes',
								'default_value' => 'no'
							)
						)
					)
				)
			);
			
			$section->add_field_element( array(
				                             'field_type'  => 'image',
				                             'name'        => 'qodef_simple_portfolio_item_background',
				                             'title'       => esc_html__( 'Simple Item Background Image', 'roisin-core' ),
				                             'description' => esc_html__( 'Set background image for simple item on portfolio list', 'roisin-core' )
			                             )
			);
			
			$section->add_field_element( array(
				                             'field_type'  => 'image',
				                             'name'        => 'qodef_simple_portfolio_item_small_image',
				                             'title'       => esc_html__( 'Simple Item Small Image', 'roisin-core' ),
				                             'description' => esc_html__( 'Small image to apper for this item on portfolio list', 'roisin-core' )
			                             )
			);
			
			$section->add_field_element( array(
				                             'field_type'  => 'text',
				                             'name'        => 'qodef_simple_portfolio_item_title',
				                             'title'       => esc_html__( 'Simple Item List Title', 'roisin-core' ),
				                             'description' => esc_html__( 'Title text to appear for this item on portfolio list', 'roisin-core' )
			                             )
			);
			$section->add_field_element( array(
				                             'field_type'  => 'text',
				                             'name'        => 'qodef_simple_portfolio_item_subtitle',
				                             'title'       => esc_html__( 'Simple Item List Subtitle', 'roisin-core' ),
				                             'description' => esc_html__( 'Subtitle text to appear for this item on portfolio list', 'roisin-core' )
			                             )
			);
			$section->add_field_element( array(
				                             'field_type'  => 'text',
				                             'name'        => 'qodef_simple_portfolio_item_link',
				                             'title'       => esc_html__( 'Simple Item List Link', 'roisin-core' ),
				                             'description' => esc_html__( 'Set link for button in this item on portfolio list', 'roisin-core' )
			                             )
			);
			$section->add_field_element( array(
				                             'field_type'  => 'text',
				                             'name'        => 'qodef_simple_portfolio_item_link_text',
				                             'title'       => esc_html__( 'Simple Item List Link Text', 'roisin-core' ),
				                             'description' => esc_html__( 'Link text for button to appear for this item on portfolio list', 'roisin-core' )
			                             )
			);
		}
	}
	
	add_action( 'roisin_core_action_after_portfolio_list_meta_box_map', 'roisin_core_add_simple_item_meta_boxes' );
}