<article <?php post_class( $item_classes ); ?>>
	<div class="qodef-e-inner" <?php qode_framework_inline_style( $this_shortcode->get_list_item_style( $params ) ) ?>>
		<?php
		$simple_background = get_post_meta(get_the_ID(), 'qodef_simple_portfolio_item_background', true);
		$small_image = get_post_meta(get_the_ID(), 'qodef_simple_portfolio_item_small_image', true);
		$simple_title = get_post_meta( get_the_ID(), 'qodef_simple_portfolio_item_title', true );
		$simple_subtitle = get_post_meta( get_the_ID(), 'qodef_simple_portfolio_item_subtitle', true );
		$simple_link = get_post_meta( get_the_ID(), 'qodef_simple_portfolio_item_link', true );
		$simple_link_text = get_post_meta( get_the_ID(), 'qodef_simple_portfolio_item_link_text', true );
		$button_params = array(
			'link' => $simple_link,
			'text' => $simple_link_text,
			'background_color' => 'rgb(216, 227, 213)',
			'hover_background_color' => '#d0dfcf'
		);
		$image_dimension     = isset( $image_dimension ) && ! empty( $image_dimension ) ? esc_attr( $image_dimension['size'] ) : 'full';
		$custom_image_width  = isset( $custom_image_width ) && $custom_image_width !== '' ? intval( $custom_image_width ) : 0;
		$custom_image_height = isset( $custom_image_height ) && $custom_image_height !== '' ? intval( $custom_image_height ) : 0;
		?>
		<div class="qodef-e-image">
			<div class="qodef-e-media-image">
				<?php echo roisin_core_get_list_shortcode_item_image( $image_dimension, $simple_background, $custom_image_width, $custom_image_height ); ?>
			</div>
		</div>
		<div class="qodef-e-content">
			<div class="qodef-e-content-inner">
				<?php if(! empty ( $small_image )) { ?>
				<?php echo roisin_core_get_list_shortcode_item_image( $image_dimension, $small_image, $custom_image_width, $custom_image_height ); ?>
				<?php } ?>
				<h3 class="qodef-e-title entry-title">
					<?php echo esc_html($simple_title); ?>
				</h3>
				<p class="qodef-e-subtitle">
					<?php echo esc_html($simple_subtitle); ?>
				</p>
				<?php if (!empty($button_params)) { ?>
					<div class="qodef-e-button clear">
						<?php echo RoisinCoreButtonShortcode::call_shortcode( $button_params ); ?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</article>