<?php

if ( ! function_exists( 'roisin_core_add_portfolio_single_variation_masonry_big' ) ) {
	function roisin_core_add_portfolio_single_variation_masonry_big( $variations ) {
		$variations['masonry-big'] = esc_html__( 'Masonry - Big', 'roisin-core' );
		
		return $variations;
	}
	
	add_filter( 'roisin_core_filter_portfolio_single_layout_options', 'roisin_core_add_portfolio_single_variation_masonry_big' );
}

if ( ! function_exists( 'roisin_core_include_masonry_for_portfolio_single_variation_masonry_big' ) ) {
	function roisin_core_include_masonry_for_portfolio_single_variation_masonry_big( $post_type ) {
		$portfolio_template = roisin_core_get_post_value_through_levels( 'qodef_portfolio_single_layout' );
		
		if ( $portfolio_template === 'masonry-big' ) {
			$post_type = 'portfolio-item';
		}
		
		return $post_type;
	}
	
	add_filter( 'roisin_filter_allowed_post_type_to_enqueue_masonry_scripts', 'roisin_core_include_masonry_for_portfolio_single_variation_masonry_big' );
}