<?php

if ( ! function_exists( 'roisin_core_add_button_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_button_widget( $widgets ) {
		$widgets[] = 'RoisinCoreButtonWidget';

		return $widgets;
	}

	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_button_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreButtonWidget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options( array(
				'shortcode_base' => 'roisin_core_button'
			) );
			if ( $widget_mapped ) {
				$this->set_base( 'roisin_core_button' );
				$this->set_name( esc_html__( 'Roisin Button', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Add a button element into widget areas', 'roisin-core' ) );
			}
		}

		public function render( $atts ) {
			$params = $this->generate_string_params( $atts );

			echo do_shortcode( "[roisin_core_button $params]" ); // XSS OK
		}
	}
}

if ( ! function_exists( 'roisin_core_add_button_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function roisin_core_add_button_shortcode( $shortcodes ) {
		$shortcodes[] = 'RoisinCoreButtonShortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'roisin_core_filter_register_shortcodes', 'roisin_core_add_button_shortcode', 9 );
}

if ( class_exists( 'RoisinCoreShortcode' ) ) {
	class RoisinCoreButtonShortcode extends RoisinCoreShortcode {
		
		public function __construct() {
			$this->set_layouts( apply_filters( 'roisin_core_filter_button_layouts', array() ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( ROISIN_CORE_SHORTCODES_URL_PATH . '/button' );
			$this->set_base( 'roisin_core_button' );
			$this->set_name( esc_html__( 'Button', 'roisin-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays button with provided parameters', 'roisin-core' ) );
			$this->set_category( esc_html__( 'Roisin Core', 'roisin-core' ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'roisin-core' )
			) );
			
			$options_map = roisin_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'button_layout',
				'title'         => esc_html__( 'Layout', 'roisin-core' ),
				'options'       => $this->get_layouts(),
				'default_value' => $options_map['default_value'],
				'visibility'    => array(
					'map_for_page_builder' => $options_map['visibility'],
					'map_for_widget' => $options_map['visibility']
				)
			) );
			$this->set_option( array(
				'field_type' => 'select',
				'name'       => 'size',
				'title'      => esc_html__( 'Size', 'roisin-core' ),
				'options'    => array(
					''      => esc_html__( 'Normal', 'roisin-core' ),
					'small' => esc_html__( 'Small', 'roisin-core' ),
					'large' => esc_html__( 'Large', 'roisin-core' )
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'text',
				'title'      => esc_html__( 'Button Text', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'link',
				'title'      => esc_html__( 'Button Link', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'target',
				'title'         => esc_html__( 'Target', 'roisin-core' ),
				'options'       => roisin_core_get_select_type_options_pool( 'link_target' ),
				'default_value' => '_self'
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'color',
				'title'      => esc_html__( 'Text Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'name'       => 'hover_color',
				'field_type' => 'color',
				'title'      => esc_html__( 'Text Hover Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'background_color',
				'title'      => esc_html__( 'Background Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'hover_background_color',
				'title'      => esc_html__( 'Background Hover Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'border_color',
				'title'      => esc_html__( 'Border Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'hover_border_color',
				'title'      => esc_html__( 'Border Hover Color', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'margin',
				'title'      => esc_html__( 'Margin', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'padding',
				'title'      => esc_html__( 'Padding', 'roisin-core' ),
				'group'      => esc_html__( 'Style', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'font_size',
				'title'      => esc_html__( 'Font Size', 'roisin-core' ),
				'group'      => esc_html__( 'Typography', 'roisin-core' )
			) );
			$this->set_option( array(
				                   'field_type' => 'text',
				                   'name'       => 'line_height',
				                   'title'      => esc_html__( 'Line Height', 'roisin-core' ),
				                   'group'      => esc_html__( 'Typography', 'roisin-core' )
			                   ) );
			$this->set_option( array(
				'field_type' => 'select',
				'name'       => 'font_weight',
				'title'      => esc_html__( 'Font Weight', 'roisin-core' ),
				'options'    => roisin_core_get_select_type_options_pool( 'font_weight' ),
				'group'      => esc_html__( 'Typography', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'select',
				'name'       => 'text_transform',
				'title'      => esc_html__( 'Text Transform', 'roisin-core' ),
				'options'    => roisin_core_get_select_type_options_pool( 'text_transform' ),
				'group'      => esc_html__( 'Typography', 'roisin-core' )
			) );
			$this->set_option( array(
				                   'field_type' => 'select',
				                   'name'       => 'font_style',
				                   'title'      => esc_html__( 'Font Style', 'roisin-core' ),
				                   'options'    => roisin_core_get_select_type_options_pool( 'font_style' ),
				                   'group'      => esc_html__( 'Typography', 'roisin-core' )
			                   ) );
			
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'html_type',
				'title'         => esc_html__( 'HTML Type', 'roisin-core' ),
				'options'       => array(
					'default' => esc_html__( 'Default', 'roisin-core' ),
					'input'   => esc_html__( 'Input', 'roisin-core' ),
					'submit'  => esc_html__( 'Submit', 'roisin-core' )
				),
				'default_value' => 'default',
				'visibility'    => array(
					'map_for_page_builder'    => false
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'input_name',
				'title'      => esc_html__( 'Input Name', 'roisin-core' ),
				'visibility'    => array(
					'map_for_page_builder'    => false
				)
			) );
			$this->set_option( array(
				'field_type' => 'array',
				'name'       => 'custom_attrs',
				'title'      => esc_html__( 'Custom Data Attributes', 'roisin-core' ),
				'visibility'    => array(
					'map_for_page_builder'    => false
				)
			) );
		}
		
		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'roisin_core_button', $params );
			$html = str_replace( "\n", '', $html );
			
			return $html;
		}
		
		public function render( $options, $content = null ) {
			
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['data_attrs']     = $this->get_data_attrs( $atts );
			$atts['styles']         = $this->get_styles( $atts );

			return roisin_core_get_template_part( 'shortcodes/button', 'variations/'.$atts['button_layout'].'/templates/' . $atts['html_type'], '', $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-button';
			$holder_classes[] = ! empty( $atts['button_layout'] ) ? 'qodef-layout--' . $atts['button_layout'] : '';
			$holder_classes[] = ! empty( $atts['size'] ) ? 'qodef-size--' . $atts['size'] : '';
			$holder_classes[] = $atts['html_type'] === 'default' ? 'qodef-html--link' : '';
			
			return implode( ' ', $holder_classes );
		}
		
		private function get_data_attrs( $atts ) {
			$data = array();
			
			if ( ! empty( $atts['hover_color'] ) ) {
				$data['data-hover-color'] = $atts['hover_color'];
			}
			
			if ( ! empty( $atts['hover_background_color'] ) ) {
				$data['data-hover-background-color'] = $atts['hover_background_color'];
			}
			
			if ( ! empty( $atts['hover_border_color'] ) ) {
				$data['data-hover-border-color'] = $atts['hover_border_color'];
			}
			
			if ( ! empty( $atts['custom_attrs'] ) && is_array( $atts['custom_attrs'] ) ) {
				$data = array_merge( $data, $atts['custom_attrs'] );
			}
			
			return $data;
		}
		
		private function get_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['color'] ) ) {
				$styles[] = 'color: ' . $atts['color'];
			}
			
			if ( ! empty( $atts['background_color'] ) && $atts['button_layout'] !== 'outlined' && $atts['button_layout'] !== 'textual' ) {
				$styles[] = 'background-color: ' . $atts['background_color'];
			}
			
			if ( ! empty( $atts['border_color'] ) && $atts['button_layout'] !== 'textual' ) {
				$styles[] = 'border-color: ' . $atts['border_color'];
			}
			
			if ( ! empty( $atts['font_size'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['font_size'] ) ) {
					$styles[] = 'font-size: ' . $atts['font_size'];
				} else {
					$styles[] = 'font-size: ' . intval( $atts['font_size'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['line_height'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['line_height'] ) ) {
					$styles[] = 'line-height: ' . $atts['line_height'];
				} else {
					$styles[] = 'line-height: ' . intval( $atts['line_height'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['font_weight'] ) ) {
				$styles[] = 'font-weight: ' . $atts['font_weight'];
			}
			
			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}
			
			if ( ! empty( $atts['font_style'] ) ) {
				$styles[] = 'font-style: ' . $atts['font_style'];
			}
			
			if ( $atts['margin'] !== '' ) {
				$styles[] = 'margin: ' . $atts['margin'];
			}
			
			if ( $atts['padding'] !== '' ) {
				$styles[] = 'padding: ' . $atts['padding'];
			}
			
			return $styles;
		}
	}
}