<?php

if ( ! function_exists( 'roisin_core_add_image_with_text_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function roisin_core_add_image_with_text_shortcode( $shortcodes ) {
		$shortcodes[] = 'RoisinCoreImageWithTextShortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'roisin_core_filter_register_shortcodes', 'roisin_core_add_image_with_text_shortcode' );
}

if ( class_exists( 'RoisinCoreShortcode' ) ) {
	class RoisinCoreImageWithTextShortcode extends RoisinCoreShortcode {
		
		public function __construct() {
			$this->set_layouts( apply_filters( 'roisin_core_filter_image_with_text_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'roisin_core_filter_image_with_text_extra_options', array() ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( ROISIN_CORE_SHORTCODES_URL_PATH . '/image-with-text' );
			$this->set_base( 'roisin_core_image_with_text' );
			$this->set_name( esc_html__( 'Image With Text', 'roisin-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds image with text element', 'roisin-core' ) );
			$this->set_category( esc_html__( 'Roisin Core', 'roisin-core' ) );
			$this->set_scripts(
				array(
					'parallax-scroll' => array(
						'registered'	=> false,
						'url'			=> ROISIN_CORE_INC_URL_PATH . '/shortcodes/image-with-text/assets/js/plugins/jquery.parallax-scroll.js',
						'dependency'	=> array( 'jquery' )
					)
				)
			);
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'roisin-core' ),
			) );
			
			$options_map = roisin_core_get_variations_options_map( $this->get_layouts() );
			
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'layout',
				'title'         => esc_html__( 'Layout', 'roisin-core' ),
				'options'		=> $this->get_layouts(),
				'default_value' => $options_map['default_value'],
				'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] )
			) );
			$this->set_option( array(
				'field_type' => 'image',
				'name'       => 'image',
				'title'      => esc_html__( 'Image', 'roisin-core' ),
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'image_size',
				'title'      => esc_html__( 'Image Size', 'roisin-core' ),
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'image_action',
				'title'         => esc_html__( 'Image Action', 'roisin-core' ),
				'options'       => array(
					''            => esc_html__( 'No Action', 'roisin-core' ),
					'open-popup'  => esc_html__( 'Open Popup', 'roisin-core' ),
					'custom-link' => esc_html__( 'Custom Link', 'roisin-core' )
				)
			) );
			$this->set_option( array(
				'field_type' => 'image',
				'name'       => 'over_image',
				'title'      => esc_html__( 'Image Over', 'roisin-core' ),
			) );
			$this->set_option( array(
				'field_type' => 'select',
				'name'       => 'over_image_position',
				'title'      => esc_html__( 'Image Over Position', 'roisin-core' ),
				'options'    => array(
					'bottom-left' => esc_html__( 'Bottom Left', 'roisin-core'),
					'bottom-right' => esc_html__( 'Bottom Right', 'roisin-core'),
				),
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'position_bottom',
				'title'      => esc_html__( 'Bottom Position', 'roisin-core' ),
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'position_right',
				'title'      => esc_html__( 'Right Position', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'over_image_position' => array(
							'values'        => 'bottom-right',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'position_left',
				'title'      => esc_html__( 'Left Position', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'over_image_position' => array(
							'values'        => 'bottom-left',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'link',
				'title'      => esc_html__( 'Custom Link', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'image_action' => array(
							'values'        => 'custom-link',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'target',
				'title'         => esc_html__( 'Custom Link Target', 'roisin-core' ),
				'options'       => roisin_core_get_select_type_options_pool( 'link_target' ),
				'default_value' => '_self',
				'dependency' => array(
					'show' => array(
						'image_action' => array(
							'values'        => 'custom-link',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title',
				'title'      => esc_html__( 'Title', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'title_tag',
				'title'         => esc_html__( 'Title Tag', 'roisin-core' ),
				'options'       => roisin_core_get_select_type_options_pool( 'title_tag' ),
				'default_value' => 'h5',
				'group'         => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'title_color',
				'title'      => esc_html__( 'Title Color', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title_margin_top',
				'title'      => esc_html__( 'Title Margin Top', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'textarea',
				'name'       => 'text',
				'title'      => esc_html__( 'Text', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'text_color',
				'title'      => esc_html__( 'Text Color', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'text_margin_top',
				'title'      => esc_html__( 'Text Margin Top', 'roisin-core' ),
				'group'      => esc_html__( 'Content', 'roisin-core' )
			) );
			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'parallax-scroll');
		}
		
		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'roisin_core_image_with_text', $params );
			$html = str_replace( "\n", '', $html );
			
			return $html;
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
			
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['image_params']   = $this->generate_image_params( $atts );
			$atts['image_over_styles'] = $this->generate_image_over_styles( $atts );

			return roisin_core_get_template_part( 'shortcodes/image-with-text', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-image-with-text';
			$holder_classes[] = ! empty ( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = !empty($atts['over_image_position']) ? 'qodef-image-over--'.$atts['over_image_position'] : '';
			
			return implode( ' ', $holder_classes );
		}
		
		private function get_title_styles( $atts ) {
			$styles = array();
			
			if ( $atts['title_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}
			
			return $styles;
		}
		
		private function get_text_styles( $atts ) {
			$styles = array();
			
			if ( $atts['text_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}
			
			return $styles;
		}
		
		private function generate_image_params( $atts ) {
			$image = array();
			
			if ( ! empty( $atts['image'] ) ) {
				$id = $atts['image'];

                if ( is_array( wp_get_attachment_image_src( $id ) ) ) {
                    $image['image_id'] = intval( $id );
                    $image_original    = wp_get_attachment_image_src( $id, 'full' );
                    $image['url']      = $image_original[0];
                    $image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );

                    $image_size = trim( $atts['image_size'] );
                    preg_match_all( '/\d+/', $image_size, $matches ); /* check if numeral width and height are entered */
                    if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ), true ) ) {
                        $image['image_size'] = $image_size;
                    } elseif ( ! empty( $matches[0] ) ) {
                        $image['image_size'] = array(
                            $matches[0][0],
                            $matches[0][1]
                        );
                    } else {
                        $image['image_size'] = 'full';
                    }
                }
			}
			
			return $image;
		}

		private function generate_image_over_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['position_bottom'] ) ) {
				$styles[] = 'bottom: ' . $atts['position_bottom'];
			}

			if ( ! empty( $atts['position_right'] ) ) {
				$styles[] = 'right: ' . $atts['position_right'];
			}

			if ( ! empty( $atts['position_left'] ) ) {
				$styles[] = 'left: ' . $atts['position_left'];
			}

			return $styles;
		}
	}
}