<?php

if ( ! function_exists( 'roisin_core_load_spinners' ) ) {
	/**
	 * Loads Spinners HTML
	 */
	function roisin_core_load_spinners() {
		$id = qode_framework_get_page_id();

		if ( roisin_core_get_post_value_through_levels( 'qodef_page_enable_loader', $id ) === 'yes' ) { ?>
            <div class="qodef-smooth-transition-loader">
                <div class="qodef-st-loader">
                    <div class="qodef-st-loader-inner">
						<?php roisin_core_loading_spinners(); ?>
                    </div>
                </div>
            </div>
		<?php }
	}

	function roisin_core_loading_spinners() {
		$id           = qode_framework_get_page_id();
		$spinner_type = roisin_core_get_post_value_through_levels( 'qodef_page_spinners', $id );

		$spinner_html = '';
		if ( ! empty( $spinner_type ) ) {
			switch ( $spinner_type ) {
				case 'roisin_spinner':
					$spinner_html = roisin_core_loading_spinner_roisin_spinner();
					break;
				case 'rotate_circles':
					$spinner_html = roisin_core_loading_spinner_rotate_circles();
					break;
				case 'pulse':
					$spinner_html = roisin_core_loading_spinner_pulse();
					break;
				case 'double_pulse':
					$spinner_html = roisin_core_loading_spinner_double_pulse();
					break;
				case 'cube':
					$spinner_html = roisin_core_loading_spinner_cube();
					break;
				case 'rotating_cubes':
					$spinner_html = roisin_core_loading_spinner_rotating_cubes();
					break;
				case 'stripes':
					$spinner_html = roisin_core_loading_spinner_stripes();
					break;
				case 'wave':
					$spinner_html = roisin_core_loading_spinner_wave();
					break;
				case 'two_rotating_circles':
					$spinner_html = roisin_core_loading_spinner_two_rotating_circles();
					break;
				case 'five_rotating_circles':
					$spinner_html = roisin_core_loading_spinner_five_rotating_circles();
					break;
				case 'atom':
					$spinner_html = roisin_core_loading_spinner_atom();
					break;
				case 'clock':
					$spinner_html = roisin_core_loading_spinner_clock();
					break;
				case 'mitosis':
					$spinner_html = roisin_core_loading_spinner_mitosis();
					break;
				case 'lines':
					$spinner_html = roisin_core_loading_spinner_lines();
					break;
				case 'fussion':
					$spinner_html = roisin_core_loading_spinner_fussion();
					break;
				case 'wave_circles':
					$spinner_html = roisin_core_loading_spinner_wave_circles();
					break;
				case 'pulse_circles':
					$spinner_html = roisin_core_loading_spinner_pulse_circles();
					break;
				default:
					$spinner_html = roisin_core_loading_spinner_pulse();
			}
		}

		echo roisin_get_module_part($spinner_html);
	}

	function roisin_core_loading_spinner_roisin_spinner() {
		
		$id = qode_framework_get_page_id();
		$spinner_svg = roisin_core_get_post_value_through_levels( 'qodef_roisin_spinner_svg', $id );

		$html = '';
		$html .= '<div class="qodef-roisin-spinner-holder">';
		$html .= $spinner_svg;
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_rotate_circles() {
		$html = '';
		$html .= '<div class="qodef-rotate-circles">';
		$html .= '<div></div>';
		$html .= '<div></div>';
		$html .= '<div></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_pulse() {
		$html = '<div class="pulse"></div>';

		return $html;
	}

	function roisin_core_loading_spinner_double_pulse() {
		$html = '';
		$html .= '<div class="double_pulse">';
		$html .= '<div class="double-bounce1"></div>';
		$html .= '<div class="double-bounce2"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_cube() {
		$html = '<div class="cube"></div>';

		return $html;
	}

	function roisin_core_loading_spinner_rotating_cubes() {
		$html = '';
		$html .= '<div class="rotating_cubes">';
		$html .= '<div class="cube1"></div>';
		$html .= '<div class="cube2"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_stripes() {
		$html = '';
		$html .= '<div class="stripes">';
		$html .= '<div class="rect1"></div>';
		$html .= '<div class="rect2"></div>';
		$html .= '<div class="rect3"></div>';
		$html .= '<div class="rect4"></div>';
		$html .= '<div class="rect5"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_wave() {
		$html = '';
		$html .= '<div class="wave">';
		$html .= '<div class="bounce1"></div>';
		$html .= '<div class="bounce2"></div>';
		$html .= '<div class="bounce3"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_two_rotating_circles() {
		$html = '';
		$html .= '<div class="two_rotating_circles">';
		$html .= '<div class="dot1"></div>';
		$html .= '<div class="dot2"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_five_rotating_circles() {
		$html = '';
		$html .= '<div class="five_rotating_circles">';
		$html .= '<div class="spinner-container container1">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '<div class="spinner-container container2">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '<div class="spinner-container container3">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_atom() {
		$html = '';
		$html .= '<div class="atom">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_clock() {
		$html = '';
		$html .= '<div class="clock">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_mitosis() {
		$html = '';
		$html .= '<div class="mitosis">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_lines() {
		$html = '';
		$html .= '<div class="lines">';
		$html .= '<div class="line1"></div>';
		$html .= '<div class="line2"></div>';
		$html .= '<div class="line3"></div>';
		$html .= '<div class="line4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_fussion() {
		$html = '';
		$html .= '<div class="fussion">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_wave_circles() {
		$html = '';
		$html .= '<div class="wave_circles">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	function roisin_core_loading_spinner_pulse_circles() {
		$html = '';
		$html .= '<div class="pulse_circles">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';

		return $html;
	}

	add_action( 'roisin_action_before_wrapper_close_tag', 'roisin_core_load_spinners' );
}

if ( ! function_exists( 'roisin_core_set_spinners_styles' ) ) {
	/**
	 * Function that generates spinners inline styles
	 *
	 * @param $style string
	 *
	 * @return string
	 */
	function roisin_core_set_spinners_styles( $style ) {
		$spinner_styles = array();

		$spinner_background_color = roisin_core_get_post_value_through_levels( 'qodef_page_spinner_background_color' );
		$spinner_color            = roisin_core_get_post_value_through_levels( 'qodef_page_spinner_color' );

		if ( ! empty( $spinner_background_color ) ) {
			$spinner_styles['background-color'] = $spinner_background_color;
		}

		if ( ! empty( $spinner_color ) ) {
			$spinner_styles['color'] = $spinner_color;
		}

		if ( ! empty( $spinner_styles ) ) {
			$style .= qode_framework_dynamic_style( '.qodef-smooth-transition-loader .qodef-st-loader .qodef-st-loader-inner', $spinner_styles );
		}

		return $style;
	}

	add_filter( 'roisin_filter_add_inline_style', 'roisin_core_set_spinners_styles' );
}