<?php

if ( ! defined( 'ABSPATH' ) ) {
    // Exit if accessed directly.
    exit;
}

if ( ! class_exists( 'RoisinCore_WooCommerce_Qode_Wishlist_For_WooCommerce' ) ) {
    class RoisinCore_WooCommerce_Qode_Wishlist_For_WooCommerce {
        private static $instance;
        public function __construct() {

            // Init, permission 20 is set in order to be after the plugin initialization.
            add_action( 'after_setup_theme', array( $this, 'init' ), 4 );
        }

        /**
         * @return RoisinCore_WooCommerce_Qode_Wishlist_For_WooCommerce
         */
        public static function get_instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        public function init() {

            if ( qode_framework_is_installed( 'qode-wishlist-for-woocommerce' ) ) {
                add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_behavior_default_value', array( $this, 'set_default_add_to_wishlist_behavior' ) );
                add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_button_loop_position', array( $this, 'set_add_to_wishlist_button_loop_position' ), 10, 3 );
                add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_wrapper_classes', array( $this, 'set_add_to_wishlist_theme_class' ) );
                add_filter( 'qode_wishlist_for_woocommerce_filter_wishlist_table_holder_classes', array( $this, 'set_add_to_wishlist_theme_class' ) );
            }
        }

        public function set_default_add_to_wishlist_behavior() {
            return 'view';
        }

        public function set_add_to_wishlist_button_loop_position( $button_position_map, $button_position, $is_block_template ) {

            if ( 'after-add-to-cart' === $button_position && ! $is_block_template ) {
                $button_position_map[ $button_position ] = array(
                    'hook'     => array( $button_position_map[ $button_position ]['hook'], 'roisin_core_action_product_list_item_additional_content' ),
                    'priority' => array( $button_position_map[ $button_position ]['priority'], 39 ),
                );
            }

            return $button_position_map;
        }

        public function set_add_to_wishlist_theme_class( $classes ) {
            $classes[] = 'qodef-roisin-theme';

            return $classes;
        }
    }

    RoisinCore_WooCommerce_Qode_Wishlist_For_WooCommerce::get_instance();
}
