<?php

if ( ! function_exists( 'roisin_core_add_product_list_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function roisin_core_add_product_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'RoisinCoreProductListShortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'roisin_core_filter_register_shortcodes', 'roisin_core_add_product_list_shortcode' );
}

if ( class_exists( 'RoisinCoreListShortcode' ) ) {
	class RoisinCoreProductListShortcode extends RoisinCoreListShortcode {
		
		public function __construct() {
			$this->set_post_type( 'product' );
			$this->set_post_type_taxonomy( 'product_cat' );
			$this->set_post_type_additional_taxonomies( array( 'product_tag', 'product_type' ) );
			$this->set_layouts( apply_filters( 'roisin_core_filter_product_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'roisin_core_filter_product_list_extra_options', array() ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( ROISIN_CORE_INC_URL_PATH . '/woocommerce/shortcodes/product-list' );
			$this->set_base( 'roisin_core_product_list' );
			$this->set_name( esc_html__( 'Product List', 'roisin-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of products', 'roisin-core' ) );
			$this->set_category( esc_html__( 'Roisin Core', 'roisin-core' ) );
			$this->set_scripts(
				array(
					'parallax-scroll' => array(
						'registered'	=> false,
						'url'			=> ROISIN_CORE_INC_URL_PATH . '/woocommerce/shortcodes/product-list/variations/asynchron/assets/js/plugins/jquery.parallax-scroll.js',
						'dependency'	=> array( 'jquery' )
					)
				)
			);
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'roisin-core' )
			) );
			$this->map_list_options();
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'filterby',
				'title'         => esc_html__( 'Filter By', 'roisin-core' ),
				'options'       => array(
					''             => esc_html__( 'Default', 'roisin-core' ),
					'on_sale'      => esc_html__( 'On Sale', 'roisin-core' ),
					'featured'     => esc_html__( 'Featured', 'roisin-core' ),
					'top_rated'    => esc_html__( 'Top Rated', 'roisin-core' ),
					'best_selling' => esc_html__( 'Best Selling', 'roisin-core' )
				),
				'default_value' => '',
				'group'         => esc_html__( 'Query', 'roisin-core' ),
				'dependency'    => array(
					'show' => array(
						'additional_params' => array(
							'values'        => '',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'order_by',
				'title'         => esc_html__( 'Enable Ordering Filter', 'roisin-core' ),
				'options'    => roisin_core_get_select_type_options_pool( 'yes_no' ),
				'default_value' => '',
				'group'         => esc_html__( 'Additional', 'roisin-core' ),
			) );
			$this->set_option( array(
				'field_type'    => 'text',
				'name'          => 'price_range',
				'title'         => esc_html__( 'Price range for filter', 'roisin-core' ),
				'default_value' => '',
				'group'         => esc_html__( 'Additional', 'roisin-core' ),
			) );
			$this->map_layout_options( array( 'layouts' => $this->get_layouts() ) );
			$this->map_additional_options();
			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();
			wp_enqueue_script( 'parallax-scroll');
		}

		public static function call_shortcode( $args ) {
			$html = qode_framework_call_shortcode( 'roisin_core_product_list', $args );
			$html = str_replace( "\n", '', $html );
			
			return $html;
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			
			$atts = $this->get_atts();
			
			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );
			
			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );
			$atts['order_html'] = $this->getProductOrderingList( $atts );
			$atts['price_html'] = $this->getProductPricingList( $atts );

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['query_result']   = new \WP_Query( roisin_core_get_query_params( $atts ) );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['data_attr']      = roisin_core_get_pagination_data( ROISIN_CORE_REL_PATH, 'woocommerce/shortcodes', 'product-list', 'product', $atts );
			
			$atts['this_shortcode'] = $this;
			
			return roisin_core_get_template_part( 'woocommerce/shortcodes/product-list', 'templates/content', $atts['behavior'], $atts );
		}
		
		public function get_additional_query_args( $atts ) {
			$args = parent::get_additional_query_args( $atts );
			
			if ( ! empty( $atts['filterby'] ) ) {
				switch ( $atts['filterby'] ) {
					case 'on_sale':
						$args['no_found_rows'] = 1;
						$args['post__in']      = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
						break;
					case 'featured':
						$args['tax_query'] = WC()->query->get_tax_query();
						
						$args['tax_query'][] = array(
							'taxonomy'         => 'product_visibility',
							'terms'            => 'featured',
							'field'            => 'name',
							'operator'         => 'IN',
							'include_children' => false,
						);
						break;
					case 'top_rated':
						$args['meta_key'] = '_wc_average_rating';
						$args['order']    = 'DESC';
						$args['orderby']  = 'meta_value_num';
						break;
					case 'best_selling':
						$args['meta_key'] = 'total_sales';
						$args['order']    = 'DESC';
						$args['orderby']  = 'meta_value_num';
						break;
				}
			}
			
			return $args;
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-woo-shortcode';
			$holder_classes[] = 'qodef-woo-product-list';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';
			$holder_classes[] = $atts['order_by'] == 'yes' ? 'qodef--order-filter' : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );
			
			return implode( ' ', $holder_classes );
		}
		
		public function get_item_classes( $atts ) {
			$item_classes      = $this->init_item_classes();
			$list_item_classes = $this->get_list_item_classes( $atts );
			
			$item_classes = array_merge( $item_classes, $list_item_classes );
			
			return implode( ' ', $item_classes );
		}
		
		public function get_title_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}
			
			return $styles;
		}

		public function getProductOrderingList($args) {
			$sorting_list_html = '';

			if($args['order_by'] == 'yes') {
				$orderby_options = apply_filters('woocommerce_catalog_orderby', array(
					'menu_order' => esc_html__('Filter', 'roisin-core'),
					'total_sales' => esc_html__('Popularity', 'roisin-core'),
					'_wc_average_rating' => esc_html__('Average rating', 'roisin-core'),
					'date-desc' => esc_html__('Newness', 'roisin-core'),
					'_price' => esc_html__('Price: Low to High', 'roisin-core'),
					'_price-desc' => esc_html__('Price: High to Low', 'roisin-core')
				));

				if (get_option('woocommerce_enable_review_rating') === 'no') {
					unset($orderby_options['rating']);
				}

				foreach ($orderby_options as $key => $value) {
					$sorting_list_html .= '<button value="'. $key .'">'. $value .'</button>';
				}
			}

			return $sorting_list_html;
		}

		public function getProductPricingList($args) {
			$pricing_list_html = '';

			if($args['order_by']== 'yes') {
				$range = $args['price_range'] !== '' ? $args['price_range'] : 10;
				$value = 0;

				$pricing_list_html .= '<li><a data-minPrice="" data-maxPrice="" href="#">' . esc_html__('All', 'roisin-core') . '</a></li>';
				for ($i = 1; $i <= 5; $i++){
					if($i !== 5){
						$pricing_list_html .= '<li><a data-minPrice="'. $value .'" data-maxPrice="'. ($value+$range) .'" href="#">'. get_woocommerce_currency_symbol().$value .'-'.get_woocommerce_currency_symbol().($value+$range). '</a></li>';

					}else{
						$pricing_list_html .= '<li><a data-minPrice="'. ($value) .'" data-maxPrice="'.(100000000000).'" href="#">'. ($value).get_woocommerce_currency_symbol(). '+</a></li>';
					}

					$value += $range;
				}

			}

			return $pricing_list_html;
		}


		static function productListMetaQueryFilter($args, $params) {

			switch ($params['orderby']) {
				case 'menu_order':
					$args['orderby'] = 'menu_order title';
					$args['order'] = 'desc';
					break;
				case 'date-desc':
					$args['orderby'] = 'date';
					$args['order'] = 'desc';
					break;
				case '_price-desc':
					$args['meta_key'] = '_price';
					$args['order'] = 'desc';
	                $args['orderby'] = 'meta_value_num';
	                break;
				case 'total_sales':
					$args['meta_key'] = 'total_sales';
					$args['order'] = 'desc';
					$args['orderby'] = 'meta_value_num';
					break;
				case '_wc_average_rating':
					$args['meta_key'] = '_wc_average_rating';
					$args['order'] = 'desc';
					$args['orderby'] = 'meta_value_num';
					break;
				case '_price':
					$args['meta_key'] = '_price';
					$args['order'] = 'asc';
					$args['orderby'] = 'meta_value_num';
					break;
				default:
					// Do anything
					break;
			}

			return $args;
		}
	}
}

add_filter('roisin_filter_query_params', array('RoisinCoreProductListShortcode', 'productListMetaQueryFilter'), 10, 2);