<?php

if ( ! function_exists( 'roisin_core_add_product_list_variation_info_below' ) ) {
	function roisin_core_add_product_list_variation_info_below( $variations ) {
		$variations['info-below'] = esc_html__( 'Info Below', 'roisin-core' );
		
		return $variations;
	}
	
	add_filter( 'roisin_core_filter_product_list_layouts', 'roisin_core_add_product_list_variation_info_below' );
}

if ( ! function_exists( 'roisin_core_register_shop_list_info_below_actions' ) ) {
	function roisin_core_register_shop_list_info_below_actions() {
		
		// Add additional tags around product list item
		add_action( 'woocommerce_before_shop_loop_item', 'roisin_add_product_list_item_holder', 5 ); // permission 5 is set because woocommerce_template_loop_product_link_open hook is added on 10
		add_action( 'woocommerce_after_shop_loop_item', 'roisin_add_product_list_item_holder_end', 30 ); // permission 30 is set because woocommerce_template_loop_add_to_cart hook is added on 10
		
		// Add additional tags around product list item image
		add_action( 'woocommerce_before_shop_loop_item_title', 'roisin_add_product_list_item_image_holder', 5 ); // permission 5 is set because woocommerce_show_product_loop_sale_flash hook is added on 10
		add_action( 'woocommerce_before_shop_loop_item_title', 'roisin_add_product_list_item_image_holder_end', 30 ); // permission 30 is set because woocommerce_template_loop_product_thumbnail hook is added on 10
		
		// Add additional tags around add to cart
		add_action( 'woocommerce_after_shop_loop_item', 'roisin_add_product_list_item_additional_image_holder', 17 ); // permission 15 is set because woocommerce_template_loop_product_thumbnail hook is added on 10
		add_action( 'woocommerce_after_shop_loop_item', 'roisin_add_product_list_item_additional_image_holder_end', 19 ); // permission 25 is set because roisin_add_product_list_item_image_holder_end hook is added on 30
		
		// Add additional tags around product list item content
		add_action( 'woocommerce_shop_loop_item_title', 'roisin_add_product_list_item_content_holder', 5 ); // permission 5 is set because woocommerce_template_loop_product_title hook is added on 10
		add_action( 'woocommerce_after_shop_loop_item', 'roisin_add_product_list_item_content_holder_end', 20 ); // permission 30 is set because woocommerce_template_loop_add_to_cart hook is added on 10
		
		// Change add to cart position on product list
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 ); // permission 10 is default
		add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 18 ); // permission 20 is set because roisin_add_product_list_item_additional_image_holder hook is added on 15
	}
	
	add_action( 'roisin_core_action_shop_list_item_layout_info-below', 'roisin_core_register_shop_list_info_below_actions' );
}