<?php

if ( ! function_exists( 'roisin_core_add_working_hours_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_working_hours_options() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope'       => ROISIN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'working-hours',
				'icon'        => 'fa fa-book',
				'title'       => esc_html__( 'Working Hours', 'roisin-core' ),
				'description' => esc_html__( 'Global Working Hours Options', 'roisin-core' )
			)
		);
		
		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_monday',
					'title'      => esc_html__( 'Working Hours For Monday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_tuesday',
					'title'      => esc_html__( 'Working Hours For Tuesday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_wednesday',
					'title'      => esc_html__( 'Working Hours For Wednesday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_thursday',
					'title'      => esc_html__( 'Working Hours For Thursday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_friday',
					'title'      => esc_html__( 'Working Hours For Friday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_saturday',
					'title'      => esc_html__( 'Working Hours For Saturday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_sunday',
					'title'      => esc_html__( 'Working Hours For Sunday', 'roisin-core' )
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'checkbox',
					'name'       => 'qodef_working_hours_special_days',
					'title'      => esc_html__( 'Special Days', 'roisin-core' ),
					'options'    => array(
						'monday'    => esc_html__( 'Monday', 'roisin-core' ),
						'tuesday'   => esc_html__( 'Tuesday', 'roisin-core' ),
						'wednesday' => esc_html__( 'Wednesday', 'roisin-core' ),
						'thursday'  => esc_html__( 'Thursday', 'roisin-core' ),
						'friday'    => esc_html__( 'Friday', 'roisin-core' ),
						'saturday'  => esc_html__( 'Saturday', 'roisin-core' ),
						'sunday'    => esc_html__( 'Sunday', 'roisin-core' ),
					)
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_working_hours_special_text',
					'title'      => esc_html__( 'Featured Text For Special Days', 'roisin-core' )
				)
			);
			
			// Hook to include additional options after module options
			do_action( 'roisin_core_action_after_working_hours_options_map', $page );
		}
	}
	
	add_action( 'roisin_core_action_default_options_init', 'roisin_core_add_working_hours_options', roisin_core_get_admin_options_map_position( 'working-hours' ) );
}