<?php

if ( ! function_exists( 'roisin_core_add_working_hours_list_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_working_hours_list_widget( $widgets ) {
		$widgets[] = 'RoisinCoreWorkingHoursListWidget';
		
		return $widgets;
	}
	
	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_working_hours_list_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreWorkingHoursListWidget extends QodeFrameworkWidget {
		
		public function map_widget() {
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'roisin-core' )
				)
			);
			$widget_mapped = $this->import_shortcode_options( array(
				'shortcode_base' => 'roisin_core_working_hours_list'
			) );
			if ( $widget_mapped ) {
				$this->set_base( 'roisin_core_working_hours_list' );
				$this->set_name( esc_html__( 'Roisin Working Hours List', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Add a working hours list element into widget areas', 'roisin-core' ) );
			}
		}
		
		public function render( $atts ) {
			$params = $this->generate_string_params( $atts );
			
			echo do_shortcode( "[roisin_core_working_hours_list $params]" ); // XSS OK
		}
	}
}