<?php

if ( ! function_exists( 'roisin_child_theme_enqueue_scripts' ) ) {
	/**
	 * Function that enqueue theme's child style
	 */
	function roisin_child_theme_enqueue_scripts() {
		$main_style = 'roisin-main';
		
		wp_enqueue_style( 'roisin-child-style', get_stylesheet_directory_uri() . '/style.css', array( $main_style ) );
	}
	
	add_action( 'wp_enqueue_scripts', 'roisin_child_theme_enqueue_scripts' );
}

add_filter( 'woocommerce_account_menu_items', 'remove_my_account_downloads_tab' );

function remove_my_account_downloads_tab( $items ) {
    unset($items['downloads']);
    return $items;
}

// Add custom footer row under existing footer
add_action('wp_footer', 'add_custom_footer_credits', 100); // priority 100 to run after main footer

function add_custom_footer_credits() {
    ?>
    <div class="custom-footer-credits" style="text-align: center; padding: 20px 0; font-size: 0.8rem; background-color: #E7F0E4; color: #74a796;border-top: 1px solid #d0e0d5;">
        Designed with ❤️ by 
        <a href="https://purplez.com" target="_blank" style="color: #74a796; text-decoration: underline;">PurpleZ Marketing Agency</a>
    </div>
    <?php
}







function add_accessible_labels_script() {
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var menuButton = document.getElementById('qodef-mobile-header-opener');
            if (menuButton && !menuButton.hasAttribute('aria-label')) {
                menuButton.setAttribute('aria-label', 'Open mobile menu');
            }
        });
    </script>
    <?php
}
add_action('wp_footer', 'add_accessible_labels_script');



add_action('template_redirect', function () {
    // Change 'secret-page' to your actual page slug
    if (is_page('vase-rental-requests') && !current_user_can('administrator')) {
        wp_redirect(home_url(), 301); // 301 = SEO-friendly permanent redirect
        exit;
    }
});




/**
 * Enqueues all necessary scripts and styles for the CPT admin page.
 *
 * This single function handles loading the CSS for row colors and the JS for API actions,
 * ensuring they are only loaded on the correct front-end page.
 */
function my_cpt_assets() {
    // Only load these assets on our specific front-end page.
    if ( is_page( 'vase-rental-requests' ) ) {

        // 1. Enqueue the CSS for row and button colors.
        wp_enqueue_style(
            'cpt-admin-styles',
            get_stylesheet_directory_uri() . '/css/cpt-admin-styles.css',
            array(),
            '1.0.8' // Bumping version to help clear cache
        );

        // 2. Enqueue the JavaScript for button actions.
        wp_enqueue_script(
            'cpt-admin-updater',
            get_stylesheet_directory_uri() . '/js/cpt-admin-updater.js',
            array(), // No dependencies needed
            '2.4.0', // Matching the JS version
            true // Load in footer
        );

        // 3. Pass data from PHP to our JavaScript file.
        $script_data = array(
            'rest_url' => rest_url(),
            'nonce'    => wp_create_nonce( 'wp_rest' ),
            'cpt_slug' => 'vase-rental'
        );
        wp_localize_script( 'cpt-admin-updater', 'cptUpdater', $script_data );
    }
}
add_action( 'wp_enqueue_scripts', 'my_cpt_assets' );


/**
 * Creates the shortcode [cpt_action_button]
 * Usage: [cpt_action_button action="success" label="Mark as Success" icon="dashicons-yes"]
 */
function cpt_action_button_shortcode( $atts ) {
    // Get the current post's ID within the listing grid loop
    $post_id = get_the_ID();

    if ( ! $post_id ) {
        return '<!-- Post ID not found -->';
    }

    // Set default attributes and merge with user-provided ones
    $atts = shortcode_atts(
        array(
            'action' => '',
            'label'  => 'Action',
            'icon'   => '' // New icon attribute
        ),
        $atts,
        'cpt_action_button'
    );

    $action = sanitize_key( $atts['action'] );
    $label = esc_html( $atts['label'] );
    $icon = esc_attr( $atts['icon'] );

    if ( empty( $action ) ) {
        return '<!-- No action specified -->';
    }

    // Base button class
    $button_class = 'cpt-action-button button';

    // Add specific classes for styling
    if ( $action === 'delete' ) {
        $button_class .= ' button-primary is-destructive';
    } else {
        $button_class .= ' button-secondary';
    }

    // Add a class if an icon is being used
    if ( ! empty( $icon ) ) {
        $button_class .= ' cpt-action-button-icon';
        $button_content = sprintf( '<span class="dashicons %s"></span>', $icon );
    } else {
        $button_content = $label;
    }

    // Generate the button HTML, now with a 'title' attribute for the hover tooltip.
    return sprintf(
        '<button class="%s" data-action="%s" data-post-id="%d" data-label="%s" aria-label="%s" title="%s">%s</button>',
        esc_attr( $button_class ),
        esc_attr( $action ),
        esc_attr( $post_id ),
        $label, // The full text label for JS to use
        $label, // The aria-label for accessibility
        $label, // The title attribute for the hover tooltip
        $button_content
    );
}
add_shortcode( 'cpt_action_button', 'cpt_action_button_shortcode' );









function add_social_link_labels() {



    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const socialLinks = [
                { href: 'facebook.com', label: 'Facebook' },
                { href: 'twitter.com', label: 'Twitter' },
                { href: 'instagram.com', label: 'Instagram' },
                { href: 'linkedin.com', label: 'LinkedIn' }
            ];

            document.querySelectorAll('a[href]').forEach(link => {
                socialLinks.forEach(social => {
                    if (link.href.includes(social.href) && !link.hasAttribute('aria-label')) {
                        link.setAttribute('aria-label', social.label);
                    }
                });
            });
        });
    </script>
    <?php
}
add_action('wp_footer', 'add_social_link_labels');



function add_aria_label_to_jetwoo_product_links_corrected() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.jet-woo-products__item').forEach(function(productItem) {
            const thumbnailLink = productItem.querySelector('.jet-woo-product-thumbnail > a');
            const titleLink = productItem.querySelector('.jet-woo-product-title a');

            if (thumbnailLink && titleLink && !thumbnailLink.hasAttribute('aria-label')) {
                const productName = titleLink.textContent.trim();
                if (productName) {
                    thumbnailLink.setAttribute('aria-label', 'View product: ' + productName);
                }
            }
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'add_aria_label_to_jetwoo_product_links_corrected');

function fix_all_javascript_void_links() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Select all <a> tags with href="javascript:void(0)"
        const voidLinks = document.querySelectorAll('a[href="javascript:void(0)"]');
        
        voidLinks.forEach(function(link) {
            // Change href to #
            link.setAttribute('href', '#');
            
            // Add role=button if missing
            if (!link.hasAttribute('role')) {
                link.setAttribute('role', 'button');
            }

            // Add aria-label if missing (customize for your site)
            if (!link.hasAttribute('aria-label')) {
                // Basic guess based on class or id
                if (link.id === 'qodef-side-area-close') {
                    link.setAttribute('aria-label', 'Close side area');
                } else if (link.classList.contains('qodef-search-close')) {
                    link.setAttribute('aria-label', 'Close search');
                } else {
                    link.setAttribute('aria-label', 'Button');
                }
            }

            // Prevent default page jump on #
            link.addEventListener('click', function(e) {
                e.preventDefault();
            });
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'fix_all_javascript_void_links');



function add_aria_label_to_side_area_openers() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('a.qodef-side-area-opener').forEach(function(link) {
            if (!link.hasAttribute('aria-label') && !link.textContent.trim()) {
                link.setAttribute('aria-label', 'Open side area');
            }
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'add_aria_label_to_side_area_openers');







/**
 * Theme-level Coupon Guard (Checkout Blocks + classic)
 * - Captures raw coupon code from Store API (direct + batch) so case checks are correct
 * - Rules: exact | case_insensitive | all_caps | all_lower
 * - Eligibility: any | first_time | returning
 * - Replaces Woo's generic error with your message (no duplicate "Coupon is not valid.")
 *
 * Paste into your (child) theme's functions.php
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

/** ------------------------------------------------------------------------
 * 1) Capture raw coupon code from Store API JSON (direct + batch)
 * --------------------------------------------------------------------- */
add_filter( 'rest_pre_dispatch', function( $result, $server, $request ) {
	try {
		$route = method_exists( $request, 'get_route' ) ? $request->get_route() : '';
		if ( strpos( (string) $route, '/wc/store/' ) === false ) {
			return $result;
		}

		$payload = method_exists( $request, 'get_json_params' ) ? $request->get_json_params() : null;
		if ( ! is_array( $payload ) ) {
			return $result;
		}

		$capture = null;

		// Direct: /wc/store/v1/cart/apply-coupon  { "code": "WELCOME10" }
		if ( isset( $payload['code'] ) && $payload['code'] !== '' ) {
			$capture = (string) $payload['code'];
		}

		// Batch: /wc/store/v1/batch  { "requests":[{ "path":"/wc/store/v1/cart/apply-coupon", "body":{ "code":"..." } }] }
		if ( null === $capture && isset( $payload['requests'] ) && is_array( $payload['requests'] ) ) {
			foreach ( $payload['requests'] as $r ) {
				$path = isset( $r['path'] ) ? (string) $r['path'] : '';
				if ( strpos( $path, '/wc/store/v1/cart/apply-coupon' ) !== false ) {
					$body = array();
					if ( isset( $r['body'] ) && is_array( $r['body'] ) ) {
						$body = $r['body'];
					} elseif ( isset( $r['data'] ) && is_array( $r['data'] ) ) {
						$body = $r['data'];
					}
					if ( isset( $body['code'] ) && $body['code'] !== '' ) {
						$capture = (string) $body['code'];
						break;
					}
				}
			}
		}

		// Stash for the validator (global + WC session).
		if ( null !== $capture ) {
			$GLOBALS['navid_coupon_raw'] = $capture;
			if ( function_exists( 'WC' ) && WC()->session ) {
				WC()->session->set( 'navid_coupon_raw', $capture );
			}
		}
	} catch ( \Throwable $e ) {
		// best effort only
	}
	return $result;
}, 9, 3 );

/** ------------------------------------------------------------------------
 * 2) Validation: enforce format + eligibility
 * --------------------------------------------------------------------- */
add_filter( 'woocommerce_coupon_is_valid', 'navid_coupon_rules_validate', 10, 2 );
function navid_coupon_rules_validate( $is_valid, $coupon ) {

	// ---- EDIT YOUR RULES HERE ------------------------------------------------
	$rules = [
		// Example 1: first-time only, exact case WELCOME10
		'WELCOME10' => [
			'match'       => 'exact',           // exact | case_insensitive | all_caps | all_lower
			'eligibility' => 'first_time',      // any | first_time | returning
			// Optional: set a custom display form. If omitted:
			//  - all_lower -> lower
			//  - otherwise -> ALL CAPS
			//'display'   => 'WELCOME10',
			'msgs'        => [
				// You can include %s and it will be replaced with the display form
				'format'      => 'Please check capitalization: use %s.',
				'first_time'  => 'Sorry, "%s" is for first-time customers only.',
				'returning'   => 'Sorry, "%s" is for returning customers only.',
			],
		],

		// Example 2: anyone can use, must be lowercase
		'fall20' => [
			'match'       => 'all_lower',
			'eligibility' => 'any',
			'msgs'        => [
				'format'      => 'Use lowercase: %s.',
			],
		],
	];
	// -------------------------------------------------------------------------

	if ( ! $coupon || ! method_exists( $coupon, 'get_code' ) ) {
		return $is_valid;
	}

	$code_obj = $coupon->get_code(); // normalized Woo code (often lowercased)
	$rule     = navid_coupon_rules_find_rule( $rules, $code_obj );
	if ( ! $rule ) {
		return $is_valid; // not managing this coupon here
	}

	// Prefer the raw input captured from Store API; then fall back to classic POST.
	$raw = navid_coupon_rules_fetch_raw( $code_obj );

	// Decide how we show the code in messages:
	$match_mode   = $rule['match'] ?? 'case_insensitive';
	$display_code = isset( $rule['display'] ) && $rule['display'] !== ''
		? (string) $rule['display']
		: ( 'all_lower' === $match_mode ? strtolower( $rule['code'] ) : strtoupper( $rule['code'] ) );

	// 1) Format / case enforcement.
	if ( ! navid_coupon_rules_format_ok( $match_mode, $rule['code'], $raw, $code_obj ) ) {
		$format_msg = $rule['msgs']['format'] ?? 'Invalid coupon code format.';
		if ( strpos( $format_msg, '%s' ) !== false ) {
			$format_msg = sprintf( $format_msg, $display_code );
		}
		navid_coupon_rules_set_session_reason( [
			'type'    => 'format',
			'code'    => $code_obj,
			'message' => $format_msg,
		] );
		return false; // triggers Woo’s coupon error; we replace the message below
	}

	// 2) Eligibility check.
	$count = navid_coupon_rules_prior_order_count();
	$elig  = $rule['eligibility'] ?? 'any';

	if ( 'first_time' === $elig && $count > 0 ) {
		navid_coupon_rules_set_session_reason( [
			'type'    => 'first_time',
			'code'    => $code_obj, // keep normalized for matching; message uses $display_code
			'message' => sprintf( $rule['msgs']['first_time'] ?? 'Sorry, "%s" is for first-time customers only.', $display_code ),
		] );
		return false;
	}
	if ( 'returning' === $elig && $count < 1 ) {
		navid_coupon_rules_set_session_reason( [
			'type'    => 'returning',
			'code'    => $code_obj,
			'message' => sprintf( $rule['msgs']['returning'] ?? 'Sorry, "%s" is for returning customers only.', $display_code ),
		] );
		return false;
	}

	return $is_valid;
}

/** ------------------------------------------------------------------------
 * 3) Replace Woo’s generic message with our friendly one (classic + Blocks)
 * --------------------------------------------------------------------- */
add_filter( 'woocommerce_coupon_error', 'navid_coupon_rules_pretty_error', 10, 3 );
function navid_coupon_rules_pretty_error( $error_message, $error_code, $coupon ) {
	if ( ! $coupon || ! method_exists( $coupon, 'get_code' ) ) {
		return $error_message;
	}
	// When a validator returns false, Woo uses E_WC_COUPON_INVALID_FILTERED.
	if ( class_exists( 'WC_Coupon' ) && intval( $error_code ) === WC_Coupon::E_WC_COUPON_INVALID_FILTERED ) {
		$reason = function_exists( 'WC' ) && WC()->session ? WC()->session->get( 'navid_coupon_last_reason' ) : null;
		if ( is_array( $reason ) && ! empty( $reason['message'] ) ) {
			if ( 0 === strcasecmp( $reason['code'] ?? '', $coupon->get_code() ) ) {
				// One-time read to prevent duplicates on subsequent requests
				if ( function_exists( 'WC' ) && WC()->session ) {
					WC()->session->set( 'navid_coupon_last_reason', null );
				}
				return $reason['message'];
			}
		}
	}
	return $error_message;
}

/** ------------------------------------------------------------------------
 * Helpers
 * --------------------------------------------------------------------- */

function navid_coupon_rules_find_rule( array $rules, string $coupon_code_obj ) : ?array {
	foreach ( $rules as $key => $r ) {
		if ( 0 === strcasecmp( $key, $coupon_code_obj ) ) {
			$r['code'] = $key; // canonical representation for messages/format tips
			return $r;
		}
	}
	return null;
}

function navid_coupon_rules_fetch_raw( string $coupon_code_obj ) : string {
	$raw = '';

	// 1) From global set during Store API capture
	if ( isset( $GLOBALS['navid_coupon_raw'] ) ) {
		$raw = (string) $GLOBALS['navid_coupon_raw'];
		unset( $GLOBALS['navid_coupon_raw'] );
	}

	// 2) From Woo session
	if ( '' === $raw && function_exists( 'WC' ) && WC()->session ) {
		$raw = (string) ( WC()->session->get( 'navid_coupon_raw' ) ?? '' );
		WC()->session->set( 'navid_coupon_raw', null );
	}

	// 3) Classic POST keys (shortcode checkout/cart)
	if ( '' === $raw && isset( $_POST['coupon_code'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$raw = sanitize_text_field( wp_unslash( $_POST['coupon_code'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	} elseif ( '' === $raw && isset( $_POST['code'] ) ) { // rare non-JSON posts
		$raw = sanitize_text_field( wp_unslash( $_POST['code'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	}

	$raw = trim( (string) $raw );

	// 4) Final fallback during REST to avoid undefined: use Woo’s normalized (may be lowercase)
	if ( '' === $raw && defined( 'REST_REQUEST' ) && REST_REQUEST ) {
		$raw = (string) $coupon_code_obj;
	}

	return $raw;
}

function navid_coupon_rules_format_ok( string $mode, string $rule_code, string $raw_input, string $normalized ) : bool {
	$rule_code = trim( $rule_code );
	$raw_input = trim( $raw_input );

	switch ( $mode ) {
		case 'exact':
			return $raw_input === $rule_code;

		case 'all_caps':
			return ( strtoupper( $raw_input ) === $raw_input ) && ( 0 === strcasecmp( $raw_input, $rule_code ) );

		case 'all_lower':
			return ( strtolower( $raw_input ) === $raw_input ) && ( 0 === strcasecmp( $raw_input, $rule_code ) );

		case 'case_insensitive':
		default:
			return ( 0 === strcasecmp( $raw_input, $rule_code ) ) || ( 0 === strcasecmp( $normalized, $rule_code ) );
	}
}

function navid_coupon_rules_prior_order_count() : int {
	$statuses = [ 'wc-completed', 'wc-processing', 'wc-on-hold' ];

	if ( is_user_logged_in() ) {
		if ( function_exists( 'wc_get_customer_order_count' ) ) {
			return (int) wc_get_customer_order_count( get_current_user_id() );
		}
		$orders = wc_get_orders( [
			'limit'       => 1,
			'return'      => 'ids',
			'status'      => $statuses,
			'customer_id' => get_current_user_id(),
		] );
		return empty( $orders ) ? 0 : 1;
	}

	$email = '';
	if ( isset( $_POST['billing_email'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$email = sanitize_email( wp_unslash( $_POST['billing_email'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	} elseif ( function_exists( 'WC' ) && WC()->customer ) {
		$email = WC()->customer->get_billing_email();
	}
	if ( ! $email ) {
		return 0; // allow provisional use at cart; will revalidate at checkout once email exists
	}

	$orders = wc_get_orders( [
		'limit'      => 1,
		'return'     => 'ids',
		'status'     => $statuses,
		'meta_query' => [
			[ 'key' => '_billing_email', 'value' => $email, 'compare' => '=' ],
		],
	] );
	return empty( $orders ) ? 0 : 1;
}

function navid_coupon_rules_set_session_reason( array $reason ) : void {
	if ( function_exists( 'WC' ) && WC()->session ) {
		WC()->session->set( 'navid_coupon_last_reason', $reason );
	}
}

/* // Optional quick logger for debugging (view under WooCommerce → Status → Logs)
function navid_coupon_log( $msg, $data = [] ) {
	if ( function_exists( 'wc_get_logger' ) ) {
		wc_get_logger()->info( $msg . ' ' . wp_json_encode( $data ), [ 'source' => 'navid_coupon' ] );
	}
}
*/










/*
Plugin Name: WC – Limit sales to selected US states (enhanced picker)
Description: Adds a searchable, tag-style state selector with select/clear/invert and enforces it on the front-end.
Version: 1.1
*/

if ( ! defined( 'ABSPATH' ) ) exit;

/** 1) Add the setting on Woo → Settings → General */
add_filter('woocommerce_get_settings_general', function ($settings) {
    $states = class_exists('WC_Countries') ? (new WC_Countries())->get_states('US') : array();

    $field = array(
        'name'            => __('Allowed US states', 'wc-us-state-limit'),
        'id'              => 'wc_allowed_us_states',
        'type'            => 'multiselect',
        // The magic: this enables Select2 (searchable, tag-style chips)
        'class'           => 'wc-enhanced-select',
        'css'             => 'min-width:350px;',
        'desc_tip'        => true,
        'desc'            => __('Search & pick states. Use the buttons to select/clear/invert.', 'wc-us-state-limit'),
        'options'         => $states,
        'select_buttons'  => true, // shows “Select all | Select none”
        'custom_attributes'=> array(
            'data-placeholder' => __('Search states…', 'wc-us-state-limit'),
            'data-allow_clear' => 'true',
        ),
        'autoload'        => false,
    );

    // Insert near the “Enable taxes” row, or append if not found.
    $insert_at = null;
    foreach ($settings as $i => $row) {
        if (isset($row['id']) && $row['id'] === 'woocommerce_calc_taxes') { $insert_at = $i; break; }
    }
    if ($insert_at !== null) array_splice($settings, $insert_at, 0, array($field));
    else $settings[] = $field;

    return $settings;
}, 50);

/** 2) Add an “Invert” button next to Select all/none */
add_action('admin_footer', function () {
    if (empty($_GET['page']) || $_GET['page'] !== 'wc-settings' || ($_GET['tab'] ?? '') !== 'general') return; ?>
    <script>
    jQuery(function($){
        var $sel = $('#wc_allowed_us_states');
        if(!$sel.length) return;

        // Add Invert link right after existing buttons
        var $row = $sel.closest('tr');
        var $buttonsCell = $row.find('.wc-enhanced-select, select[multiple]').last().closest('td');
        var $selectNone = $buttonsCell.find('.select_none');
        if ($selectNone.length) {
            $('<a href="#" class="button-link select_invert" style="margin-left:6px;">'+
              '<?php echo esc_js( __('Invert', 'wc-us-state-limit') ); ?>'+'</a>')
              .insertAfter($selectNone);
        }

        // Invert behavior
        $row.on('click', '.select_invert', function(e){
            e.preventDefault();
            var all = $sel.find('option').map(function(){ return this.value; }).get();
            var selected = $sel.val() || [];
            var inverted = all.filter(function(v){ return selected.indexOf(v) === -1; });
            $sel.val(inverted).trigger('change');
        });
    });
    </script>
<?php });

/** 3) Limit the state dropdowns to the selected states (front-end only) */
add_filter('woocommerce_states', function ($states) {
    // Never restrict inside wp-admin (settings, shipping zones, orders, etc.)
    if (is_admin() || (defined('REST_REQUEST') && REST_REQUEST) || wp_doing_cron()) {
        return $states;
    }

    $allowed = array_filter((array) get_option('wc_allowed_us_states', array()));
    if (!empty($allowed) && isset($states['US'])) {
        $states['US'] = array_intersect_key($states['US'], array_flip($allowed));
    }
    return $states;
}, 20);


/** 4) Block checkout if a non-allowed state is used (extra safety) */
add_action('woocommerce_after_checkout_validation', function ($data, $errors) {
    $allowed = array_filter((array) get_option('wc_allowed_us_states', array()));
    if (empty($allowed)) return;

    $map  = (new WC_Countries())->get_states('US');
    $list = implode(', ', array_values(array_intersect_key($map, array_flip($allowed))));

    if (($data['billing_country'] ?? '') === 'US' && !in_array($data['billing_state'] ?? '', $allowed, true)) {
        $errors->add('validation', sprintf(__('We currently serve only these US states: %s.', 'wc-us-state-limit'), $list));
    }
    if (($data['shipping_country'] ?? '') === 'US' && !in_array($data['shipping_state'] ?? '', $allowed, true)) {
        $errors->add('validation', sprintf(__('We currently ship only to these US states: %s.', 'wc-us-state-limit'), $list));
    }
}, 10, 2);








function custom_product_short_description_shortcode( $atts ) {
    if ( ! is_product() ) {
        return '';
    }

    global $post;

    // 1) Get shortcode attributes
    $atts = shortcode_atts( array(
        'heading_tag'        => 'h2',
        'font_size_desktop'  => '22px',
        'font_size_tablet'   => '18px',
        'font_size_mobile'   => '16px',
    ), $atts );

    // 2) Get short description
    $short_description = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
    if ( empty( $short_description ) ) {
        return '';
    }

    // 3) Build the HTML
    $output  = '<' . esc_attr( $atts['heading_tag'] ) . ' class="custom-short-description-heading">';
    $output .= $short_description;
    $output .= '</' . esc_attr( $atts['heading_tag'] ) . '>';

    // 4) Add responsive styles
    $output .= "<style>
        .custom-short-description-heading {
            font-size: {$atts['font_size_desktop']} !important;
        }
        @media (max-width: 1024px) {
            .custom-short-description-heading {
                font-size: {$atts['font_size_tablet']} !important;
            }
        }
        @media (max-width: 767px) {
            .custom-short-description-heading {
                font-size: {$atts['font_size_mobile']} !important;
            }
        }
    </style>";

    return $output;
}
add_shortcode( 'product_short_description', 'custom_product_short_description_shortcode' );










function custom_product_categories_shortcode($atts) {
    if ( ! is_product() ) {
        return '';
    }
    global $post;

    // 1) Shortcode attributes & defaults
    $atts = shortcode_atts( array(
        'type'               => 'both', // NEW
        'font_color'         => '#006666',
        'font_size_desktop'  => '16px',
        'font_size_tablet'   => '14px',
        'font_size_mobile'   => '12px',
        'heading_tag'        => 'span',
    ), $atts );

    // 2) Custom category map
    $custom_data = array(
        // Gifts
        'gifts-for-her'   => array( 'link'=>'/gifts/flowers-for-her-in-orange-county/' ),
        'gifts-for-him'   => array( 'link'=>'/gifts/flowers-for-men-in-orange-county/' ),
        'business-gifts'  => array( 'link'=>'/gifts/flowers-for-businesses-in-orange-county/' ),

        // Occasions
        'bouquests'       => array( 'link'=>'/flower-bouquet-in-orange-county/' ),
        'boxes'           => array( 'link'=>'/flower-box-in-orange-county/' ),
        'premium'         => array( 'link'=>'/premium-flowers-in-orange-county/' ),
        'sale'            => array( 'link'=>'/flowers-for-sale-in-orange-county/' ),
        'best-sellers'    => array( 'link'=>'/best-selling-flowers-in-orange-county/' ),
        'anniversary'     => array( 'link'=>'/occasions/anniversary-flowers-in-orange-county/' ),
        'new-baby'        => array( 'link'=>'/occasions/new-baby-flowers-in-orange-county/' ),
        'weddings'        => array( 'link'=>'/occasions/wedding-flowers-in-orange-county/' ),
        'quinceanera'     => array( 'link'=>'/occasions/quinceanera-flowers-in-orange-county/' ),
        'engagement'      => array( 'link'=>'/occasions/engagement-flowers-in-orange-county/' ),
        'wreaths-hearts-and-crosses'=> array( 'link'=>'/occasions/funeral-cross-flowers-in-orange-county/' ),
        'sprays-and-baskets'   => array( 'link'=>'/occasions/funeral-sprays-in-orange-county/' ),
        'flowers-for-the-service'=>array('link'=>'/occasions/funeral-flower-arrangements-in-orange-county/' ),
        'sympathy-unique'      => array( 'link'=>'/occasions/sympathy-flowers-in-orange-county/' ),
        'christmas'       => array( 'link'=>'/occasions/christmas-flowers-in-orange-county/' ),
        'mothers-day'     => array( 'link'=>'/occasions/mothers-day-flowers-in-orange-county/' ),
        'fathers-day'     => array( 'link'=>'/occasions/fathers-day-flowers-in-orange-county/' ),
        'graduation'      => array( 'link'=>'/occasions/graduation-flowers-in-orange-county/' ),
        'valentines-day'  => array( 'link'=>'/occasions/valentines-day-flowers-in-orange-county/' ),
        'birthday'        => array( 'link'=>'/occasions/birthday-flowers-in-orange-county/' ),
        'congratulations' => array( 'link'=>'/occasions/congratulations-flowers-in-orange-county/' ),
        'get-well'        => array( 'link'=>'/occasions/get-well-soon-flowers-in-orange-county/' ),
        'love-and-romance'=> array( 'link'=>'/occasions/love-flowers-in-orange-county/' ),
        'im-sorry'        => array( 'link'=>'/occasions/apology-flowers-in-orange-county/' ),
        'thank-you'       => array( 'link'=>'/occasions/thank-you-flowers-in-orange-county/' ),
    );

    // 3) Gift slugs
    $gift_slugs = array(
        'gifts-for-her',
        'gifts-for-him',
        'business-gifts',
    );

    // 4) Get product categories
    $terms = get_the_terms( $post->ID, 'product_cat' );
    if ( ! $terms || is_wp_error( $terms ) ) {
        return '';
    }

    // 5) Separate gifts and occasions
    $gifts = array();
    $occasions = array();

    foreach ( $terms as $term ) {
        $slug  = $term->slug;
        $name  = $term->name;
        $data  = isset( $custom_data[ $slug ] ) ? $custom_data[ $slug ] : array();
        $link  = isset( $data['link'] ) ? esc_url( $data['link'] ) : get_term_link( $term );

        $item = sprintf(
            '<%1$s class="category-link" style="margin: 0px;"><a href="%2$s">%3$s</a></%1$s>',
            tag_escape( $atts['heading_tag'] ),
            $link,
            esc_html( $name )
        );

        if ( in_array( $slug, $gift_slugs ) ) {
            $gifts[] = $item;
        } else {
            $occasions[] = $item;
        }
    }

    // 6) Build output
    $output = '<div class="custom-product-categories-shortcode">';

    if ( $atts['type'] === 'occasions' || $atts['type'] === 'both' ) {
        if ( ! empty( $occasions ) ) {
            $output .= '<div class="occasions-list"><span class="categories-prefix">Occasions: </span>';
            $output .= implode( ', ', $occasions );
            $output .= '</div>';
        }
    }

    if ( $atts['type'] === 'gifts' || $atts['type'] === 'both' ) {
        if ( ! empty( $gifts ) ) {
            $output .= '<div class="gifts-list"><span class="categories-prefix">Gifts: </span>';
            $output .= implode( ', ', $gifts );
            $output .= '</div>';
        }
    }

    $output .= '</div>';

    // 7) Inline styles
    $output .= "<style>
        .custom-product-categories-shortcode {
            color: {$atts['font_color']};
        }
        .custom-product-categories-shortcode > div {
            margin-bottom: 0.5em;
        }
        .custom-product-categories-shortcode > div > * {
            display: inline-block;
            font-size: {$atts['font_size_desktop']} !important;
            margin-right: 0.5em;
        }
        @media (max-width: 1024px) {
            .custom-product-categories-shortcode > div > * {
                font-size: {$atts['font_size_tablet']} !important;
            }
        }
        @media (max-width: 767px) {
            .custom-product-categories-shortcode > div > * {
                font-size: {$atts['font_size_mobile']} !important;
            }
        }
    </style>";

    return $output;
}
add_shortcode( 'custom_product_categories', 'custom_product_categories_shortcode' );





function custom_product_attributes_shortcode($atts) {
    if ( ! is_product() ) {
        return '';
    }
    global $post;

    // 1) Shortcode attributes & defaults
    $atts = shortcode_atts( array(
        'fontss_color'         => '#066',
        'font_size_desktop'  => '16px',
        'font_size_tablet'   => '14px',
        'font_size_mobile'   => '12px',
        'heading_tag'        => 'span',
        'show'               => '',   // new: comma‑separated list of which to show: "color,flower"
    ), $atts );

    // 2) Your custom map (unchanged)
    $custom = array(
        'hydrangeas'=>['link'=>'/flower/hydrangea-flower-in-orange-county/','before'=>'','after'=>''],
        'lilies'=>    ['link'=>'/flower/lily-flowers-bouquet-in-orange-county/','before'=>'','after'=>''],
        'orchids'=>   ['link'=>'/flower/orchid-flower-in-orange-county/','before'=>'','after'=>''],
        'peonies'=>   ['link'=>'/flower/peonies-flowers-in-orange-county/','before'=>'','after'=>''],
        'roses'=>     ['link'=>'/flower/rose-flower-in-orange-county/','before'=>'','after'=>''],
        'sunflowers'=>['link'=>'/flower/sunflower-bouquet-in-orange-county/','before'=>'','after'=>''],
        'tulips'=>    ['link'=>'/flower/tulips-flower-in-orange-county/','before'=>'','after'=>''],
		'carnation'=>    ['link'=>'/flower/carnation-flowers-in-orange-county/','before'=>'','after'=>''],
		'chrysanthemum'=>    ['link'=>'/flower/chrysanthemum-flower-in-orange-county/','before'=>'','after'=>''],
		'hydrangeas'=>    ['link'=>'/flower/lisianthus-flower-in-orange-county/','before'=>'','after'=>''],

        'white'=> ['link'=>'/color/white-flower-bouquet-in-orange-county/','before'=>'','after'=>''],
        'pink'=>  ['link'=>'/color/pink-flower-bouquet-delivery-in-orange-county/','before'=>'','after'=>''],
        'red'=>   ['link'=>'/color/red-flower-bouquet-in-orange-county/','before'=>'','after'=>''],
        'blue'=>  ['link'=>'/color/blue-flower-bouquet-in-orange-county/','before'=>'','after'=>''],
        'orange'=>['link'=>'/color/orange-flower-bouquet-in-orange-county/','before'=>'','after'=>''],
        'yellow'=>['link'=>'/color/yellow-flower-bouquet-in-orange-county/','before'=>'','after'=>''],
    );

    // 3) All available taxonomies & their labels
    $all_taxonomies = array(
        'pa_color'  => 'Color',
        'pa_flower' => 'Flower',
    );

    // 4) Parse the `show` attr to filter which to render
    $taxonomies = array();
    if ( trim( $atts['show'] ) === '' ) {
        // nothing specified → show all
        $taxonomies = $all_taxonomies;
    } else {
        $wanted = array_map( 'trim', explode( ',', strtolower( $atts['show'] ) ) );
        foreach ( $all_taxonomies as $tax => $label ) {
            $slug = str_replace( 'pa_', '', $tax );
            if ( in_array( $slug, $wanted ) || in_array( strtolower( $label ), $wanted ) ) {
                $taxonomies[ $tax ] = $label;
            }
        }
    }

    $output = '';

    // 5) Loop each selected taxonomy
    foreach ( $taxonomies as $tax => $label ) {
        $terms = get_the_terms( $post->ID, $tax );
        if ( ! $terms || is_wp_error( $terms ) ) {
            continue;
        }

        // pluralize label
        $count  = count( $terms );
        $prefix = $label . ( $count > 1 ? 's' : '' );

        // build each link (exactly like categories shortcode)
        $items = array();
        foreach ( $terms as $term ) {
            $slug   = $term->slug;
            $data   = isset( $custom[ $slug ] ) ? $custom[ $slug ] : array();
            $link   = isset( $data['link'] )   ? esc_url( $data['link'] )   : get_term_link( $term );
            $before = isset( $data['before'] ) ? esc_html( $data['before'] ) : '';
            $after  = isset( $data['after'] )  ? esc_html( $data['after'] )  : '';

            $items[] = sprintf(
                '<%1$s class="attribute-link" style="margin: 0;"><a href="%2$s">%3$s%4$s%5$s</a></%1$s>',
                tag_escape( $atts['heading_tag'] ),
                $link,
                $before,
                esc_html( $term->name ),
                $after
            );
        }

        // wrap in the same flat, categories‑style block
        $output .= '<div class="custom-product-attributes-shortcode">';
        $output .= sprintf(
            '<span class="categories-prefix">%s: </span>',
            esc_html( $prefix )
        );
        $output .= implode( ', ', $items );
        $output .= '</div>';
    }

    // 6) Same inline‑block + responsive CSS as categories shortcode
    $output .= "<style>
        .custom-product-attributes-shortcode {
            color: {$atts['fontss_color']};
        }
        .custom-product-attributes-shortcode > * {
            display: inline-block;
            font-size: {$atts['font_size_desktop']} !important;
            margin-right: 0.5em;
        }
        @media (max-width: 1024px) {
            .custom-product-attributes-shortcode > * {
                font-size: {$atts['font_size_tablet']} !important;
            }
        }
        @media (max-width: 767px) {
            .custom-product-attributes-shortcode > * {
                font-size: {$atts['font_size_mobile']} !important;
            }
        }
    </style>";

    return $output;
}
add_shortcode( 'custom_product_attributes', 'custom_product_attributes_shortcode' );



function custom_add_to_cart_shortcode( $atts ) {
    global $product;

    if ( ! $product || ! is_a( $product, 'WC_Product' ) ) return '';

    $atts = shortcode_atts([
        'bg' => '#d0dfcf',
        'color' => '#0c5b47',
        'width' => '100%',
        'font_size' => '16px'
    ], $atts);

    $product_id = $product->get_id();

    ob_start();

    ?>
    <form class="custom-add-to-cart-inline variations_form cart" method="post"
          data-product_id="<?php echo esc_attr( $product_id ); ?>"
          data-product_variations='<?php echo esc_attr( wp_json_encode( $product->is_type( 'variable' ) ? $product->get_available_variations() : [] ) ); ?>'>

        <?php if ( $product->is_type( 'variable' ) ) :
            $attributes = $product->get_variation_attributes();
            foreach ( $attributes as $attribute_name => $options ) : ?>
                <div class="custom-variation">
                    <label><?php echo wc_attribute_label( $attribute_name ); ?></label>
                    <select name="attribute_<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>" required>
                        <option value="">Choose an option</option>
                        <?php foreach ( $options as $option ) : ?>
                            <option value="<?php echo esc_attr( $option ); ?>"><?php echo esc_html( $option ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
        <?php endforeach; endif; ?>

        <div class="custom-inline-controls">
            <input type="number" name="quantity" min="1" value="1" class="custom-qty" />
            <input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product_id ); ?>" />
            <input type="hidden" name="product_id" value="<?php echo esc_attr( $product_id ); ?>" />
            <input type="hidden" name="variation_id" class="variation_id" value="0" />
            <button type="submit" class="custom-cart-button">Add to Cart</button>
        </div>

        <a href="<?php echo wc_get_cart_url(); ?>" class="custom-view-cart-button" style="display:none;">View Cart</a>
    </form>

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".custom-add-to-cart-inline").forEach(function (form) {
        form.addEventListener("submit", function (e) {
            e.preventDefault();

            let productID = form.querySelector('[name="product_id"]').value;
            let quantity = form.querySelector('[name="quantity"]').value;
            let variationID = form.querySelector('[name="variation_id"]') ? form.querySelector('[name="variation_id"]').value : 0;

            let formData = new FormData();
            formData.append("product_id", productID);
            formData.append("quantity", quantity);
            formData.append("variation_id", variationID);

            form.querySelectorAll("select").forEach(select => {
                formData.append(select.name, select.value);
            });

            fetch(wc_add_to_cart_params.wc_ajax_url.toString().replace("%%endpoint%%", "add_to_cart"), {
                method: "POST",
                body: formData,
                credentials: "same-origin"
            })
            .then(response => response.json())
            .then(data => {
                if (data && data.fragments) {
                    // Update Woo fragments
                    Object.entries(data.fragments).forEach(([selector, html]) => {
                        const el = document.querySelector(selector);
                        if (el) el.innerHTML = html;
                    });

                    // UI feedback
                    const controls = form.querySelector(".custom-inline-controls");
                    const viewCart = form.querySelector(".custom-view-cart-button");

                    if (controls && viewCart) {
                        controls.style.display = "none";
                        viewCart.style.display = "inline-block";

                        setTimeout(() => {
                            controls.style.display = "flex";
                            viewCart.style.display = "none";
                        }, 5000);
                    }
                }
            });
        });

        if (jQuery && typeof jQuery.fn.wc_variation_form === "function") {
            jQuery(form).wc_variation_form();
        }
    });
});
</script>


    <style>
        .custom-add-to-cart-inline {
            display: flex;
            flex-direction: row;
            gap: 10px;
            align-items: baseline;
        }

        .custom-inline-controls {
            display: flex;
            align-items: baseline;
            gap: 10px;
            flex-wrap: wrap;
			flex-direction: row;
        }

        .custom-add-to-cart-inline .custom-qty {
            width: 80px !important;
            padding: 8px !important;
            border: 1px solid #ccc !important;
            font-size: 14px !important;
            font-family: inherit !important;
            background-color: #fff !important;
            color: #000 !important;
            appearance: none;
        }

        .custom-qty::-webkit-inner-spin-button,
        .custom-qty::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        .custom-cart-button {
            background-color: <?php echo esc_attr( $atts['bg'] ); ?> !important;
            color: <?php echo esc_attr( $atts['color'] ); ?> !important;
            font-size: <?php echo esc_attr( $atts['font_size'] ); ?> !important;
            width: <?php echo esc_attr( $atts['width'] ); ?> !important;
            border: none !important;
            padding: 10px 16px !important;
            cursor: pointer;
            text-align: center;
        }

        .custom-cart-button:hover {
            opacity: 0.9;
        }

        .custom-view-cart-button {
            background-color: <?php echo esc_attr( $atts['bg'] ); ?>;
            color: <?php echo esc_attr( $atts['color'] ); ?>;
            font-size: <?php echo esc_attr( $atts['font_size'] ); ?>;
            text-decoration: none;
            padding: 10px 16px;
            display: inline-block;
            width: <?php echo esc_attr( $atts['width'] ); ?>;
            text-align: center;
        }

        @media (max-width: 768px) {
            .custom-inline-controls {
                flex-direction: column;
                align-items: stretch;
            }

            .custom-cart-button,
            .custom-qty {
                width: 100% !important;
            }

            .custom-view-cart-button {
                width: 100%;
            }
        }
    </style>

    <?php

    return ob_get_clean();
}
add_shortcode( 'custom_add_to_cart', 'custom_add_to_cart_shortcode' );




