(function ($) {
	"use strict";

	window.qodef = {};
	window.qodefEmptyCallback = function () {};

	qodef.windowWidth = $(window).width();
	qodef.windowHeight = $(window).height();
	qodef.body = $('body');
	qodef.html = $('html');
	qodef.scroll = 0;

	$(document).ready(function () {
		qodef.scroll = $(window).scrollTop();
		qodefBrowserDetection.init();
		qodefMagnificPopup.init();
		qodefAnimateVerticalText.init();
		qodefUncoveringRowLanding.init();
		setTimeout(function () {
			qodefCloseCursor.init();
		}, 300);

	});

	$(window).on('load', function () {
		qodefSwiper.init();
	});

	$(window).resize(function () {
		qodef.windowWidth = $(window).width();
		qodef.windowHeight = $(window).height();
	});

	$(window).scroll(function () {
		qodef.scroll = $(window).scrollTop();
	});

	$(document).on('roisin_trigger_get_new_posts', function () {
		qodefSwiper.init();
		qodefMagnificPopup.init();
	});

	/*
	 * Browser detection functionality
	 */
	var qodefBrowserDetection = {
		init: function () {
			qodefBrowserDetection.addBodyClassName();
		},
		isBrowser: function (name) {
			var isBrowser = false;

			switch (name) {
				case 'chrome':
					isBrowser = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
					break;
				case 'safari':
					isBrowser = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
					break;
				case 'firefox':
					isBrowser = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
					break;
				case 'ie':
					isBrowser = window.navigator.userAgent.indexOf("MSIE ") > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./);
					break;
				case 'edge':
					isBrowser = /Edge\/\d./i.test(navigator.userAgent);
					break;
			}

			return isBrowser;
		},
		addBodyClassName: function () {
			var browsers = [
				'chrome',
				'safari',
				'firefox',
				'ie',
				'edge',
			];

			$.each(browsers, function (key, value) {
				if (qodefBrowserDetection.isBrowser(value) && typeof qodef.body !== 'undefined') {
					if (value === 'ie') {
						value = 'ms-explorer';
					}

					qodef.body.addClass('qodef-browser--' + value);
				}
			});
		}
	};

	/**
	 * Init swiper slider
	 */
	var qodefSwiper = {
		init: function (settings) {
			this.holder = $('.qodef-swiper-container');

			// Allow overriding the default config
			$.extend(this.holder, settings);

			if (this.holder.length) {
				this.holder.each(function () {
					qodefSwiper.createSlider($(this));
				});
			}
		},
		createSlider: function ($holder) {
			var options = qodefSwiper.getOptions($holder),
				events = qodefSwiper.getEvents($holder, options);

			var $swiper = new Swiper($holder[0], Object.assign(options, events));
		},
		getOptions: function ($holder, returnBreakpoints) {
			var sliderOptions = typeof $holder.data('options') !== 'undefined' ? $holder.data('options') : {},
				spaceBetween = sliderOptions.spaceBetween !== undefined && sliderOptions.spaceBetween !== '' ? sliderOptions.spaceBetween : 0,
				slidesPerView = sliderOptions.slidesPerView !== undefined && sliderOptions.slidesPerView !== '' ? sliderOptions.slidesPerView : 1,
				centeredSlides = sliderOptions.centeredSlides !== undefined && sliderOptions.centeredSlides !== '' ? sliderOptions.centeredSlides : false,
				sliderScroll = sliderOptions.sliderScroll !== undefined && sliderOptions.sliderScroll !== '' ? sliderOptions.sliderScroll : false,
				sliderCentering = sliderOptions.sliderCentering !== undefined && sliderOptions.sliderCentering !== '' ? sliderOptions.sliderCentering : false,
				loop = sliderOptions.loop !== undefined && sliderOptions.loop !== '' ? sliderOptions.loop : true,
				autoplay = sliderOptions.autoplay !== undefined && sliderOptions.autoplay !== '' ? sliderOptions.autoplay : true,
				speed = sliderOptions.speed !== undefined && sliderOptions.speed !== '' ? parseInt(sliderOptions.speed, 10) : 5000,
				speedAnimation = sliderOptions.speedAnimation !== undefined && sliderOptions.speedAnimation !== '' ? parseInt(sliderOptions.speedAnimation, 10) : 800,
				customStages = sliderOptions.customStages !== undefined && sliderOptions.customStages !== '' ? sliderOptions.customStages : false,
				outsideNavigation = sliderOptions.outsideNavigation !== undefined && sliderOptions.outsideNavigation === 'yes',
				nextNavigation    = outsideNavigation ? '.swiper-button-next-' + sliderOptions.unique : ($holder.children( '.swiper-button-next' ).length ? $holder.children( '.swiper-button-next' )[0] : null),
				prevNavigation    = outsideNavigation ? '.swiper-button-prev-' + sliderOptions.unique : ($holder.children( '.swiper-button-prev' ).length ? $holder.children( '.swiper-button-prev' )[0] : null),
				pagination        = $holder.children( '.swiper-pagination' ).length ? $holder.children( '.swiper-pagination' )[0] : null;

			if ( true === autoplay ) {
				autoplay = {
					disableOnInteraction: false,
				}

				if ( 5000 !== speed ) {
					autoplay.delay = speed;
				}
			}

			var slidesPerView1440 = sliderOptions.slidesPerView1440 !== undefined && sliderOptions.slidesPerView1440 !== '' ? sliderOptions.slidesPerView1440 : 5,
				slidesPerView1366 = sliderOptions.slidesPerView1366 !== undefined && sliderOptions.slidesPerView1366 !== '' ? sliderOptions.slidesPerView1366 : 4,
				slidesPerView1024 = sliderOptions.slidesPerView1024 !== undefined && sliderOptions.slidesPerView1024 !== '' ? sliderOptions.slidesPerView1024 : 3,
				slidesPerView768 = sliderOptions.slidesPerView768 !== undefined && sliderOptions.slidesPerView768 !== '' ? sliderOptions.slidesPerView768 : 2,
				slidesPerView680 = sliderOptions.slidesPerView680 !== undefined && sliderOptions.slidesPerView680 !== '' ? sliderOptions.slidesPerView680 : 1,
				slidesPerView480 = sliderOptions.slidesPerView480 !== undefined && sliderOptions.slidesPerView480 !== '' ? sliderOptions.slidesPerView480 : 1;

			if (!customStages) {
				if (slidesPerView < 2) {
					slidesPerView1440 = slidesPerView;
					slidesPerView1366 = slidesPerView;
					slidesPerView1024 = slidesPerView;
					slidesPerView768 = slidesPerView;
				} else if (slidesPerView < 3) {
					slidesPerView1440 = slidesPerView;
					slidesPerView1366 = slidesPerView;
					slidesPerView1024 = slidesPerView;
				} else if (slidesPerView < 4) {
					slidesPerView1440 = slidesPerView;
					slidesPerView1366 = slidesPerView;
				} else if (slidesPerView < 5) {
					slidesPerView1440 = slidesPerView;
				}
			}

			if (slidesPerView === 'auto') {
				slidesPerView1440 = 'auto';
				slidesPerView1366 = 'auto';
				slidesPerView1024 = 'auto';
			}

			var options = {
				slidesPerView: slidesPerView,
				centeredSlides: centeredSlides,
				sliderCentering: sliderCentering,
				sliderScroll: sliderScroll,
				spaceBetween: spaceBetween,
				autoplay: autoplay,
				loop: loop,
				speed: speedAnimation,
				navigation: { nextEl: nextNavigation, prevEl: prevNavigation },
				pagination: { el: pagination, type: 'bullets', clickable: true },
				breakpoints: {
					// when window width is < 481px
					0: {
						slidesPerView: slidesPerView480
					},
					// when window width is >= 481px
					481: {
						slidesPerView: slidesPerView680,
						spaceBetween: 0
					},
					// when window width is >= 681px
					681: {
						slidesPerView: slidesPerView768,
						centeredSlides: false
					},
					// when window width is >= 769px
					769: {
						slidesPerView: slidesPerView1024
					},
					// when window width is >= 1025px
					1025: {
						slidesPerView: slidesPerView1366
					},
					// when window width is >= 1367px
					1367: {
						slidesPerView: slidesPerView1440
					},
					// when window width is >= 1441px
					1441: {
						slidesPerView: slidesPerView
					}
				},
			};

			return Object.assign(options, qodefSwiper.getSliderDatas($holder));
		},
		getSliderDatas: function ($holder) {
			var dataList = $holder.data(),
				returnValue = {};

			for (var property in dataList) {
				if (dataList.hasOwnProperty(property)) {
					// It's required to be different from data options because da options are all options from shortcode element
					if (property !== 'options' && typeof dataList[property] !== 'undefined' && dataList[property] !== '') {
						returnValue[property] = dataList[property];
					}
				}
			}

			return returnValue;
		},
		getEvents: function ($holder, options) {
			return {
				on: {
					init: function () {
						$holder.addClass('qodef-swiper--initialized');
						// Item click centering
						setTimeout(function () {
							if (options.sliderCentering) {
								$holder.on('click', '.swiper-slide', function (e) {
									if (!($(this).hasClass('swiper-slide-active'))) {
										e.preventDefault();
										e.stopPropagation();

										if ($(this).hasClass('swiper-slide-next')) {
											$holder[0].swiper.slideNext();
										} else if ($(this).hasClass('swiper-slide-prev')) {
											$holder[0].swiper.slidePrev();
										}
									}
								});
							}
						}, 300);

						if (options.sliderScroll) {
							var scrollStart = false;

							$holder.on('mousewheel', function (e) {
								e.preventDefault();
								if (!scrollStart) {
									scrollStart = true;

									if (e.deltaY < 0) {
										$holder[0].swiper.slideNext();
									} else {
										$holder[0].swiper.slidePrev();
									}

									setTimeout(function () {
										scrollStart = false;
									}, 1500)
								}
							});
						}
					}
				}
			};
		}
	};

	qodef.qodefSwiper = qodefSwiper;

	/**
	 * Close Cursor SVG (for full screen menu and search)
	 */
	var qodefCloseCursor = {
		init: function () {
			var $areas = $('.qodef-fullscreen-menu-overlay, .qodef-fullscreen-search-menu-overlay');

			if ($areas.length && qodef.windowWidth > 1024) {
				qodef.body.append('<div class="qodef-svg-close-cursor"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" width="27.094px" height="27.281px" viewBox="0 0 27.094 27.281" enable-background="new 0 0 27.094 27.281" xml:space="preserve"><line fill="none" stroke="#000000" stroke-miterlimit="10" x1="2" y1="2" x2="25" y2="25"/><line fill="none" stroke="#000000" stroke-miterlimit="10" x1="25" y1="2" x2="2" y2="25"/></svg></div>');
				var posX, posY;
				var svgCloseCursor = $('.qodef-svg-close-cursor');
				$(document).on('mousemove', function (e) {
					posX = e.clientX;
					posY = e.clientY;

					svgCloseCursor.css({
						'top': posY,
						'left': posX
					});
				});

				$areas.on('mouseenter', function () {
					svgCloseCursor.css('opacity', 1);
				}).on('mouseout', function () {
					svgCloseCursor.css('opacity', 0);
				});
			}
		}
	}

	var qodefUncoveringRowLanding = {
		init: function () {
			var uncoveringRow = $('.qodef-uncovering-row-landing');

			if (uncoveringRow.length) {
				var closestContent = uncoveringRow.parent(),
					closestContentClasses = closestContent.attr('class'),
					uncoveringRowHeight = uncoveringRow.outerHeight(),
					bgImgUrl = $('body').css('background-image');

				closestContent.removeClass( closestContentClasses );
				closestContent.parent().addClass(closestContentClasses).append(uncoveringRow);
				closestContent.css({
					'position': 'relative',
					'z-index': '12',
					'margin-bottom': uncoveringRowHeight + 'px',
					'background-image': bgImgUrl,
					'background-repeat': 'no-repeat',
					'background-size': 'contain',
					'background-color': '#fff'
				});
				$('body').css('background-image', 'none');
				uncoveringRow.css({
					'position': 'fixed',
					'width': '100vw',
					'bottom': '0',
					'left': '0'
				});
				if (qodef.body.hasClass('qodef-browser--safari')) {
					uncoveringRow.css({
						'position': 'absolute'
					});
				}
			}
		}
	}

	qodef.qodefAnimateVerticalText = qodefAnimateVerticalText;

	/**
	 * Vertical Text Animation
	 */
	var qodefAnimateVerticalText = {
		init: function () {
			var $holder = $('.qodef-m-vertical-text > span');

			if ($holder.length) {
				$holder.each(function () {
					var $thisHolder = $(this);

					$thisHolder.appear(function () {
						qodefAnimateVerticalText.animateVerticalText($thisHolder, 0);
					}, { accX: 0, accY: 0 })
				});
			}
		},
		animateVerticalText: function (textEl, appearDelay) {
			var thisVerticalText = textEl.text(),
				thisVerticalTextArray = thisVerticalText.split(''),
				thisVerticalTextArrayLength = thisVerticalTextArray.length - 1;

			textEl.empty();

			thisVerticalTextArray.forEach(function (item) {
				textEl.append('<span>' + item + '</span>')
			});

			textEl.css('opacity', 1);

			setTimeout(function () {
				textEl.find('span').each(function (i) {
					var $thisSpan = $(this);
					setTimeout(function () {
						$thisSpan.addClass('qodef--show');
						if (i === thisVerticalTextArrayLength) {
							textEl.parent().addClass('qodef--animate-line');
						}
					}, i * 30);
				})
			}, appearDelay);
		}
	}

	qodef.qodefAnimateVerticalText = qodefAnimateVerticalText;

	/**
	 * Init magnific popup galleries
	 */
	var qodefMagnificPopup = {
		init: function (settings) {
			this.holder = $('.qodef-magnific-popup');

			// Allow overriding the default config
			$.extend(this.holder, settings);

			if (this.holder.length) {
				this.holder.each(function () {
					var $thisPopup = $(this);

					if ($thisPopup.hasClass('qodef-popup-item')) {
						qodefMagnificPopup.initSingleImagePopup($thisPopup);
					} else if ($thisPopup.hasClass('qodef-popup-gallery')) {
						qodefMagnificPopup.initGalleryPopup($thisPopup);
					}
				});
			}
		},
		initSingleImagePopup: function ($popup) {
			var type = $popup.data('type');

			$popup.magnificPopup({
				type: type,
				titleSrc: 'title',
				image: {
					cursor: null
				}
			});
		},
		initGalleryPopup: function ($popup) {
			var $items = $popup.find('.qodef-popup-item'),
				itemsFormatted = qodefMagnificPopup.generateGalleryItems($items);

			$items.each(function (index) {
				var $this = $(this);
				$this.magnificPopup({
					items: itemsFormatted,
					gallery: {
						enabled: true,
					},
					index: index,
					type: 'image',
					image: {
						cursor: null
					}
				});
			});
		},
		generateGalleryItems: function ($items) {
			var itemsFormatted = [];

			if ($items.length) {
				$items.each(function () {
					var $thisItem = $(this);
					var itemFormatted = {
						src: $thisItem.attr('href'),
						title: $thisItem.attr('title'),
						type: $thisItem.data('type')
					};
					itemsFormatted.push(itemFormatted);
				});
			}

			return itemsFormatted;
		}
	};

	qodef.qodefMagnificPopup = qodefMagnificPopup;

})(jQuery);
(function ($) {
    "use strict";

    $(document).ready(function () {
        qodefResizeIframes.init();
        qodefBlogBoxedHover.init();
    });

    $(window).on('resize', function () {
        qodefResizeIframes.init();
    });

    $(document).on('roisin_trigger_get_new_posts', function (e, holder) {
        if (holder.hasClass('qodef-blog')) {
            qodefReInitMediaElementPostFormats.init(holder);
            qodefResizeIframes.resize(holder);
        }
    });

    /**
     * Re init media element post formats (audio, video)
     */
    var qodefReInitMediaElementPostFormats = {
        init: function (holder) {
            var $mediaElement = holder.find('.wp-video-shortcode, .wp-audio-shortcode').not('.mejs-container');

            if ($mediaElement.length) {
                $mediaElement.each(function () {
                    var $thisMediaElement = $(this);

                    if (typeof $thisMediaElement.mediaelementplayer === 'function') {
                        $thisMediaElement.mediaelementplayer();
                    }
                });
            }
        }
    };

    /**
     * Resize oembed iframes
     */
    var qodefResizeIframes = {
        init: function () {
            var $holder = $('.qodef-blog');

            if ($holder.length) {
                qodefResizeIframes.resize($holder);
            }
        },

        resize: function (holder) {
            var $iframe = holder.find('.qodef-e-media iframe');

            if ($iframe.length) {
                $iframe.each(function () {
                    var $thisIframe = $(this),
                        width = $thisIframe.attr('width'),
                        height = $thisIframe.attr('height'),
                        newHeight = $thisIframe.width() / width * height;  // rendered width divided by aspect ratio

                    $thisIframe.css('height', newHeight);
                });
            }
        }
    }

    
    /**
     * Resize oembed iframes
     */
    var qodefBlogBoxedHover = {
        init: function () {
            var $holder = $('.qodef-blog.qodef-item-layout--boxed');

            if ($holder.length) {
                $holder.each(function() {
                    var $thisHolder = $(this),
                        $thisHolderTitle = $thisHolder.find('.qodef-e-title');
                    
                    $thisHolderTitle.on('mouseenter', function() {
                        $(this).closest('article').addClass('qodef-e-hover--active');
                    }).on('mouseleave', function(){
                        $(this).closest('article').removeClass('qodef-e-hover--active');
                    });
                });
            }
        },
    }

})(jQuery);
(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefFilter.init();
		}
	);

	$( document ).on(
		'roisin_trigger_get_new_posts',
		function ( e, $holder ) {
			if ( $holder.hasClass( 'qodef-filter--on' ) ) {
				$holder.removeClass( 'qodef--filter-loading' );
			}
		}
	);

	/*
	 **	Init filter functionality
	 */
	var qodefFilter = {
		init: function ( settings ) {
			this.holder = $( '.qodef-filter--on' );

			// Allow overriding the default config.
			$.extend( this.holder, settings );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder         = $( this ),
							$filterItems    = $holder.find( '.qodef-m-filter-item' ),
							customListQuery = qodefFilter.checkCustomListQuery( $holder.data( 'options' ) );

						qodefFilter.clickEvent( $holder, $filterItems, customListQuery );
					}
				);
			}
		},
		checkCustomListQuery: function ( options ) {
			if ( typeof options.additional_query_args !== 'undefined' && typeof options.additional_query_args.tax_query !== 'undefined' ) {
				return options.additional_query_args.tax_query;
			}
		},
		clickEvent: function ( $holder, $filterItems, customListQuery ) {
			$filterItems.on(
				'click',
				function ( e ) {
					e.preventDefault();

					var $thisItem = $( this );

					if ( ! $thisItem.hasClass( 'qodef--active' ) ) {
						$holder.addClass( 'qodef--filter-loading' );
						$filterItems.removeClass( 'qodef--active' );
						$thisItem.addClass( 'qodef--active' );

						qodefFilter.setVisibility( $holder, $thisItem, customListQuery );
					}
				}
			);
		},
		setVisibility: function ( $holder, $item, customListQuery ) {
			var filterTaxonomy  = $item.data( 'taxonomy' ),
				filterValue     = $item.data( 'filter' ),
				isShowAllFilter = filterValue === '*',
				options         = $holder.data( 'options' ),
				taxQueryOptions;

			if ( ! isShowAllFilter ) {
				taxQueryOptions = {
					0: {
						taxonomy: filterTaxonomy,
						field: typeof filterValue === 'number' ? 'term_id' : 'slug',
						terms: filterValue,
					},
				};
			} else {
				taxQueryOptions = customListQuery;
			}

			options.additional_query_args = {
				tax_query: taxQueryOptions,
			};

			qodef.body.trigger(
				'roisin_trigger_load_more',
				[$holder, 1]
			);
		},
		isMasonryLayout: function ( $holder ) {
			return $holder.hasClass( 'qodef-layout--masonry' );
		},
		hasLoadMore: function ( $holder ) {
			return $holder.hasClass( 'qodef-pagination-type--load-more' );
		}
	};

	qodef.qodefFilter = qodefFilter;

})( jQuery );

(function ($) {
	'use strict';

	$(document).ready(function () {
		qodefJustifiedGallery.init();
	});

	$(document).on('roisin_trigger_get_new_posts', function () {
		qodefJustifiedGallery.init();
	});

	/**
	 * Init justified gallery functionality
	 */
	var qodefJustifiedGallery = {
		init: function () {
			var justifiedGallery = $('.qodef-layout--justified-gallery');
			if (justifiedGallery.length) {
				justifiedGallery.each(function () {
					var $gallery = $(this),
						galleryOptions = $gallery.data('options'),
						$galleryInner = $gallery.children('.qodef-grid-inner'),
						rowHeight = typeof galleryOptions.justified_gallery_row_height !== 'undefined' && galleryOptions.justified_gallery_row_height !== '' ? galleryOptions.justified_gallery_row_height : 150,
						maxRowHeight = typeof galleryOptions.justified_gallery_row_height_max !== 'undefined' && galleryOptions.justified_gallery_row_height_max !== '' ? galleryOptions.justified_gallery_row_height_max : false,
						margin = galleryOptions.space_value * 2,
						justifyTreshold = typeof galleryOptions.justified_gallery_treshold !== 'undefined' && galleryOptions.justified_gallery_treshold !== '' ? galleryOptions.justified_gallery_treshold : 0.75;

					$galleryInner.waitForImages(function () {
						if (typeof $galleryInner.justifiedGallery === 'function') {
							$galleryInner.justifiedGallery({
								captions: false,
								rowHeight: rowHeight,
								maxRowHeight: maxRowHeight,
								margins: margin,
								border: 0,
								lastRow: 'nojustify',
								justifyThreshold: justifyTreshold,
								selector: '.qodef-grid-item'
							}).on('jg.complete jg.rowflush', function () {
								var $gal = $(this),
									deducted = false;

								$gal.find('.qodef-grid-item').addClass('show').each(function () {
									var $thisItem = $(this);

									$thisItem.height(Math.round($thisItem.height()));

									if (!deducted && $thisItem.width() === 0) {
										$gal.height($gal.height() - $thisItem.height() - margin);

										deducted = true;
									}
								});
							});
						}

						$gallery.addClass('qodef--justified-gallery-init');
					});
				});
			}
		}
	};
	
	qodef.qodefJustifiedGallery = qodefJustifiedGallery;

})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefMasonryLayout.init();
	});
	
	$(document).on('roisin_trigger_get_new_posts', function (e, holder) {
		if (holder.hasClass('qodef-layout--masonry')) {
			qodefMasonryLayout.init();
		}
	});
	
	/**
	 * Init masonry layout
	 */
	var qodefMasonryLayout = {
		init: function (settings) {
			this.holder = $('.qodef-layout--masonry');
			
			// Allow overriding the default config
			$.extend(this.holder, settings);
			
			if (this.holder.length) {
				this.holder.each(function () {
					qodefMasonryLayout.createMasonry($(this));
				});
			}
		},
		createMasonry: function (holder) {
			var $masonry = holder.find('.qodef-grid-inner'),
				$masonryItem = $masonry.find('.qodef-grid-item'),
				size = $masonry.find('.qodef-grid-masonry-sizer').width();
			
			$masonry.waitForImages(function () {
				if (typeof $masonry.isotope === 'function') {
					$masonry.isotope({
						layoutMode: 'packery',
						itemSelector: '.qodef-grid-item',
						percentPosition: true,
						masonry: {
							columnWidth: '.qodef-grid-masonry-sizer',
							gutter: '.qodef-grid-masonry-gutter'
						}
					});
					
					if (holder.hasClass('qodef-items--fixed')) {
						qodefMasonryLayout.setFixedImageProportionSize($masonry, $masonryItem, size);
					}
					
					$masonry.isotope('layout');
				}
				
				$masonry.addClass('qodef--masonry-init');
			});
		},
		setFixedImageProportionSize: function (holder, item, size) {
			var padding = parseInt(item.css('paddingLeft'), 10),
				newSize = size - 2 * padding,
				$squareItem = holder.find('.qodef-item--square'),
				$landscapeItem = holder.find('.qodef-item--landscape'),
				$portraitItem = holder.find('.qodef-item--portrait'),
				$hugeSquareItem = holder.find('.qodef-item--huge-square');
			
			$squareItem.css('height', newSize);
			$portraitItem.css('height', Math.round(2 * (newSize + padding)));
			
			if (qodef.windowWidth > 680) {
				$landscapeItem.css('height', newSize);
				$hugeSquareItem.css('height', Math.round(2 * (newSize + padding)));
			} else {
				$landscapeItem.css('height', Math.round(newSize / 2));
				$hugeSquareItem.css('height', newSize);
			}
		}
	};
	
	qodef.qodefMasonryLayout = qodefMasonryLayout;
})(jQuery);
(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefMobileHeader.init();
	});
	
	/*
	 **	Init mobile header functionality
	 */
	var qodefMobileHeader = {
		init: function () {
			var $holder = $('#qodef-page-mobile-header');
			
			if ($holder.length) {
				qodefMobileHeader.initMobileHeaderOpener($holder);
				qodefMobileHeader.initDropDownMobileMenu();
			}
		},
		initMobileHeaderOpener: function (holder) {
			var $opener = holder.find('#qodef-mobile-header-opener');
		
			if ($opener.length) {
				var $navigation = holder.find('#qodef-mobile-header-navigation');
			
				$opener.on('tap click', function (e) {
					e.preventDefault();
					
					if ($navigation.is(':visible')) {
						$navigation.slideUp(450);
						$opener.removeClass('qodef--opened');
					} else {
						$navigation.slideDown(450);
						$opener.addClass('qodef--opened');
					}
				});
			}
		},
		initDropDownMobileMenu: function(){
            var $dropdownOpener = $('#qodef-mobile-header-navigation .qodef-menu-arrow, #qodef-mobile-header-navigation .qodef-hide-link > a, body:not([class*="roisin-core"]) #qodef-mobile-header-navigation .menu-item-has-children > a');

            if ($dropdownOpener.length) {
                $dropdownOpener.each(function () {
                    var $thisItem = $(this);

                    $thisItem.on('tap click', function (e) {
                    	e.preventDefault();
                    	
                        var $thisItemParent = $thisItem.parent(),
                            $thisItemParentSiblingsWithDrop = $thisItemParent.siblings('.menu-item-has-children');

                        if ($thisItemParent.hasClass('menu-item-has-children')) {
                            var $submenu = $thisItemParent.find('ul.sub-menu').first();

                            if ($submenu.is(':visible')) {
                                $submenu.slideUp(450);
                                $thisItemParent.removeClass('qodef--opened');
                            } else {
                                $thisItemParent.addClass('qodef--opened');

                                if ($thisItemParentSiblingsWithDrop.length === 0) {
                                    $thisItemParent.find('.sub-menu').slideUp(400, function () {
                                        $submenu.slideDown(400);
                                    });
                                } else {
                                    $thisItemParent.siblings().removeClass('qodef--opened').find('.sub-menu').slideUp(400, function () {
                                        $submenu.slideDown(400);
                                    });
                                }
                            }
                        }
                    });
                });
            }
		}
	};
	
})(jQuery);
(function ($) {
	
	$(document).ready(function () {
		qodefDefaultNavMenu.init();
	});
	
	var qodefDefaultNavMenu = {
		init: function () {
			var $menuItems = $('.qodef-header-navigation.qodef-header-navigation-initial > ul > li.qodef-menu-item--narrow.menu-item-has-children');
			
			if ($menuItems.length) {
				$menuItems.each(function (i) {
					var thisItem = $(this),
						menuItemPosition = thisItem.offset().left,
						dropdownMenuItem = thisItem.find(' > ul'),
						dropdownMenuWidth = dropdownMenuItem.outerWidth(),
						menuItemFromLeft = $(window).width() - menuItemPosition;

					var dropDownMenuFromLeft;
					
					if (thisItem.find('li.menu-item-has-children').length > 0) {
						dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
					}
					
					dropdownMenuItem.removeClass('qodef-drop-down--right');
					
					if (menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth) {
						dropdownMenuItem.addClass('qodef-drop-down--right');
					}
				});
			}
		}
	};
	
})(jQuery);

(function ($) {
	"use strict";
	
	$(document).ready(function () {
		qodefPagination.init();
	});
	
	$(window).scroll(function () {
		qodefPagination.scroll();
	});
	
	$(document).on('roisin_trigger_load_more', function (e, $holder, nextPage) {
		qodefPagination.triggerLoadMore($holder, nextPage);
	});
	
	/*
	 **	Init pagination functionality
	 */
	var qodefPagination = {
		init: function (settings) {
			this.holder = $('.qodef-pagination--on');
			
			// Allow overriding the default config
			$.extend(this.holder, settings);
			
			if (this.holder.length) {
				this.holder.each(function () {
					var $holder = $(this);
					
					qodefPagination.initPaginationType($holder);
				});
			}
		},
		scroll: function (settings) {
			this.holder = $('.qodef-pagination--on');
			
			// Allow overriding the default config
			$.extend(this.holder, settings);
			
			if (this.holder.length) {
				this.holder.each(function () {
					var $holder = $(this);
					
					if ($holder.hasClass('qodef-pagination-type--infinite-scroll')) {
						qodefPagination.initInfiniteScroll($holder);
					}
				});
			}
		},
		initPaginationType: function ($holder) {
			if ($holder.hasClass('qodef-pagination-type--standard')) {
				qodefPagination.initStandard($holder);
			} else if ($holder.hasClass('qodef-pagination-type--load-more')) {
				qodefPagination.initLoadMore($holder);
			} else if ($holder.hasClass('qodef-pagination-type--infinite-scroll')) {
				qodefPagination.initInfiniteScroll($holder);
			}
		},
		initStandard: function ($holder) {
			var $paginationItems = $holder.find('.qodef-m-pagination-items');
			
			if ($paginationItems.length) {
				var options = $holder.data('options');
				
				$paginationItems.children().each(function () {
					var $thisItem = $(this),
						$itemLink = $thisItem.children('a');
					
					qodefPagination.changeStandardState($holder, options.max_pages_num, 1);
					
					$itemLink.on('click', function (e) {
						e.preventDefault();
						
						if (!$thisItem.hasClass('qodef--active')) {
							qodefPagination.getNewPosts($holder, $itemLink.data('paged'));
						}
					});
				});
			}
		},
		changeStandardState: function ($holder, max_pages_num, nextPage) {
			if ($holder.hasClass('qodef-pagination-type--standard')) {
				var $paginationNav = $holder.find('.qodef-m-pagination-items'),
					$numericItem = $paginationNav.children('.qodef--number'),
					$prevItem = $paginationNav.children('.qodef--prev'),
					$nextItem = $paginationNav.children('.qodef--next');
				
				$numericItem.removeClass('qodef--active').eq(nextPage - 1).addClass('qodef--active');
				
				$prevItem.children().data('paged', nextPage - 1);
				
				if (nextPage > 1) {
					$prevItem.show();
				} else {
					$prevItem.hide();
				}
				
				$nextItem.children().data('paged', nextPage + 1);
				
				if (nextPage === max_pages_num) {
					$nextItem.hide();
				} else {
					$nextItem.show();
				}
			}
		},
		initLoadMore: function ($holder) {
			var $loadMoreButton = $holder.find('.qodef-load-more-button');
			
			$loadMoreButton.on('click', function (e) {
				e.preventDefault();
				
				qodefPagination.getNewPosts($holder);
			});
		},
		triggerLoadMore: function ($holder, nextPage) {
			qodefPagination.getNewPosts($holder, nextPage);
		},
		hideLoadMoreButton: function ($holder, options) {
			if ($holder.hasClass('qodef-pagination-type--load-more') && options.next_page > options.max_pages_num) {
				$holder.find('.qodef-load-more-button').hide();
			}
		},
		initInfiniteScroll: function ($holder) {
			var holderEndPosition = $holder.outerHeight() + $holder.offset().top,
				scrollPosition = qodef.scroll + qodef.windowHeight,
				options = $holder.data('options');
			
			if (!$holder.hasClass('qodef--loading') && scrollPosition > holderEndPosition && options.max_pages_num >= options.next_page) {
				qodefPagination.getNewPosts($holder);
			}
		},
		getNewPosts: function ($holder, nextPage) {
			$holder.addClass('qodef--loading');
			
			var $itemsHolder = $holder.children('.qodef-grid-inner');
			var options = $holder.data('options');
			
			qodefPagination.setNextPageValue(options, nextPage, false);

			$.ajax({
				type: "GET",
				url: qodefGlobal.vars.restUrl + qodefGlobal.vars.paginationRestRoute,
				data: {
					options: options
				},
				beforeSend: function( request ) {
					request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
				},
				success: function (response) {
					
					if (response.status === 'success') {
						qodefPagination.setNextPageValue(options, nextPage, true);
						qodefPagination.changeStandardState($holder, options.max_pages_num, nextPage);
						
						$itemsHolder.waitForImages(function () {
							qodefPagination.addPosts($itemsHolder, response.data.html, nextPage);
							qodefPagination.reInitMasonryPosts($holder, $itemsHolder);
							
							qodef.body.trigger('roisin_trigger_get_new_posts', [$holder, response.data, nextPage]);
						});
						qodefPagination.hideLoadMoreButton($holder, options);
						$('html, body').animate({
							scrollTop: $holder.offset().top - 100
						}, 500);
					} else {
						console.log(response.message);
					}
				},
				complete: function () {
					$holder.removeClass('qodef--loading');
				}
			});
		},
		setNextPageValue: function (options, nextPage, ajaxTrigger) {
			if (typeof nextPage !== 'undefined' && nextPage !== '' && !ajaxTrigger) {
				options.next_page = nextPage;
			} else if (ajaxTrigger) {
				options.next_page = parseInt(options.next_page, 10) + 1;
			}
		},
		addPosts: function ($itemsHolder, newItems, nextPage) {
			if (typeof nextPage !== 'undefined' && nextPage !== '') {
				$itemsHolder.html(newItems);
			} else {
				$itemsHolder.append(newItems);
			}
		},
		reInitMasonryPosts: function ($holder, $itemsHolder) {
			if ($holder.hasClass('qodef-layout--masonry')) {
				$itemsHolder.isotope('reloadItems').isotope({sortBy: 'original-order'});
				
				setTimeout(function () {
					$itemsHolder.isotope('layout');
				}, 200);
			}
		}
	};
	
	qodef.qodefPagination = qodefPagination;
	
})(jQuery);
(function ($) {
	"use strict";

	$(document).ready(function () {
		qodefWooSelect2.init();
		qodefWooQuantityButtons.init();
		qodefWooMagnificPopup.init();
		qodefOrderingFilter.init();
	});

	var qodefOrderingFilter = {
		init: function (settings) {
			this.holder = $('.qodef--order-filter');

			if (this.holder.length) {
				this.holder.each(function () {
					var $holder = $(this),
						$filterItems = $holder.find('.qodef-m-ordering-order button'),
						$filterItemsPrice = $holder.find('.qodef-m-ordering-price a');

					qodefOrderingFilter.triggerEvent($holder, $filterItems);
					qodefOrderingFilter.triggerPriceEvent($holder, $filterItemsPrice);
				});
			}
		},
		triggerEvent: function (holder, filterItems) {
			filterItems.on('click', function (e) {
				e.preventDefault();

				var $thisItem = $(this),
					options = holder.data('options');

				options.next_page = 1;
				options.orderby = $thisItem.val();

				holder.data('options', options);

				qodef.body.trigger('roisin_trigger_load_more', [holder, options.next_page]);
			});
		},
		triggerPriceEvent: function (holder, filterItems) {
			filterItems.each(function () {

				$(this).on('click', function (e) {
					e.preventDefault();

					var $thisItem = $(this),
						options = holder.data('options'),
						minPrice = $thisItem.data('minprice'),
						maxPrice = $thisItem.data('maxprice');

					options.next_page = 1;

					if (minPrice !== '') {

						options.additional_query_args = {};
						options.additional_query_args.meta_query = {};
						options.additional_query_args.meta_query[0] = {
							'key': '_price',
							'value': [minPrice, maxPrice],
							'compare': 'BETWEEN',
							'type': 'NUMERIC'
						};
					} else {
						options.additional_query_args = {};
					}

					holder.data('options', options);

					qodef.body.trigger('roisin_trigger_load_more', [holder, options.next_page]);
				});
			});
		}
	}

	var qodefWooSelect2 = {
		init: function (settings) {
			this.holder = [];
			this.holder.push({ holder: $('#qodef-woo-page .woocommerce-ordering select'), options: { minimumResultsForSearch: Infinity } });
			this.holder.push({ holder: $('#qodef-woo-page .variations select'), options: {} });
			this.holder.push({ holder: $('#qodef-woo-page #calc_shipping_country'), options: {} });
			this.holder.push({ holder: $('#qodef-woo-page .shipping select#calc_shipping_state'), options: {} });
			this.holder.push({ holder: $('.widget.widget_archive select'), options: {} });
			this.holder.push({ holder: $('.widget.widget_categories select'), options: {} });
			this.holder.push({ holder: $('.widget.widget_text select'), options: {} });
			this.holder.push({ holder: $('.qodef-m-ordering select'), options: {} });

			// Allow overriding the default config
			$.extend(this.holder, settings);

			if (typeof this.holder === 'object') {
				$.each(this.holder, function (key, value) {
					qodefWooSelect2.createSelect2(value.holder, value.options);
				});
			}
		},
		createSelect2: function ($holder, options) {
			if (typeof $holder.select2 === 'function') {
				$holder.select2(options);
			}
		}
	};

	var qodefWooQuantityButtons = {
		init: function () {
			$(document).on('click', '.qodef-quantity-minus, .qodef-quantity-plus', function (e) {
				e.stopPropagation();

				var $button = $(this),
					$inputField = $button.siblings('.qodef-quantity-input'),
					step = parseFloat($inputField.data('step')),
					max = parseFloat($inputField.data('max')),
					minus = false,
					inputValue = typeof Number.isNaN === 'function' && Number.isNaN(parseFloat($inputField.val())) ? min : parseFloat($inputField.val()),
					newInputValue;

				if ($button.hasClass('qodef-quantity-minus')) {
					minus = true;
				}

				if (minus) {
					newInputValue = inputValue - step;
					if (newInputValue >= 1) {
						$inputField.val(newInputValue);
					} else {
						$inputField.val(0);
					}
				} else {
					newInputValue = inputValue + step;
					if (max === undefined) {
						$inputField.val(newInputValue);
					} else {
						if (newInputValue >= max) {
							$inputField.val(max);
						} else {
							$inputField.val(newInputValue);
						}
					}
				}

				$inputField.trigger('change');
			});
		}
	};

	var qodefWooMagnificPopup = {
		init: function () {
			if (typeof qodef.qodefMagnificPopup === 'object') {
				var $holder = $('.qodef--single.qodef-magnific-popup.qodef-popup-gallery .woocommerce-product-gallery__image');

				if ($holder.length) {
					$holder.each(function () {
						$(this).children('a').attr('data-type', 'image').addClass('qodef-popup-item');
					});

					qodef.qodefMagnificPopup.init();
				}
			}
		}
	}

})(jQuery);
