<?php
$quote_meta = get_post_meta( get_the_ID(), 'qodef_post_format_quote_text', true );
$quote_text = ! empty( $quote_meta ) ? $quote_meta : get_the_title();

if ( ! empty( $quote_text ) ) {
	$quote_author     = get_post_meta( get_the_ID(), 'qodef_post_format_quote_author', true );
	$title_tag        = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h4';
	$author_title_tag = isset( $author_title_tag ) && ! empty( $author_title_tag ) ? $author_title_tag : 'span';
	?>
	<div class="qodef-e-quote">
        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="29.875px" height="26.25px" viewBox="0 0 29.875 26.25" enable-background="new 0 0 29.875 26.25" xml:space="preserve"><g><path fill="none" stroke="#000000" d="M6.709,1.218c0.556,0,1.147,0.141,1.774,0.417L8.378,1.531l0.626,0.313h0.104 c0.208,0.141,0.452,0.313,0.73,0.522c0,0.07,0.104,0.208,0.313,0.417c1.738,1.74,2.468,4.349,2.191,7.826 c-0.279,5.009-2.922,9.532-7.931,13.566c-0.279,0.278-0.592,0.417-0.939,0.417c-0.558,0-1.009-0.243-1.356-0.73 c-0.626-0.835-0.521-1.6,0.313-2.296c4.104-3.339,6.33-6.955,6.679-10.853c-0.767,0.487-1.565,0.73-2.4,0.73 c-1.323,0-2.471-0.504-3.444-1.513C2.29,8.924,1.804,7.724,1.804,6.331c0-1.391,0.486-2.591,1.461-3.6 C4.238,1.724,5.386,1.218,6.709,1.218z M22.883,1.218c0.556,0,1.148,0.141,1.774,0.417l-0.104-0.104 c0.208,0.07,0.417,0.175,0.626,0.313h0.104c0.277,0.141,0.521,0.313,0.73,0.522c0,0.07,0.104,0.208,0.313,0.417 c1.738,1.74,2.468,4.349,2.191,7.826c-0.279,5.009-2.922,9.532-7.931,13.566c-0.279,0.278-0.592,0.417-0.939,0.417 c-0.558,0-0.975-0.243-1.252-0.73c-0.696-0.835-0.626-1.6,0.208-2.296c4.104-3.339,6.33-6.955,6.679-10.853 c-0.767,0.487-1.565,0.73-2.4,0.73c-1.322,0-2.47-0.504-3.443-1.513c-0.976-1.008-1.461-2.208-1.461-3.601 c0-1.391,0.485-2.591,1.461-3.6C20.413,1.724,21.561,1.218,22.883,1.218z"/></g></svg>
		<<?php echo roisin_escape_title_tag( $title_tag ); ?> class="qodef-e-quote-text"><?php echo esc_html( $quote_text ); ?></<?php echo roisin_escape_title_tag( $title_tag ); ?>>
		<?php if ( ! empty( $quote_author ) ) { ?>
			<<?php echo roisin_escape_title_tag( $author_title_tag ); ?> class="qodef-e-quote-author"><?php echo esc_html( $quote_author ); ?></<?php echo roisin_escape_title_tag( $author_title_tag ); ?>>
		<?php } ?>
		<?php if ( ! is_single() ) { ?>
			<a itemprop="url" class="qodef-e-quote-url" href="<?php the_permalink(); ?>"></a>
		<?php } ?>
	</div>
<?php } ?>