<?php

if ( ! function_exists( 'roisin_include_comments_in_templates' ) ) {
	/**
	 * Function which includes comments templates on pages/posts
	 */
	function roisin_include_comments_in_templates() {
		
		// Include comments template
		comments_template();
	}
	
	add_action( 'roisin_action_after_page_content', 'roisin_include_comments_in_templates', 100 ); // permission 100 is set to comments template be at the last place
	add_action( 'roisin_action_after_blog_post_item', 'roisin_include_comments_in_templates', 100 );
}

if ( ! function_exists( 'roisin_is_page_comments_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 */
	function roisin_is_page_comments_enabled() {
		$is_enabled = apply_filters( 'roisin_filter_enable_page_comments', true );
		
		return $is_enabled;
	}
}

if ( ! function_exists( 'roisin_load_page_comments' ) ) {
	/**
	 * Function which loads page template module
	 */
	function roisin_load_page_comments() {
		
		if ( roisin_is_page_comments_enabled() ) {
			roisin_template_part( 'comments', 'templates/comments' );
		}
	}
	
	add_action( 'roisin_action_page_comments_template', 'roisin_load_page_comments' );
}

if ( ! function_exists( 'roisin_get_comments_list_template' ) ) {
	/**
	 * Function which modify default WordPress comments list template
	 *
	 * @param $comment object
	 * @param $args array
	 * @param $depth int
	 *
	 * @return string that contains comments list html
	 */
	function roisin_get_comments_list_template( $comment, $args, $depth ) {
		global $post;
		$GLOBALS['comment'] = $comment;
		
		$classes = array();
		
		$is_author_comment = $post->post_author == $comment->user_id;
		if ( $is_author_comment ) {
			$classes[] = 'qodef-comment--author';
		}
		
		$is_specific_comment = $comment->comment_type == 'pingback' || $comment->comment_type == 'trackback';
		if ( $is_specific_comment ) {
			$classes[] = 'qodef-comment--no-avatar';
			$classes[] = 'qodef-comment--' . esc_attr( $comment->comment_type );
		}

		if ( ! function_exists( 'roisin_comment_time_ago' ) ) {

			function roisin_comment_time_ago() {
				return human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) ).' '.__( 'ago','roisin' );
			}
		}
		?>
		<li class="qodef-comment-item qodef-e <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="qodef-e-inner">
			<?php if ( ! $is_specific_comment ) { ?>
				<div class="qodef-e-image"><?php echo get_avatar( $comment, 88 ); ?></div>
			<?php } ?>
			<div class="qodef-e-content">
				<h5 class="qodef-e-title vcard"><?php echo sprintf( '<span class="fn">%s%s</span>', $is_specific_comment ? sprintf( '%s: ', esc_attr( ucwords( $comment->comment_type ) ) ) : '', get_comment_author_link() ); ?></h5>
				<div class="qodef-e-date commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment, $args ) ); ?>"><?php echo roisin_comment_time_ago()?></a></div>
                <div class="qodef-e-links">
					<?php
					comment_reply_link( array_merge( $args, array(
						'reply_text' => esc_html__( 'Reply', 'roisin' ),
						'depth'      => $depth,
						'max_depth'  => $args['max_depth']
					) ) );

					edit_comment_link( esc_html__( 'Edit', 'roisin' ) ); ?>
                </div>
				<?php if ( ! $is_specific_comment ) { ?>
					<p class="qodef-e-text"><?php comment_text(); ?></p>
				<?php } ?>

			</div>
		</div>
		<?php //li tag will be closed by WordPress after looping through child elements ?>
		<?php
	}
}