<?php

if ( ! function_exists( 'roisin_register_masonry_scripts' ) ) {
	/**
	 * Function that include modules 3rd party scripts
	 */
	function roisin_register_masonry_scripts() {
		wp_register_script( 'isotope', ROISIN_INC_ROOT . '/masonry/assets/js/plugins/isotope.pkgd.min.js', array( 'jquery' ), false, true );
		wp_register_script( 'packery', ROISIN_INC_ROOT . '/masonry/assets/js/plugins/packery-mode.pkgd.min.js', array( 'jquery' ), false, true );
	}

	add_action( 'roisin_action_before_main_js', 'roisin_register_masonry_scripts' );
}

if ( ! function_exists( 'roisin_include_masonry_scripts' ) ) {
	/**
	 * Function that include modules 3rd party scripts
	 */
	function roisin_include_masonry_scripts() {
		wp_enqueue_script( 'isotope' );
		wp_enqueue_script( 'packery' );
	}
}

if ( ! function_exists( 'roisin_enqueue_masonry_scripts_for_templates' ) ) {
	/**
	 * Function that enqueue modules 3rd party scripts for templates
	 */
	function roisin_enqueue_masonry_scripts_for_templates() {
		$post_type = apply_filters( 'roisin_filter_allowed_post_type_to_enqueue_masonry_scripts', '' );

		if ( ! empty( $post_type ) && is_singular( $post_type ) ) {
			roisin_include_masonry_scripts();
		}
	}

	add_action( 'roisin_action_before_main_js', 'roisin_enqueue_masonry_scripts_for_templates' );
}

if ( ! function_exists( 'roisin_enqueue_masonry_scripts_for_shortcodes' ) ) {
	/**
	 * Function that enqueue modules 3rd party scripts for shortcodes
	 *
	 * @param $atts array
	 */
	function roisin_enqueue_masonry_scripts_for_shortcodes( $atts ) {

		if ( isset( $atts['behavior'] ) && $atts['behavior'] == 'masonry' ) {
			roisin_include_masonry_scripts();
		}
	}

	add_action( 'roisin_core_action_list_shortcodes_load_assets', 'roisin_enqueue_masonry_scripts_for_shortcodes' );
}

if ( ! function_exists( 'roisin_register_masonry_scripts_for_list_shortcodes' ) ) {
	/**
	 * Function that add masonry scripts to array
	 *
	 * @param array $scripts
	 *
	 * @return array
	 */
	function roisin_register_masonry_scripts_for_list_shortcodes( $scripts ) {

		$scripts['isotope'] = array(
			'registered' => true,
		);
		$scripts['packery'] = array(
			'registered' => true,
		);

		return $scripts;
	}

	add_filter( 'roisin_core_filter_register_list_shortcode_scripts', 'roisin_register_masonry_scripts_for_list_shortcodes' );
}
