<?php

if ( ! function_exists( 'roisin_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function roisin_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'roisin_filter_mobile_header_template', roisin_get_template_part( 'mobile-header', 'templates/mobile-header' ) );
	}
	
	add_action( 'roisin_action_page_header_template', 'roisin_load_page_mobile_header' );
}

if ( ! function_exists( 'roisin_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function roisin_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'roisin_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'roisin' ) ) );
		
		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}
	
	add_action( 'roisin_action_after_include_modules', 'roisin_register_mobile_navigation_menus' );
}