<?php

if ( ! function_exists( 'roisin_core_add_blog_list_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_blog_list_widget( $widgets ) {
		$widgets[] = 'RoisinCoreBlogListWidget';
		
		return $widgets;
	}
	
	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_blog_list_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreBlogListWidget extends QodeFrameworkWidget {
		
		public function map_widget() {
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'roisin-core' )
				)
			);
			$widget_mapped = $this->import_shortcode_options( array(
				'shortcode_base' => 'roisin_core_blog_list'
			) );
			
			if ( $widget_mapped ) {
				$this->set_base( 'roisin_core_blog_list' );
				$this->set_name( esc_html__( 'Roisin Blog List', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Display a list of blog posts', 'roisin-core' ) );
			}
		}
		
		public function render( $atts ) {
			$params = $this->generate_string_params( $atts );
			
			echo do_shortcode( "[roisin_core_blog_list $params]" ); // XSS OK
		}
	}
}
