<?php

if ( ! function_exists( 'roisin_core_content_side_options' ) ) {
	function roisin_core_content_side_options() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope'       => ROISIN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'content-side',
				'icon'        => 'fa fa-indent',
				'title'       => esc_html__( 'Content Side', 'roisin-core' ),
				'description' => esc_html__( 'Content Side Settings', 'roisin-core' )
			)
		);
		
		if ( $page ) {
			
			$page->add_field_element(
				array(
					'name'          => 'qodef_enable_content_side_left_area',
					'field_type'    => 'yesno',
					'default_value' => 'no',
					'title'         => esc_html__( 'Enable Content Side Left Area', 'roisin-core' ),
					'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'roisin-core' ),
				)
			);
		}
	}
	
	add_action( 'roisin_core_action_default_options_init', 'roisin_core_content_side_options', roisin_core_get_admin_options_map_position( 'content-side' ) );
}