<?php

if ( ! function_exists( 'roisin_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function roisin_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope'       => ROISIN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'roisin-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'roisin-core' ),
				'icon'        => 'fa fa-cog'
			)
		);
		
		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'roisin-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts'
					)
				)
			);
			
			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'roisin-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => ''
							)
						)
					)
				)
			);
			
			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'roisin-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'roisin-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'roisin-core' )
				)
			);
			
			$page_repeater->add_field_element( array(
				'field_type'  => 'googlefont',
				'name'        => 'qodef_choose_google_font',
				'title'       => esc_html__( 'Google Font', 'roisin-core' ),
				'description' => esc_html__( 'Choose Google Font', 'roisin-core' ),
				'args'        => array(
					'include' => 'google-fonts'
				)
			) );
			
			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Style & Weight', 'roisin-core' ),
					'description' => esc_html__( 'Choose a default Google Font weights for your website. Impact on page load time', 'roisin-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'roisin-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'roisin-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'roisin-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'roisin-core' ),
						'300'  => esc_html__( '300 Light', 'roisin-core' ),
						'300i' => esc_html__( '300 Light Italic', 'roisin-core' ),
						'400'  => esc_html__( '400 Regular', 'roisin-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'roisin-core' ),
						'500'  => esc_html__( '500 Medium', 'roisin-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'roisin-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'roisin-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'roisin-core' ),
						'700'  => esc_html__( '700 Bold', 'roisin-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'roisin-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'roisin-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'roisin-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'roisin-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'roisin-core' )
					)
				)
			);
			
			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'roisin-core' ),
					'description' => esc_html__( 'Choose a default Google Font weights for your website. Impact on page load time', 'roisin-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'roisin-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'roisin-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'roisin-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'roisin-core' ),
						'greek'        => esc_html__( 'Greek', 'roisin-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'roisin-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'roisin-core' )
					)
				)
			);
			
			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'roisin-core' ),
					'description' => esc_html__( 'Add custom fonts', 'roisin-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'roisin-core' )
				)
			);
			
			$page_repeater->add_field_element( array(
				'field_type' => 'file',
				'name'       => 'qodef_custom_font_ttf',
				'title'      => esc_html__( 'Custom Font TTF', 'roisin-core' ),
				'args'       => array(
					'allowed_type' => 'font/ttf'
				)
			) );
			
			$page_repeater->add_field_element( array(
				'field_type' => 'file',
				'name'       => 'qodef_custom_font_otf',
				'title'      => esc_html__( 'Custom Font OTF', 'roisin-core' ),
				'args'       => array(
					'allowed_type' => 'font/otf'
				)
			) );
			
			$page_repeater->add_field_element( array(
				'field_type' => 'file',
				'name'       => 'qodef_custom_font_woff',
				'title'      => esc_html__( 'Custom Font WOFF', 'roisin-core' ),
				'args'       => array(
					'allowed_type' => 'font/woff'
				)
			) );
			
			$page_repeater->add_field_element( array(
				'field_type' => 'file',
				'name'       => 'qodef_custom_font_woff2',
				'title'      => esc_html__( 'Custom Font WOFF2', 'roisin-core' ),
				'args'       => array(
					'allowed_type' => 'font/woff2'
				)
			) );
			
			$page_repeater->add_field_element( array(
				'field_type' => 'text',
				'name'       => 'qodef_custom_font_name',
				'title'      => esc_html__( 'Custom Font Name', 'roisin-core' ),
			) );
			
			// Hook to include additional options after module options
			do_action( 'roisin_core_action_after_page_fonts_options_map', $page );
		}
	}
	
	add_action( 'roisin_core_action_default_options_init', 'roisin_core_add_fonts_options', roisin_core_get_admin_options_map_position( 'fonts' ) );
}