<?php

if ( ! function_exists( 'roisin_core_is_page_footer_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 * 
	 * @param $is_enabled bool
	 * 
	 * @return bool
	 */
	function roisin_core_is_page_footer_enabled( $is_enabled ) {
		$option = roisin_core_get_post_value_through_levels( 'qodef_enable_page_footer' ) !== 'no';
		
		if ( ! $option ) {
			$is_enabled = false;
		}
		
		return $is_enabled;
	}
	
	add_filter( 'roisin_filter_enable_page_footer', 'roisin_core_is_page_footer_enabled' );
}

if ( ! function_exists( 'roisin_core_is_footer_top_area_enabled' ) ) {
	/**
	 * Function that check if page footer top area widgets are empty
	 * 
	 * @param $is_enabled bool
	 *
	 * @return bool
	 */
	function roisin_core_is_footer_top_area_enabled( $is_enabled ) {
		$option = roisin_core_get_post_value_through_levels( 'qodef_enable_top_footer_area' ) !== 'no';
		
		if ( ! $option ) {
			$is_enabled = false;
		}
		
		return $is_enabled;
	}
	
	add_filter( 'roisin_filter_enable_footer_top_area', 'roisin_core_is_footer_top_area_enabled' );
}

if ( ! function_exists( 'roisin_core_is_footer_bottom_area_enabled' ) ) {
	/**
	 * Function that check if page footer bottom area widgets are empty
	 * 
	 * @param $is_enabled bool
	 *
	 * @return bool
	 */
	function roisin_core_is_footer_bottom_area_enabled( $is_enabled ) {
		$option = roisin_core_get_post_value_through_levels( 'qodef_enable_bottom_footer_area' ) !== 'no';
		
		if ( ! $option ) {
			$is_enabled = false;
		}
		
		return $is_enabled;
	}
	
	add_filter( 'roisin_filter_enable_footer_bottom_area', 'roisin_core_is_footer_bottom_area_enabled' );
}

if ( ! function_exists( 'roisin_core_set_footer_top_area_classes' ) ) {
	/**
	 * Function that return classes for page footer top area
	 *
	 * @param $classes string
	 *
	 * @return string
	 */
	function roisin_core_set_footer_top_area_classes( $classes ) {
		$is_grid_enabled = roisin_core_get_post_value_through_levels( 'qodef_set_footer_top_area_in_grid' ) !== 'no';
		
		if ( ! $is_grid_enabled ) {
			$classes = 'qodef-content-full-width';
		}
		
		return $classes;
	}
	
	add_filter( 'roisin_filter_footer_top_area_classes', 'roisin_core_set_footer_top_area_classes' );
}

if ( ! function_exists( 'roisin_core_set_footer_bottom_area_classes' ) ) {
	/**
	 * Function that return classes for page footer bottom area
	 *
	 * @param $classes string
	 *
	 * @return string
	 */
	function roisin_core_set_footer_bottom_area_classes( $classes ) {
		$is_grid_enabled = roisin_core_get_post_value_through_levels( 'qodef_set_footer_bottom_area_in_grid' ) !== 'no';
		
		if ( ! $is_grid_enabled ) {
			$classes = 'qodef-content-full-width';
		}
		
		return $classes;
	}
	
	add_filter( 'roisin_filter_footer_bottom_area_classes', 'roisin_core_set_footer_bottom_area_classes' );
}

if ( ! function_exists( 'roisin_core_set_footer_sidebars_config' ) ) {
	/**
	 * Function that override default page footer sidebars config
	 *
	 * @param $config array
	 *
	 * @return array
	 */
	function roisin_core_set_footer_sidebars_config( $config ) {
		$top_area_columns    = roisin_core_get_post_value_through_levels( 'qodef_set_footer_top_area_columns' );
		$bottom_area_columns = roisin_core_get_post_value_through_levels( 'qodef_set_footer_bottom_area_columns' );
		
		if ( ! empty( $top_area_columns ) ) {
			$config['footer_top_sidebars_number'] = $top_area_columns;
		}
		
		if ( ! empty( $bottom_area_columns ) ) {
			$config['footer_bottom_sidebars_number'] = $bottom_area_columns;
		}
		
		return $config;
	}
	
	add_filter( 'roisin_filter_page_footer_sidebars_config', 'roisin_core_set_footer_sidebars_config' );
}

if ( ! function_exists( 'roisin_core_set_footer_top_area_columns_classes' ) ) {
	/**
	 * Function that set classes for page footer top area columns
	 *
	 * @param $classes array
	 *
	 * @return array
	 */
	function roisin_core_set_footer_top_area_columns_classes( $classes ) {
		$gutter_size = roisin_core_get_post_value_through_levels( 'qodef_set_footer_top_area_grid_gutter' );

		if ( ! empty( $gutter_size ) ) {
			$classes[] = 'qodef-gutter--' . esc_attr( $gutter_size );
		}
		
		return $classes;
	}
	
	add_filter( 'roisin_filter_footer_top_area_columns_classes', 'roisin_core_set_footer_top_area_columns_classes' );
}

if ( ! function_exists( 'roisin_core_set_footer_bottom_area_columns_classes' ) ) {
	/**
	 * Function that set classes for page footer bottom area columns
	 *
	 * @param $classes array
	 *
	 * @return array
	 */
	function roisin_core_set_footer_bottom_area_columns_classes( $classes ) {
		$gutter_size = roisin_core_get_post_value_through_levels( 'qodef_set_footer_bottom_area_grid_gutter' );
		
		if ( ! empty( $gutter_size ) ) {
			$classes[] = 'qodef-gutter--' . esc_attr( $gutter_size );
		}
		
		return $classes;
	}
	
	add_filter( 'roisin_filter_footer_bottom_area_columns_classes', 'roisin_core_set_footer_bottom_area_columns_classes' );
}

if ( ! function_exists( 'roisin_core_set_page_footer_area_styles' ) ) {
	/**
	 * Function that generates page footer area inline styles
	 *
	 * @param $style string
	 *
	 * @return string
	 */
	function roisin_core_set_page_footer_area_styles( $style ) {
		$footer_area = array( 'top', 'bottom' );
		
		foreach ( $footer_area as $area ) {
			$styles           = array();
			$background_color = roisin_core_get_post_value_through_levels( 'qodef_' . $area . '_footer_area_background_color' );
			$background_image = roisin_core_get_post_value_through_levels( 'qodef_' . $area . '_footer_area_background_image' );
			$top_border_color = roisin_core_get_post_value_through_levels( 'qodef_' . $area . '_footer_area_top_border_color' );
			$top_border_width = roisin_core_get_post_value_through_levels( 'qodef_' . $area . '_footer_area_top_border_width' );
			
			if ( ! empty( $background_color ) ) {
				$styles['background-color'] = $background_color;
			}
			
			if ( ! empty( $background_image ) ) {
				$styles['background-image'] = 'url(' . esc_url( wp_get_attachment_image_url( $background_image, 'full' ) ) . ')';
			}
			
			if ( ! empty( $top_border_color ) ) {
				$styles['border-top-color'] = $top_border_color;
				
				if ( $top_border_width === '' ) {
					$styles['border-top-width'] = '1px';
				}
			}
			
			if ( $top_border_width !== '' ) {
				$styles['border-top-width'] = intval( $top_border_width ) . 'px';
			}

			if ( ! empty( $styles ) ) {
				$style .= qode_framework_dynamic_style( '#qodef-page-footer-' . $area . '-area', $styles );
			}
		}
		
		return $style;
	}
	
	add_filter( 'roisin_filter_add_inline_style', 'roisin_core_set_page_footer_area_styles' );
}

if ( ! function_exists( 'roisin_core_is_footer_top_predefined_enabled' ) ) {
	/**
	 * Function that check if page footer top area widgets are empty
	 *
	 * @param $is_enabled bool
	 *
	 * @return bool
	 */
	function roisin_core_is_footer_top_predefined_enabled( $config ) {
		$option = roisin_core_get_post_value_through_levels( 'qodef_enable_footer_predefined_style' ) ;

		if (  $option === 'yes' ) {
			$config = roisin_core_get_template_part( 'footer', 'templates/footer-content' );
		}

		return $config;
	}

	add_filter( 'roisin_filter_footer_content_template', 'roisin_core_is_footer_top_predefined_enabled' );
}

if ( ! function_exists( 'roisin_core_get_footer_top_area_columns_classes' ) ) {
	/**
	 * Function that return columns classes for page footer top area
	 *
	 * @return string
	 */
	function roisin_core_get_footer_top_area_columns_classes() {
		$columns_number = roisin_get_page_footer_sidebars_config_by_key( 'footer_top_sidebars_number' );

		$responsive_columns_number = array(
			'qodef-col-num--1024--2',
			'qodef-col-num--768--2',
			'qodef-col-num--680--1',
			'qodef-col-num--480--1'
		);

		$classes = apply_filters( 'roisin_core_get_footer_top_area_columns_classes', array_merge( array(
			'qodef-grid',
			'qodef-layout--template',
			'qodef-layout--columns',
			'qodef-responsive--custom',
			'qodef-column-num--' . intval( $columns_number )
		), $responsive_columns_number ) );

		return implode( ' ', $classes );
	}
}

if ( ! function_exists( 'roisin_core_get_page_footer_columns_config' ) ) {
	/**
	 * Function that return page footer config variable value by key
	 *
	 * @param $key string - key of config variables array value
	 *
	 * @return string | mixed
	 */
	function roisin_core_get_page_footer_columns_config($key) {

		if($key === 1) {
			$value = 6;
		} else {
			$value = 2;
		}

		return $value;
	}
}