<?php

if ( ! function_exists( 'roisin_core_get_fullscreen_icon_html' ) ) {
	/**
	 * Returns html for icon sources
	 * @param bool $is_close_icon
	 *
	 * @return string/html
	 */
	function roisin_core_get_fullscreen_icon_html($is_close_icon = false) {
		$html = '';

		$icon_source         = roisin_core_get_option_value('admin', 'qodef_fullscreen_menu_icon_source' );
		$icon_pack           = roisin_core_get_option_value('admin', 'qodef_fullscreen_menu_icon_pack' );
		$icon_svg_path       = roisin_core_get_option_value('admin', 'qodef_fullscreen_menu_icon_svg_path' );
		$close_icon_svg_path = roisin_core_get_option_value('admin', 'qodef_fullscreen_menu_close_icon_svg_path' );


		if ( $icon_source === 'icon_pack' && !empty( $icon_pack ) ) {
			if ( $is_close_icon ) {
				$html .= qode_framework_icons()->get_specific_icon_from_pack('close', $icon_pack);

			} else {
				$html .= qode_framework_icons()->get_specific_icon_from_pack('menu', $icon_pack);
			}

		} else if ( $icon_source === 'svg_path' && ((isset( $icon_svg_path ) && ! empty( $icon_svg_path ) ) || ( isset($close_icon_svg_path) && ! empty($close_icon_svg_path))) ) {

			if ( $is_close_icon ) {
				$html .= $close_icon_svg_path;
			} else {
				$html .= $icon_svg_path;
			}

		} else if ( $icon_source === 'predefined' ) {
			$html .= '<span class="qodef-lines">';
			$html .= '<span class="qodef-line qodef-line-1"></span>';
			$html .= '<span class="qodef-line qodef-line-2"></span>';
			$html .= '<span class="qodef-line qodef-line-3"></span>';
			$html .= '</span>';
		}


		return $html;
	}
}

if ( ! function_exists( 'roisin_core_register_fullscreen_menu' ) ) {
	function roisin_core_register_fullscreen_menu($menus) {

		$menus['fullscreen-menu-navigation'] = esc_html__( 'Fullscreen Navigation', 'roisin-core' );

		return $menus;
	}
	add_filter('roisin_filter_register_navigation_menus','roisin_core_register_fullscreen_menu');
}

if ( ! function_exists( 'roisin_core_get_fullscreen_menu_widget_area_config' ) ) {
	/**
	 * Function that return config variables for fullscreen menu widget area
	 *
	 * @return array
	 */
	function roisin_core_get_fullscreen_menu_widget_area_config() {
		
		// Config variables
		$config = apply_filters( 'roisin_core_filter_fullscreen_menu_widget_area_config', array(
			'title_tag'   => 'h5',
			'title_class' => 'qodef-widget-title'
		) );
		
		return $config;
	}
}

if ( ! function_exists( 'roisin_core_register_fullscreen_menu_widget_area_top_sidebar' ) ) {
	/**
	 * Register side area sidebar
	 */
	function roisin_core_register_fullscreen_menu_widget_area_top_sidebar() {
		
		// Sidebar config variables
		$config = roisin_core_get_fullscreen_menu_widget_area_config();
		
		register_sidebar(
			array(
				'id'            => 'qodef-fullscreen-menu-top',
				'name'          => esc_html__( 'Fullscreen Menu Top', 'roisin-core' ),
				'description'   => esc_html__( 'Widgets added here will appear in fullscreen menu area', 'roisin-core' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s" data-area="fullscreen-menu-top">',
				'after_widget'  => '</div>',
				'before_title'  => '<'. roisin_core_escape_title_tag( $config['title_tag'] ) .' class="'. esc_attr( $config['title_class'] ) .'">',
				'after_title'   => '</'. roisin_core_escape_title_tag( $config['title_tag'] ) .'>'
			)
		);
	}
	
	add_action( 'widgets_init', 'roisin_core_register_fullscreen_menu_widget_area_top_sidebar' );
}

if ( ! function_exists( 'roisin_core_register_fullscreen_menu_widget_area_bottom_sidebar' ) ) {
	/**
	 * Register side area sidebar
	 */
	function roisin_core_register_fullscreen_menu_widget_area_bottom_sidebar() {
		
		// Sidebar config variables
		$config = roisin_core_get_fullscreen_menu_widget_area_config();
		
		register_sidebar(
			array(
				'id'            => 'qodef-fullscreen-menu-bottom',
				'name'          => esc_html__( 'Fullscreen Menu Bottom', 'roisin-core' ),
				'description'   => esc_html__( 'Widgets added here will appear in fullscreen menu area', 'roisin-core' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s" data-area="fullscreen-menu-bottom">',
				'after_widget'  => '</div>',
				'before_title'  => '<'. roisin_core_escape_title_tag( $config['title_tag'] ) .' class="'. esc_attr( $config['title_class'] ) .'">',
				'after_title'   => '</'. roisin_core_escape_title_tag( $config['title_tag'] ) .'>'
			)
		);
	}
	
	add_action( 'widgets_init', 'roisin_core_register_fullscreen_menu_widget_area_bottom_sidebar' );
}