<?php

if ( ! function_exists( 'roisin_core_add_donation_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_donation_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => ROISIN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'donation',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Donation', 'roisin-core' ),
				'description' => esc_html__( 'Global settings related to page', 'roisin-core' ),
				'layout'      => 'tabbed'
			)
		);
		
		if ( $page ) {
			
			$list_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-list',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Donation Global', 'roisin-core' ),
					'description' => esc_html__( 'Settings related to Global Donations', 'roisin-core' )
				)
			);
			$list_tab->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_donation_global_progress_color',
					'title'       => esc_html__( 'Progress Color', 'roisin-core' ),
					'description' => esc_html__( 'Enter donation progress color', 'roisin-core' )
				)
			);
			
			// Hook to include additional options after donation list options
			do_action( 'roisin_core_action_after_donation_list_options_map', $page );
			
			$single_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-single',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Donation Single', 'roisin-core' ),
					'description' => esc_html__( 'Settings related to donation single', 'roisin-core' )
				)
			);
			
			$single_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_donation_single_enable_page_title',
					'title'       => esc_html__( 'Enable Page Title', 'roisin-core' ),
					'description' => esc_html__( 'Use this option to enable/disable page title on donation single', 'roisin-core' ),
					'options'     => roisin_core_get_select_type_options_pool( 'no_yes' ),
				)
			);
			
			$single_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_donation_single_sidebar_layout',
					'title'       => esc_html__( 'Sidebar Layout', 'roisin-core' ),
					'description' => esc_html__( 'Choose default sidebar layout for donation single. Make sure that "Single Form Sidebar" option is enabled in Give Plugin.', 'roisin-core' ),
					'options'     => roisin_core_get_select_type_options_pool( 'sidebar_layouts' )
				)
			);
			
			// Hook to include additional options after donation single options
			do_action( 'roisin_core_action_after_donation_single_options_map', $page );
		}
	}

	add_action( 'roisin_core_action_default_options_init', 'roisin_core_add_donation_options', roisin_core_get_admin_options_map_position( 'donation' ) );
}