<?php

if ( ! function_exists( 'roisin_core_register_give_forms_for_meta_options' ) ) {
	/**
	 * Function that register product post type for meta box options
	 *
	 * @param $post_types array
	 *
	 * @return array
	 */
	function roisin_core_register_give_forms_for_meta_options( $post_types ) {
		$post_types[] = 'give_forms';
		
		return $post_types;
	}
	
	add_filter( 'qode_framework_filter_meta_box_save', 'roisin_core_register_give_forms_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'roisin_core_register_give_forms_for_meta_options' );
}

if ( ! class_exists( 'RoisinCoreGive' ) ) {
	class RoisinCoreGive {
		private static $instance;
		
		public function __construct() {
			
			if ( ! function_exists( 'roisin_core_include_give_plugin_is_installed' ) ) {
				function roisin_core_include_give_plugin_is_installed( $installed, $plugin ) {
					if ( $plugin === 'give' ) {
						return defined( 'GIVE_VERSION' );
					}
					
					return $installed;
				}
				
				add_filter( 'qode_framework_filter_is_plugin_installed', 'roisin_core_include_give_plugin_is_installed', 10, 2 );
			}
			
			if ( qode_framework_is_installed( 'give' ) ) {
				// Include files
				$this->include_files();
				
				// Loads config
				$this->config();
			}
		}
		
		public static function get_instance() {
			if ( self::$instance == null ) {
				self::$instance = new self();
			}
			
			return self::$instance;
		}
		
		function include_files() {
			// Include template helper functions
			include_once 'helper.php';
			
			// Include template helper functions
			include_once 'template-functions.php';
			
			// Include options
			include_once 'dashboard/admin/donation-options.php';
			
			// Include meta boxes
			include_once 'dashboard/meta-box/donation-meta-box.php';
			
			// Include shortcodes
			add_action( 'qode_framework_action_before_shortcodes_register', array( $this, 'include_shortcodes' ) );
			
			// Include widgets
			add_action( 'qode_framework_action_before_widgets_register', array( $this, 'include_widgets' ) );
		}
		
		function include_shortcodes() {
			foreach ( glob( ROISIN_CORE_INC_PATH . '/give/shortcodes/*/include.php' ) as $shortcode ) {
				include_once $shortcode;
			}
		}
		
		function include_widgets() {
			foreach ( glob( ROISIN_CORE_INC_PATH . '/give/widgets/*/include.php' ) as $widget ) {
				include_once $widget;
			}
		}
		
		function config() {
			// Functions that render additional content around everything
			add_filter( 'give_default_wrapper_start', 'roisin_core_donation_wrapper_start_override' );
			add_filter( 'give_default_wrapper_end', 'roisin_core_donation_wrapper_end_override' );
			
			// Function that render additional content around give single summary
			add_action( 'give_before_single_form_summary', 'roisin_core_donation_summary_before', 1 );
			add_action( 'give_after_single_form_summary', 'roisin_core_donation_summary_after', 1000 );
			
			// Adds additional classes for summary and sidebar
			add_action( 'give_forms_single_summary_classes', 'roisin_core_donation_summary_add_classes' );
			add_action( 'give_left_sidebar_pre_wrap', 'roisin_core_donation_sidebar_add_classes' );
			
			// Adds image at the top of summary
			add_action( 'give_single_form_summary', 'roisin_core_donation_summary_image', 1 );
			
			// Override button
			add_filter( 'give_display_checkout_button', 'roisin_core_donation_button' );
			
			// Change position of sidebar and remove featured image from sidebar
			add_action( 'give_before_single_form_summary', 'roisin_core_donation_change_sidebar_position', 2 );

			// Remove default title from single summary and add our own title
			remove_action( 'give_single_form_summary', 'give_template_single_title', 5 );
			
			// Remove default goal progress from single summary and add our own title
			remove_action( 'give_pre_form', 'give_show_goal_progress', 10 );
			
			// Add more items to content, like category and title
			add_filter( 'give_form_content_output', 'roisin_core_donation_edit_content_output' );
		}
	}
	
	RoisinCoreGive::get_instance();
}