<?php

if ( ! function_exists( 'roisin_core_donation_comments_support' ) ) {
	/*
	* Add comments support for give plugin
	*/
	function roisin_core_donation_comments_support( $give_form_supports ) {
		$give_form_supports[] = 'comments';
		
		return $give_form_supports;
	}
	
	add_filter( 'give_forms_supports', 'roisin_core_donation_comments_support' );
}

if ( ! function_exists( 'roisin_core_donation_comment_form' ) ) {
	/*
	* Add a template where to print comments
	*/
	function roisin_core_donation_comment_form() {
		comments_template( '', true );
	}
	
	add_action( 'give_single_form_summary', 'roisin_core_donation_comment_form', 100 );
}

if ( ! function_exists( 'roisin_core_set_donation_single_page_title' ) ) {
	/**
	 * Function that enable/disable page title area for blog single page
	 *
	 * @param $enable_page_title bool
	 *
	 * @return bool
	 */
	function roisin_core_set_donation_single_page_title( $enable_page_title ) {
		
		if ( is_singular( 'give_forms' ) ) {
			$option = roisin_core_get_post_value_through_levels( 'qodef_donation_single_enable_page_title' ) !== 'no';
			
			if ( isset ( $option ) ) {
				$enable_page_title = $option;
			}
			
			$meta_option = get_post_meta( get_the_ID(), 'qodef_enable_page_title', true );
			
			if ( ! empty( $meta_option ) ) {
				$enable_page_title = $meta_option;
			}
		}
		
		return $enable_page_title;
	}
	
	add_filter( 'roisin_filter_enable_page_title', 'roisin_core_set_donation_single_page_title' );
}

if ( ! function_exists( 'roisin_core_set_donation_single_sidebar_layout' ) ) {
	/**
	 * Function that return sidebar layout
	 *
	 * @param $layout string
	 *
	 * @return string
	 */
	function roisin_core_set_donation_single_sidebar_layout( $layout ) {
		
		if ( is_singular( 'give_forms' ) ) {
			$option = roisin_core_get_post_value_through_levels( 'qodef_donation_single_sidebar_layout' );
			
			if ( ! empty( $option ) ) {
				$layout = $option;
			}
			
			$meta_option = get_post_meta( get_the_ID(), 'qodef_page_sidebar_layout', true );
			
			if ( ! empty( $meta_option ) ) {
				$layout = $meta_option;
			}
		}
		
		return $layout;
	}
	
	add_filter( 'roisin_filter_sidebar_layout', 'roisin_core_set_donation_single_sidebar_layout' );
}

if ( ! function_exists( 'roisin_core_set_donation_single_sidebar_grid_gutter_classes' ) ) {
	/**
	 * Function that returns grid gutter classes
	 *
	 * @param $classes string
	 *
	 * @return string
	 */
	function roisin_core_set_donation_single_sidebar_grid_gutter_classes( $classes ) {
		
		if ( is_singular( 'give_forms' ) ) {
			$option = roisin_core_get_post_value_through_levels( 'qodef_donation_single_sidebar_grid_gutter' );
			
			if ( ! empty( $option ) ) {
				$classes = 'qodef-gutter--' . esc_attr( $option );
			}
			
			$meta_option = get_post_meta( get_the_ID(), 'qodef_page_sidebar_grid_gutter', true );
			
			if ( ! empty( $meta_option ) ) {
				$classes = 'qodef-gutter--' . esc_attr( $meta_option );
			}
		}
		
		return $classes;
	}
	
	add_filter( 'roisin_filter_grid_gutter_classes', 'roisin_core_set_donation_single_sidebar_grid_gutter_classes' );
}

if ( ! function_exists( 'roisin_core_donation_set_admin_options_map_position' ) ) {
	/**
	 * Function that set dashboard admin options map position for this module
	 *
	 * @param $position int
	 * @param $map string
	 *
	 * @return int
	 */
	function roisin_core_donation_set_admin_options_map_position( $position, $map ) {
		
		if ( $map === 'donation' ) {
			$position = 53;
		}
		
		return $position;
	}
	
	add_filter( 'roisin_core_filter_admin_options_map_position', 'roisin_core_donation_set_admin_options_map_position', 10, 2 );
}

if ( ! function_exists( 'roisin_core_donation_progress_bar_styles' ) ) {
	function roisin_core_donation_progress_bar_styles( $style ) {
		$styles           = array();
		$background_color = roisin_core_get_option_value( 'admin', 'qodef_donation_global_progress_color' );
		
		if ( ! empty( $background_color ) ) {
			$styles['background-color'] = esc_attr( $background_color . ' !important' );
		}
		
		if ( ! empty( $styles ) ) {
			$style .= qode_framework_dynamic_style( '.give-goal-progress .give-progress-bar>span', $styles );
		}
		
		return $style;
		
	}
	
	add_filter( 'roisin_filter_add_inline_style', 'roisin_core_donation_progress_bar_styles' );
}