<?php

if ( ! function_exists( 'roisin_core_add_donation_list_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function roisin_core_add_donation_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'RoisinCoreDonationListShortcode';

		return $shortcodes;
	}

	add_filter( 'roisin_core_filter_register_shortcodes', 'roisin_core_add_donation_list_shortcode' );
}

if ( class_exists( 'RoisinCoreListShortcode' ) ) {
	class RoisinCoreDonationListShortcode extends RoisinCoreListShortcode {

		public function __construct() {
			$this->set_post_type( 'give_forms' );
			$this->set_post_type_taxonomy( 'give_forms_category' );
			$this->set_layouts( apply_filters( 'roisin_core_filter_donation_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'roisin_core_filter_donation_list_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( ROISIN_CORE_INC_URL_PATH . '/donation/shortcodes/donation-list' );
			$this->set_base( 'roisin_core_donation_list' );
			$this->set_name( esc_html__( 'Donation List', 'roisin-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays donation list', 'roisin-core' ) );
			$this->set_category( esc_html__( 'Roisin Core', 'roisin-core' ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'roisin-core' )
			) );
			$this->map_list_options();
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options( array(
				'layouts'          => $this->get_layouts(),
				'exclude_option'   => array( 'title_tag', 'text_transform' )
			) );
			$this->map_additional_options();
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['query_result']   = new \WP_Query( roisin_core_get_query_params( $atts ) );
			$atts['space_value']    = roisin_core_get_space_value( $atts['space'] );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['data_attr']      = roisin_core_get_pagination_data( ROISIN_CORE_REL_PATH, 'give/shortcodes', 'donation-list', 'give_forms', $atts );

			$atts['this_shortcode'] = $this;

			return roisin_core_get_template_part( 'give/shortcodes/donation-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-donation-list';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}
	}
}