<?php

if ( ! function_exists( 'roisin_core_donation_wrapper_start_override' ) ) {
	/**
	 * Function that render additional content around everything
	 */
	function roisin_core_donation_wrapper_start_override() {
		$output = '<main id="qodef-page-content" class="qodef-grid qodef-layout--template">';
		$output .= '<div class="qodef-grid-inner clear">';
		$output .= '<div class="qodef-grid-item qodef-page-content-section qodef-col--12">';
		
		return $output;
	}
}

if ( ! function_exists( 'roisin_core_donation_wrapper_end_override' ) ) {
	/**
	 * Function that render additional content around everything
	 */
	function roisin_core_donation_wrapper_end_override() {
		$output = '</div>';
		$output .= '</div>';
		$output .= '</main>';
		
		return $output;
	}
}

if ( ! function_exists( 'roisin_core_donation_summary_before' ) ) {
	/**
	 * Function that render additional content around give single
	 */
	function roisin_core_donation_summary_before() {
		echo '<div class="qodef-grid qodef-layout--template ' . esc_attr( roisin_get_grid_gutter_classes() ) . '">';
		echo '<div class="qodef-grid-inner clear">';
	}
}

if ( ! function_exists( 'roisin_core_donation_summary_after' ) ) {
	/**
	 * Function that render additional content around give single
	 */
	function roisin_core_donation_summary_after() {
		echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'roisin_core_donation_summary_add_classes' ) ) {
	/**
	 * Function that adds additional classes for summery
	 */
	function roisin_core_donation_summary_add_classes() {
		$columns = 'qodef-col--12';
		
		if ( give_is_setting_enabled( give_get_option( 'form_sidebar' ) ) ) {
			$columns = esc_attr( roisin_get_page_content_sidebar_classes() );
		}
		
		$output = 'qodef-grid-item qodef-page-content-section ' . $columns;
		
		return $output;
	}
}

if ( ! function_exists( 'roisin_core_donation_sidebar_add_classes' ) ) {
	/**
	 * Function that adds additional classes for sidebar
	 */
	function roisin_core_donation_sidebar_add_classes() {
		
		if ( roisin_get_sidebar_layout() === 'no-sidebar' ) {
			$columns = 'qodef-page-sidebar-section qodef--hide';
		} else if ( give_is_setting_enabled( give_get_option( 'form_sidebar' ) ) ) {
			$columns = esc_attr( roisin_get_page_sidebar_classes() );
		}
		
		echo '<div class="qodef-grid-item qodef-page-sidebar-section ' . $columns . '">';
	}
}

if ( ! function_exists( 'roisin_core_donation_change_sidebar_position' ) ) {
	/*
	* Change Sidebar Position
	*/
	function roisin_core_donation_change_sidebar_position() {
		remove_action( 'give_before_single_form_summary', 'give_left_sidebar_pre_wrap', 5 );
		remove_action( 'give_before_single_form_summary', 'give_show_form_images', 10 );
		remove_action( 'give_before_single_form_summary', 'give_get_forms_sidebar', 20 );
		remove_action( 'give_before_single_form_summary', 'give_left_sidebar_post_wrap', 30 );
		
		add_action( 'give_after_single_form_summary', 'give_left_sidebar_pre_wrap', 5 );
		add_action( 'give_after_single_form_summary', 'give_get_forms_sidebar', 20 );
		add_action( 'give_after_single_form_summary', 'give_left_sidebar_post_wrap', 30 );
	}
}

if ( ! function_exists( 'roisin_core_donation_summary_image' ) ) {
	/**
	 * Function that render additional content around give single
	 */
	function roisin_core_donation_summary_image() {
		roisin_core_template_part( 'give', 'templates/post-info/top-holder' );
	}
}

if ( ! function_exists( 'roisin_core_donation_button' ) ) {
	/*
	* Override button from give plugin
	*/
	function roisin_core_donation_button() {
		
		// our variable
		$form_id = get_the_ID();
		
		// give code
		$display_option = isset( $args['display_style'] ) && ! empty( $args['display_style'] ) ? $args['display_style'] : give_get_meta( $form_id, '_give_payment_display', true );
		
		if ( $display_option === 'onpage' ) {
			return '';
		}
		
		$display_label_field = give_get_meta( $form_id, '_give_reveal_label', true );
		$display_label       = ! empty( $args['continue_button_title'] ) ? $args['continue_button_title'] : ( ! empty( $display_label_field ) ? $display_label_field : esc_html__( 'Donate Now', 'roisin-core' ) );
		
		// our button params and output
		$button_params = array(
			'custom_class' => 'give-btn give-btn-modal',
			'text'         => $display_label,
			'link'         => '#',
		);
		
		$output = RoisinCoreButtonShortcode::call_shortcode( $button_params );
		
		return $output;
	}
}

if ( ! function_exists( 'roisin_core_donation_edit_content_output' ) ) {
	/*
	* Add more items to content, like category and title
	*/
	function roisin_core_donation_edit_content_output() {
		/*
		* Override content to add title and category
		*/
		$args    = array();
		$form_id = get_the_ID();
		
		$content      = give_get_meta( $form_id, '_give_form_content', true );
		$show_content = give_get_form_content_placement( $form_id, $args );
		
		if ( give_is_setting_enabled( give_get_option( 'the_content_filter' ) ) ) {
			
			// Do not restore wpautop if we are still parsing blocks.
			$priority = has_filter( 'the_content', '_restore_wpautop_hook' );
			if ( false !== $priority && doing_filter( 'the_content' ) ) {
				remove_filter( 'the_content', '_restore_wpautop_hook', $priority );
			}
			
			$content = apply_filters( 'the_content', $content );
			
			// Restore wpautop after done with blocks parsing.
			if ( $priority ) {
				// Run wpautop manually if parsing block
				$content = wpautop( $content );
				
				add_filter( 'the_content', '_restore_wpautop_hook', $priority );
			}
		} else {
			$content = wpautop( do_shortcode( $content ) );
		}
		
		// QODE EDIT
		$output = '<div id="give-form-content-' . $form_id . '" class="give-form-content-wrap ' . $show_content . '-content">';
		$output .= roisin_core_get_template_part( 'give', 'templates/post-info/goal-progress' );
		$output .= roisin_core_get_template_part( 'give', 'templates/post-info/category' );
		$output .= roisin_core_get_template_part( 'give', 'templates/post-info/title' );
		$output .= $content;
		if ( is_singular( 'give_forms' ) ) {
			$output .= '<div class="qodef-e-donation-bottom-holder">';
			$output .= roisin_core_get_template_part( 'give', 'templates/post-info/date' );
			$output .= roisin_core_get_template_part( 'give', 'templates/post-info/social-share' );
			$output .= '</div>';
		}
		$output .= '</div>';
		
		return $output;
	}
}