<?php
$categories = wp_get_post_terms( get_the_ID(), 'give_forms_category' );

if ( give_is_setting_enabled( give_get_option( 'categories' ) ) && ! is_wp_error( $categories ) ) { ?>
	<div class="qodef-e-donation-category">
		<?php foreach ( $categories as $cat ) { ?>
			<a itemprop="url" class="qodef-e-category" href="<?php echo esc_url( get_term_link( $cat->term_id ) ); ?>">
				<?php echo esc_html( $cat->name ); ?>
			</a>
			<span class="qodef-e-donation-category-separator"></span>
		<?php } ?>
	</div>
<?php } ?>