<?php

if ( ! function_exists( 'roisin_core_add_logo_options' ) ) {
	function roisin_core_add_logo_options() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope'       => ROISIN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'logo',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Logo', 'roisin-core' ),
				'description' => esc_html__( 'Global Logo Options', 'roisin-core' ),
				'layout'      => 'tabbed'
			)
		);
		
		if ( $page ) {
			
			$header_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-header',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Header Logo Options', 'roisin-core' ),
					'description' => esc_html__( 'Set options for initial headers', 'roisin-core' )
				)
			);
			
			$header_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_logo_height',
					'title'       => esc_html__( 'Logo Height', 'roisin-core' ),
					'description' => esc_html__( 'Enter logo height', 'roisin-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px', 'roisin-core' )
					)
				)
			);
			
			$header_tab->add_field_element(
				array(
					'field_type'    => 'image',
					'name'          => 'qodef_logo_main',
					'title'         => esc_html__( 'Logo - Main', 'roisin-core' ),
					'description'   => esc_html__( 'Choose main logo image', 'roisin-core' ),
					'default_value' => defined( 'ROISIN_ASSETS_ROOT' ) ? ROISIN_ASSETS_ROOT . '/img/logo.png' : '',
					'multiple'      => 'no'
				)
			);
			
			$header_tab->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_logo_dark',
					'title'       => esc_html__( 'Logo - Dark', 'roisin-core' ),
					'description' => esc_html__( 'Choose dark logo image', 'roisin-core' ),
					'multiple'    => 'no'
				)
			);
			
			$header_tab->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_logo_light',
					'title'       => esc_html__( 'Logo - Light', 'roisin-core' ),
					'description' => esc_html__( 'Choose light logo image', 'roisin-core' ),
					'multiple'    => 'no'
				)
			);
			
			// Hook to include additional options after module options
			do_action( 'roisin_core_action_after_header_logo_options_map', $page, $header_tab );
		}
	}
	
	add_action( 'roisin_core_action_default_options_init', 'roisin_core_add_logo_options', roisin_core_get_admin_options_map_position( 'logo' ) );
}