<?php

if ( ! function_exists( 'roisin_core_add_centered_header_options' ) ) {
	function roisin_core_add_centered_header_options( $page ) {
		
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_centered_header_section',
				'title'      => esc_html__( 'Centered Header', 'roisin-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values' => 'centered',
							'default_value' => ''
						)
					)
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_centered_header_height',
				'title'       => esc_html__( 'Header Height', 'roisin-core' ),
				'description' => esc_html__( 'Enter header height', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'roisin-core' )
				)
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_centered_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'roisin-core' ),
				'description' => esc_html__( 'Enter header background color', 'roisin-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'roisin-core' )
				)
			)
		);
	}
	
	add_action( 'roisin_core_action_after_header_options_map', 'roisin_core_add_centered_header_options' );
}