<?php
if ( ! function_exists( 'roisin_core_add_divided_header_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */

	function roisin_core_add_divided_header_global_option( $header_layout_options ) {
		$header_layout_options['divided'] = array(
			'image' => ROISIN_CORE_HEADER_LAYOUTS_URL_PATH . '/divided/assets/img/divided-header.png',
			'label' => esc_html__( 'Divided', 'roisin-core' )
		);

		return $header_layout_options;
	}

	add_filter( 'roisin_core_filter_header_layout_option', 'roisin_core_add_divided_header_global_option' );
}


if ( ! function_exists( 'roisin_core_register_divided_header_layout' ) ) {
	function roisin_core_register_divided_header_layout( $header_layouts ) {
		$header_layout = array(
			'divided' => 'DividedHeader'
		);

		$header_layouts = array_merge( $header_layouts, $header_layout );

		return $header_layouts;
	}

	add_filter( 'roisin_core_filter_register_header_layouts', 'roisin_core_register_divided_header_layout');
}

if ( ! function_exists( 'roisin_core_register_divided_menu' ) ) {
	function roisin_core_register_divided_menu($menus) {

		$menus['divided-menu-left-navigation']  = esc_html__( 'Divided Left Navigation', 'roisin-core' );
		$menus['divided-menu-right-navigation'] = esc_html__( 'Divided Right Navigation', 'roisin-core' );

		return $menus;
	}
	add_filter('roisin_filter_register_navigation_menus','roisin_core_register_divided_menu');
}