<?php

if ( ! function_exists( 'roisin_core_add_instagram_list_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_instagram_list_widget( $widgets ) {
		if ( qode_framework_is_installed( 'instagram' ) ) {
			$widgets[] = 'RoisinCoreInstagramListWidget';
		}

		return $widgets;
	}

	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_instagram_list_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreInstagramListWidget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'roisin-core' ),
				)
			);
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'roisin_core_instagram_list',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'roisin_core_instagram_list' );
				$this->set_name( esc_html__( 'Roisin Instagram List', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Add a instagram list element into widget areas', 'roisin-core' ) );
			}
		}

        public function render( $atts ) {
            echo RoisinCoreInstagramListShortcode::call_shortcode( $atts ); // XSS OK
        }
	}
}
