<?php

if ( ! function_exists( 'roisin_core_register_clients_for_meta_options' ) ) {
	function roisin_core_register_clients_for_meta_options( $post_types ) {
		$post_types[] = 'clients';
		return $post_types;
	}
	
	add_filter( 'qode_framework_filter_meta_box_save', 'roisin_core_register_clients_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'roisin_core_register_clients_for_meta_options' );
}

if ( ! function_exists( 'roisin_core_add_clients_custom_post_type' ) ) {
	/**
	 * Function that adds clients custom post type
	 *
	 * @param $cpts array
	 *
	 * @return array
	 */
	function roisin_core_add_clients_custom_post_type( $cpts ) {
		$cpts[] = 'RoisinCoreClientsCPT';
		
		return $cpts;
	}
	
	add_filter( 'roisin_core_filter_register_custom_post_types', 'roisin_core_add_clients_custom_post_type' );
}

if ( class_exists( 'QodeFrameworkCustomPostType' ) ) {
	class RoisinCoreClientsCPT extends QodeFrameworkCustomPostType {
		
		public function map_post_type() {
			$name = esc_html__( 'Clients', 'roisin-core' );
			$this->set_base( 'clients' );
			$this->set_menu_position( 10 );
			$this->set_menu_icon( 'dashicons-screenoptions' );
			$this->set_slug( 'clients' );
			$this->set_name( $name );
			$this->set_path( ROISIN_CORE_CPT_PATH . '/clients' );
			$this->set_labels( array(
				'name'          => esc_html__( 'Roisin Clients', 'roisin-core' ),
				'singular_name' => esc_html__( 'Client', 'roisin-core' ),
				'add_item'      => esc_html__( 'New Client', 'roisin-core' ),
				'add_new_item'  => esc_html__( 'Add New Client', 'roisin-core' ),
				'edit_item'     => esc_html__( 'Edit Client', 'roisin-core' )
			) );
			$this->set_public( false );
			$this->set_archive( false );
			$this->set_supports( array(
				'title',
				'thumbnail'
			) );
			$this->add_post_taxonomy( array(
				'base'          => 'clients-category',
				'slug'          => 'clients-category',
				'singular_name' => esc_html__( 'Category', 'roisin-core' ),
				'plural_name'   => esc_html__( 'Categories', 'roisin-core' ),
			) );
		}
		
	}
}