<?php
$is_enabled = roisin_core_get_post_value_through_levels( 'qodef_portfolio_enable_navigation' );
$back_to_link = roisin_core_get_post_value_through_levels( 'qodef_portfolio_single_back_link' );

if ( $is_enabled === 'yes' ) {
	$through_same_category = roisin_core_get_post_value_through_levels( 'qodef_portfolio_navigation_through_same_category' ) === 'yes';
	?>
	<div id="qodef-single-portfolio-navigation" class="qodef-m">
		<div class="qodef-m-inner">
			<?php


			$post_navigation = array(
				'prev' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Previous', 'roisin-core' ) . '</span>',
					'icon'  => qode_framework_icons()->render_icon( 'arrow_carrot-left', 'elegant-icons' ),
					'image' => get_the_post_thumbnail(get_previous_post(),'thumbnail')
				),
				'next' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Next', 'roisin-core' ) . '</span>',
					'icon'  => qode_framework_icons()->render_icon( 'arrow_carrot-right', 'elegant-icons' ),
					'image' => get_the_post_thumbnail(get_next_post(), 'thumbnail')
				)
			);
			
			if ( $through_same_category ) {
				if ( get_adjacent_post( true, '', true, 'portfolio-category') !== '' ) {
					$post_navigation['prev']['post'] = get_adjacent_post( true, '', true, 'portfolio-category');
				}
				if ( get_adjacent_post( true, '', false, 'portfolio-category' ) !== '' ) {
					$post_navigation['next']['post'] = get_adjacent_post( true, '', false, 'portfolio-category' );
				}
			} else {
				if ( get_adjacent_post(false, '', true) !== '' ) {
					$post_navigation['prev']['post'] = get_adjacent_post(false, '', true);
				}
				if ( get_adjacent_post(false, '', false) !== '' ) {
					$post_navigation['next']['post'] = get_adjacent_post(false, '', false);
				}
			}
			
			if(isset($post_navigation[ 'prev' ]['post'])) {
				$post_title   = $post_navigation[ 'prev' ]['post']->post_title;
				$post_id      = $post_navigation[ 'prev' ]['post']->ID;
				$categories = wp_get_post_terms($post_id, 'portfolio-category');
				?>
				<a itemprop="url" class="qodef-m-nav qodef--prev" href="<?php echo get_permalink( $post_id ); ?>">
					<?php echo wp_kses_post($post_navigation[ 'prev' ]['image']); ?>
					<div>
						<span class="qodef-m-nav-label"><?php echo wp_kses_post($post_title); ?></span>
						<div class="qodef-m-category">
							<?php foreach ($categories as $cat) { ?>
								<?php echo esc_html($cat->name); ?>
							<?php } ?>
						</div>
					</div>
				</a>
				<?php
			}
			
			if($back_to_link !== '') { ?>
				<div class="qodef-m-nav qodef--backbtn">
					<a itemprop="url" href="<?php echo esc_url($back_to_link); ?>">
						<span class="qodef-circles">
							<span class="qodef-circle qodef-circle-1"></span>
							<span class="qodef-circle qodef-circle-2"></span>
							<span class="qodef-circle qodef-circle-3"></span>
							<span class="qodef-circle qodef-circle-4"></span>
						</span>
					</a>
				</div>
			<?php }
			
			if(isset($post_navigation[ 'next' ]['post'])) {
				$post_title   = $post_navigation[ 'next' ]['post']->post_title;
				$post_id      = $post_navigation[ 'next' ]['post']->ID;
				$categories = wp_get_post_terms($post_id, 'portfolio-category');
				?>
				<a itemprop="url" class="qodef-m-nav qodef--next" href="<?php echo get_permalink( $post_id ); ?>">
					<?php echo wp_kses_post($post_navigation[ 'next' ]['image']); ?>
					<div>
						<span class="qodef-m-nav-label"><?php echo wp_kses_post($post_title); ?></span>
						<div class="qodef-m-category">
							<?php foreach ($categories as $cat) { ?>
								<?php echo esc_html($cat->name); ?>
							<?php } ?>
						</div>
					</div>
				</a>
				<?php
			} ?>
		</div>
	</div>
<?php } ?>