<?php

if ( ! function_exists( 'roisin_core_add_testimonials_list_variation_info_below' ) ) {
	function roisin_core_add_testimonials_list_variation_info_below( $variations ) {
		
		$variations['info-below'] = esc_html__( 'Info Below', 'roisin-core' );
		
		return $variations;
	}
	
	add_filter( 'roisin_core_filter_testimonials_list_layouts', 'roisin_core_add_testimonials_list_variation_info_below' );
}

if ( ! function_exists( 'roisin_core_add_testimonials_list_options_info_below' ) ) {
	function roisin_core_add_testimonials_list_options_info_below( $options ) {
		$info_below_options   = array();
		$margin_option        = array(
			'field_type' => 'text',
			'name'       => 'info_below_content_margin_top',
			'title'      => esc_html__( 'Content Top Margin', 'roisin-core' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'info-below',
						'default_value' => 'default'
					)
				)
			),
			'group'      => esc_html__( 'Layout', 'roisin-core' )
		);
		$info_below_options[] = $margin_option;
		
		return array_merge( $options, $info_below_options );
	}
	
	add_filter( 'roisin_core_filter_testimonials_list_extra_options', 'roisin_core_add_testimonials_list_options_info_below' );
}